/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.wrapper;

import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.ui.savedrequest.SavedRequest;
import org.springframework.security.util.PortResolver;
import org.springframework.security.util.PortResolverImpl;
import org.springframework.security.wrapper.SavedRequestAwareWrapper;

public class SavedRequestAwareWrapperTests {
    @Test
    public void wrappedRequestParameterTakesPrecedenceOverSavedRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("action", "foo");
        SavedRequest savedRequest = new SavedRequest((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
        MockHttpServletRequest request2 = new MockHttpServletRequest();
        request2.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)savedRequest);
        SavedRequestAwareWrapper wrapper = new SavedRequestAwareWrapper((HttpServletRequest)request2, (PortResolver)new PortResolverImpl(), "ROLE_");
        Assert.assertEquals((Object)"foo", (Object)wrapper.getParameter("action"));
        request2.setParameter("action", "bar");
        Assert.assertEquals((Object)"bar", (Object)wrapper.getParameter("action"));
        Assert.assertEquals((long)2L, (long)wrapper.getParameterValues("action").length);
        Assert.assertEquals((Object)"bar", (Object)wrapper.getParameterValues("action")[0]);
    }

    @Test
    public void savedRequestDoesntCreateDuplicateParams() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("action", "foo");
        SavedRequest savedRequest = new SavedRequest((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
        MockHttpServletRequest request2 = new MockHttpServletRequest();
        request2.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)savedRequest);
        request2.setParameter("action", "foo");
        SavedRequestAwareWrapper wrapper = new SavedRequestAwareWrapper((HttpServletRequest)request2, (PortResolver)new PortResolverImpl(), "ROLE_");
        Assert.assertEquals((long)1L, (long)wrapper.getParameterValues("action").length);
        Assert.assertEquals((long)1L, (long)wrapper.getParameterMap().size());
        Assert.assertEquals((long)1L, (long)((String[])wrapper.getParameterMap().get("action")).length);
    }

    @Test
    public void savedRequestHeadersTakePrecedence() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)"foo");
        SavedRequest savedRequest = new SavedRequest((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
        MockHttpServletRequest request2 = new MockHttpServletRequest();
        request2.addHeader("Authorization", (Object)"bar");
        request2.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)savedRequest);
        SavedRequestAwareWrapper wrapper = new SavedRequestAwareWrapper((HttpServletRequest)request2, (PortResolver)new PortResolverImpl(), "ROLE_");
        Assert.assertEquals((Object)"foo", (Object)wrapper.getHeader("Authorization"));
    }

    @Test
    public void getParameterValuesReturnsNullIfParameterIsntSet() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        SavedRequestAwareWrapper wrapper = new SavedRequestAwareWrapper((HttpServletRequest)request, (PortResolver)new PortResolverImpl(), "ROLE_");
        Assert.assertNull((Object)wrapper.getParameterValues("action"));
        Assert.assertNull(wrapper.getParameterMap().get("action"));
    }

    @Test
    public void getParameterValuesReturnsCombinedValues() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("action", "foo");
        SavedRequest savedRequest = new SavedRequest((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
        MockHttpServletRequest request2 = new MockHttpServletRequest();
        request2.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)savedRequest);
        SavedRequestAwareWrapper wrapper = new SavedRequestAwareWrapper((HttpServletRequest)request2, (PortResolver)new PortResolverImpl(), "ROLE_");
        Assert.assertArrayEquals((Object[])new Object[]{"foo"}, (Object[])wrapper.getParameterValues("action"));
        request2.setParameter("action", "bar");
        Assert.assertArrayEquals((Object[])new Object[]{"bar", "foo"}, (Object[])wrapper.getParameterValues("action"));
        String[] valuesFromMap = (String[])wrapper.getParameterMap().get("action");
        Assert.assertEquals((long)2L, (long)valuesFromMap.length);
        Assert.assertEquals((Object)"bar", (Object)valuesFromMap[0]);
    }
}

