/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.webflow.config.FlowBuilderInfo;
import org.springframework.webflow.config.FlowElementAttribute;
import org.springframework.webflow.config.FlowLocation;
import org.w3c.dom.Element;

class FlowRegistryBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String DEFAULT_CONVERSION_SERVICE_CLASS_NAME = "org.springframework.binding.convert.service.DefaultConversionService";
    private static final String DEFAULT_EXPRESSION_PARSER_FACTORY_CLASS_NAME = "org.springframework.webflow.expression.DefaultExpressionParserFactory";
    private static final String FLOW_BUILDER_SERVICES_CLASS_NAME = "org.springframework.webflow.engine.builder.support.FlowBuilderServices";
    private static final String FLOW_REGISTRY_FACTORY_BEAN_CLASS_NAME = "org.springframework.webflow.config.FlowRegistryFactoryBean";
    private static final String MVC_VIEW_FACTORY_CREATOR_CLASS_NAME = "org.springframework.webflow.mvc.builder.MvcViewFactoryCreator";

    FlowRegistryBeanDefinitionParser() {
    }

    protected String getBeanClassName(Element element) {
        return FLOW_REGISTRY_FACTORY_BEAN_CLASS_NAME;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder definitionBuilder) {
        String basePath;
        CompositeComponentDefinition componentDefinition = new CompositeComponentDefinition(element.getLocalName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(componentDefinition);
        this.parseFlowBuilderServices(element, parserContext, definitionBuilder);
        String parent = element.getAttribute("parent");
        if (StringUtils.hasText((String)parent)) {
            definitionBuilder.addPropertyReference("parent", parent);
        }
        if (StringUtils.hasText((String)(basePath = element.getAttribute("base-path")))) {
            definitionBuilder.addPropertyValue("basePath", (Object)basePath);
        }
        definitionBuilder.addPropertyValue("flowLocations", (Object)this.parseLocations(element));
        definitionBuilder.addPropertyValue("flowLocationPatterns", (Object)this.parseLocationPatterns(element));
        definitionBuilder.addPropertyValue("flowBuilders", (Object)this.parseFlowBuilders(element));
        parserContext.popAndRegisterContainingComponent();
    }

    private List parseLocations(Element element) {
        List locationElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow-location");
        if (locationElements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FlowLocation> locations = new ArrayList<FlowLocation>(locationElements.size());
        Iterator it = locationElements.iterator();
        while (it.hasNext()) {
            Element locationElement = (Element)it.next();
            String id = locationElement.getAttribute("id");
            String path = locationElement.getAttribute("path");
            locations.add(new FlowLocation(id, path, this.parseAttributes(locationElement)));
        }
        return locations;
    }

    private List parseLocationPatterns(Element element) {
        List locationPatternElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow-location-pattern");
        if (locationPatternElements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> locationPatterns = new ArrayList<String>(locationPatternElements.size());
        Iterator it = locationPatternElements.iterator();
        while (it.hasNext()) {
            Element locationPatternElement = (Element)it.next();
            String value = locationPatternElement.getAttribute("value");
            locationPatterns.add(value);
        }
        return locationPatterns;
    }

    private Set parseAttributes(Element element) {
        Element definitionAttributesElement = DomUtils.getChildElementByTagName((Element)element, (String)"flow-definition-attributes");
        if (definitionAttributesElement != null) {
            List attributeElements = DomUtils.getChildElementsByTagName((Element)definitionAttributesElement, (String)"attribute");
            HashSet<FlowElementAttribute> attributes = new HashSet<FlowElementAttribute>(attributeElements.size());
            Iterator it = attributeElements.iterator();
            while (it.hasNext()) {
                Element attributeElement = (Element)it.next();
                String name = attributeElement.getAttribute("name");
                String value = attributeElement.getAttribute("value");
                String type = attributeElement.getAttribute("type");
                attributes.add(new FlowElementAttribute(name, value, type));
            }
            return attributes;
        }
        return null;
    }

    private List parseFlowBuilders(Element element) {
        List builderElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow-builder");
        if (builderElements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FlowBuilderInfo> builders = new ArrayList<FlowBuilderInfo>(builderElements.size());
        Iterator it = builderElements.iterator();
        while (it.hasNext()) {
            Element builderElement = (Element)it.next();
            String id = builderElement.getAttribute("id");
            String className = builderElement.getAttribute("class");
            builders.add(new FlowBuilderInfo(id, className, this.parseAttributes(builderElement)));
        }
        return builders;
    }

    private void parseFlowBuilderServices(Element element, ParserContext context, BeanDefinitionBuilder definitionBuilder) {
        String flowBuilderServices = element.getAttribute("flow-builder-services");
        if (!StringUtils.hasText((String)flowBuilderServices)) {
            BeanDefinitionBuilder flowBuilderServicesBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)FLOW_BUILDER_SERVICES_CLASS_NAME);
            BeanDefinitionBuilder conversionServiceBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)DEFAULT_CONVERSION_SERVICE_CLASS_NAME);
            String conversionService = this.registerInfrastructureComponent(element, context, conversionServiceBuilder);
            flowBuilderServicesBuilder.addPropertyReference("conversionService", conversionService);
            BeanDefinitionBuilder expressionParserBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)DEFAULT_EXPRESSION_PARSER_FACTORY_CLASS_NAME);
            expressionParserBuilder.setFactoryMethod("getExpressionParser");
            expressionParserBuilder.addConstructorArgReference(conversionService);
            String expressionParser = this.registerInfrastructureComponent(element, context, expressionParserBuilder);
            flowBuilderServicesBuilder.addPropertyReference("expressionParser", expressionParser);
            BeanDefinitionBuilder viewFactoryCreatorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)MVC_VIEW_FACTORY_CREATOR_CLASS_NAME);
            String viewFactoryCreator = this.registerInfrastructureComponent(element, context, viewFactoryCreatorBuilder);
            flowBuilderServicesBuilder.addPropertyReference("viewFactoryCreator", viewFactoryCreator);
            flowBuilderServices = this.registerInfrastructureComponent(element, context, flowBuilderServicesBuilder);
        }
        definitionBuilder.addPropertyReference("flowBuilderServices", flowBuilderServices);
    }

    private String registerInfrastructureComponent(Element element, ParserContext context, BeanDefinitionBuilder viewFactoryCreatorBuilder) {
        String beanName = context.getReaderContext().generateBeanName((BeanDefinition)viewFactoryCreatorBuilder.getRawBeanDefinition());
        viewFactoryCreatorBuilder.getRawBeanDefinition().setSource(context.extractSource((Object)element));
        viewFactoryCreatorBuilder.getRawBeanDefinition().setRole(2);
        context.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)viewFactoryCreatorBuilder.getBeanDefinition(), beanName));
        return beanName;
    }
}

