/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.easymock;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.easymock.classextension.internal.MocksClassControl;
import org.easymock.internal.MocksControl;
import org.easymock.internal.ReplayState;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.easymock.annotation.AfterCreateMock;
import org.unitils.easymock.annotation.Mock;
import org.unitils.easymock.annotation.RegularMock;
import org.unitils.easymock.util.Calls;
import org.unitils.easymock.util.Dates;
import org.unitils.easymock.util.Defaults;
import org.unitils.easymock.util.InvocationOrder;
import org.unitils.easymock.util.LenientMocksControl;
import org.unitils.easymock.util.Order;
import org.unitils.reflectionassert.ReflectionComparatorMode;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ModuleUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyMockModule
implements Module {
    public static final String PROPKEY_AUTO_VERIFY_AFTER_TEST_ENABLED = "EasyMockModule.autoVerifyAfterTest.enabled";
    private List<MocksControl> mocksControls;
    private Map<Class<? extends Annotation>, Map<String, String>> defaultAnnotationPropertyValues;
    private boolean autoVerifyAfterTestEnabled;

    @Override
    public void init(Properties configuration) {
        this.mocksControls = new ArrayList<MocksControl>();
        this.defaultAnnotationPropertyValues = ModuleUtils.getAnnotationPropertyDefaults(EasyMockModule.class, configuration, RegularMock.class, Mock.class);
        this.autoVerifyAfterTestEnabled = PropertyUtils.getBoolean(PROPKEY_AUTO_VERIFY_AFTER_TEST_ENABLED, configuration);
    }

    @Override
    public void afterInit() {
    }

    @Override
    public TestListener getTestListener() {
        return new EasyMockTestListener();
    }

    public <T> T createRegularMock(Class<T> mockType, InvocationOrder invocationOrder, Calls calls) {
        invocationOrder = ModuleUtils.getEnumValueReplaceDefault(RegularMock.class, "invocationOrder", invocationOrder, this.defaultAnnotationPropertyValues);
        MocksClassControl mocksControl = Calls.LENIENT == (calls = ModuleUtils.getEnumValueReplaceDefault(RegularMock.class, "calls", calls, this.defaultAnnotationPropertyValues)) ? new MocksClassControl(MocksControl.MockType.NICE) : new MocksClassControl(MocksControl.MockType.DEFAULT);
        if (InvocationOrder.STRICT == invocationOrder) {
            mocksControl.checkOrder(true);
        }
        this.mocksControls.add((MocksControl)mocksControl);
        return (T)mocksControl.createMock(mockType);
    }

    public <T> T createMock(Class<T> mockType, InvocationOrder invocationOrder, Calls calls, Order order, Dates dates, Defaults defaults) {
        invocationOrder = ModuleUtils.getEnumValueReplaceDefault(Mock.class, "invocationOrder", invocationOrder, this.defaultAnnotationPropertyValues);
        calls = ModuleUtils.getEnumValueReplaceDefault(Mock.class, "calls", calls, this.defaultAnnotationPropertyValues);
        order = ModuleUtils.getEnumValueReplaceDefault(Mock.class, "order", order, this.defaultAnnotationPropertyValues);
        dates = ModuleUtils.getEnumValueReplaceDefault(Mock.class, "dates", dates, this.defaultAnnotationPropertyValues);
        defaults = ModuleUtils.getEnumValueReplaceDefault(Mock.class, "defaults", defaults, this.defaultAnnotationPropertyValues);
        ArrayList<ReflectionComparatorMode> comparatorModes = new ArrayList<ReflectionComparatorMode>();
        if (Order.LENIENT == order) {
            comparatorModes.add(ReflectionComparatorMode.LENIENT_ORDER);
        }
        if (Dates.LENIENT == dates) {
            comparatorModes.add(ReflectionComparatorMode.LENIENT_DATES);
        }
        if (Defaults.IGNORE_DEFAULTS == defaults) {
            comparatorModes.add(ReflectionComparatorMode.IGNORE_DEFAULTS);
        }
        LenientMocksControl mocksControl = Calls.LENIENT == calls ? new LenientMocksControl(MocksControl.MockType.NICE, comparatorModes.toArray(new ReflectionComparatorMode[0])) : new LenientMocksControl(MocksControl.MockType.DEFAULT, comparatorModes.toArray(new ReflectionComparatorMode[0]));
        if (InvocationOrder.STRICT == invocationOrder) {
            mocksControl.checkOrder(true);
        }
        this.mocksControls.add((MocksControl)mocksControl);
        return (T)mocksControl.createMock(mockType);
    }

    public void replay() {
        for (MocksControl mocksControl : this.mocksControls) {
            mocksControl.replay();
        }
    }

    public void verify() {
        for (MocksControl mocksControl : this.mocksControls) {
            if (!(mocksControl.getState() instanceof ReplayState)) {
                mocksControl.replay();
            }
            mocksControl.verify();
        }
    }

    protected void createAndInjectRegularMocksIntoTest(Object testObject) {
        Set<Field> mockFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), RegularMock.class);
        for (Field mockField : mockFields) {
            Class<?> mockType = mockField.getType();
            RegularMock regularMockAnnotation = mockField.getAnnotation(RegularMock.class);
            Object mockObject = this.createRegularMock(mockType, regularMockAnnotation.invocationOrder(), regularMockAnnotation.calls());
            ReflectionUtils.setFieldValue(testObject, mockField, mockObject);
            this.callAfterCreateMockMethods(testObject, mockObject, mockField.getName(), mockType);
        }
    }

    protected void createAndInjectMocksIntoTest(Object testObject) {
        Set<Field> mockFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), Mock.class);
        for (Field mockField : mockFields) {
            Class<?> mockType = mockField.getType();
            Mock mockAnnotation = mockField.getAnnotation(Mock.class);
            Object mockObject = this.createMock(mockType, mockAnnotation.invocationOrder(), mockAnnotation.calls(), mockAnnotation.order(), mockAnnotation.dates(), mockAnnotation.defaults());
            ReflectionUtils.setFieldValue(testObject, mockField, mockObject);
            this.callAfterCreateMockMethods(testObject, mockObject, mockField.getName(), mockType);
        }
    }

    protected void callAfterCreateMockMethods(Object testObject, Object mockObject, String name, Class<?> type) {
        Set<Method> methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), AfterCreateMock.class);
        for (Method method : methods) {
            try {
                ReflectionUtils.invokeMethod(testObject, method, mockObject, name, type);
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("An exception occurred while invoking an after create mock method.", e);
            }
            catch (Exception e) {
                throw new UnitilsException("Unable to invoke after create mock method. Ensure that this method has following signature: void myMethod(Object mock, String name, Class type)", e);
            }
        }
    }

    protected class EasyMockTestListener
    extends TestListener {
        protected EasyMockTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            EasyMockModule.this.mocksControls.clear();
            EasyMockModule.this.createAndInjectRegularMocksIntoTest(testObject);
            EasyMockModule.this.createAndInjectMocksIntoTest(testObject);
        }

        public void afterTestMethod(Object testObject, Method testMethod, Throwable throwable) {
            if (EasyMockModule.this.autoVerifyAfterTestEnabled && throwable == null) {
                EasyMockModule.this.verify();
            }
        }
    }
}

