/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core;

import java.util.ArrayList;
import java.util.List;
import org.unitils.mock.core.BehaviorDefiningInvocation;
import org.unitils.mock.core.ObservedInvocation;
import org.unitils.mock.core.SyntaxMonitor;
import org.unitils.mock.proxy.ProxyInvocation;
import org.unitils.mock.report.impl.DefaultScenarioReport;
import org.unitils.mock.report.impl.DetailedObservedInvocationsReport;
import org.unitils.mock.report.impl.ObservedInvocationsReport;
import org.unitils.mock.report.impl.SuggestedAssertsReport;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scenario {
    protected List<ObservedInvocation> observedInvocations = new ArrayList<ObservedInvocation>();
    protected List<VerificationStatus> invocationVerificationStatuses = new ArrayList<VerificationStatus>();
    protected Object testObject;
    protected SyntaxMonitor syntaxMonitor = new SyntaxMonitor();

    public Scenario() {
        this(null);
    }

    public Scenario(Object testObject) {
        this.testObject = testObject;
    }

    public Object getTestObject() {
        return this.testObject;
    }

    public SyntaxMonitor getSyntaxMonitor() {
        return this.syntaxMonitor;
    }

    public void addObservedMockInvocation(ObservedInvocation mockInvocation) {
        this.observedInvocations.add(mockInvocation);
        this.invocationVerificationStatuses.add(VerificationStatus.UNVERIFIED);
    }

    public List<ObservedInvocation> getObservedInvocations() {
        return this.observedInvocations;
    }

    public void assertNoMoreInvocations(StackTraceElement[] assertedAt) {
        ArrayList<ObservedInvocation> unexpectedInvocations = new ArrayList<ObservedInvocation>();
        for (int i = 0; i < this.observedInvocations.size(); ++i) {
            ObservedInvocation observedInvocation = this.observedInvocations.get(i);
            VerificationStatus invocationVerificationStatus = this.invocationVerificationStatuses.get(i);
            if (observedInvocation.getMockBehavior() != null || invocationVerificationStatus != VerificationStatus.UNVERIFIED) continue;
            unexpectedInvocations.add(observedInvocation);
        }
        if (unexpectedInvocations.size() != 0) {
            AssertionError assertionError = new AssertionError((Object)this.getNoMoreInvocationsErrorMessage(unexpectedInvocations, assertedAt[0]));
            ((Throwable)((Object)assertionError)).setStackTrace(assertedAt);
            throw assertionError;
        }
    }

    public void assertInvoked(BehaviorDefiningInvocation assertInvocation, StackTraceElement[] assertedAt) {
        for (int i = 0; i < this.observedInvocations.size(); ++i) {
            ObservedInvocation observedInvocation = this.observedInvocations.get(i);
            VerificationStatus invocationVerificationStatus = this.invocationVerificationStatuses.get(i);
            if (invocationVerificationStatus != VerificationStatus.UNVERIFIED || !assertInvocation.matches(observedInvocation)) continue;
            this.invocationVerificationStatuses.set(i, VerificationStatus.VERIFIED);
            return;
        }
        AssertionError assertionError = new AssertionError((Object)this.getAssertInvokedErrorMessage(assertInvocation, assertedAt[0]));
        ((Throwable)((Object)assertionError)).setStackTrace(assertedAt);
        throw assertionError;
    }

    public void assertInvokedInOrder(BehaviorDefiningInvocation behaviorDefiningInvocation, StackTraceElement[] assertedAt) {
        ObservedInvocation matchingInvocation = null;
        for (int i = 0; i < this.observedInvocations.size(); ++i) {
            ObservedInvocation observedInvocation = this.observedInvocations.get(i);
            VerificationStatus invocationVerificationStatus = this.invocationVerificationStatuses.get(i);
            if (matchingInvocation == null && invocationVerificationStatus == VerificationStatus.UNVERIFIED && behaviorDefiningInvocation.matches(observedInvocation)) {
                this.invocationVerificationStatuses.set(i, VerificationStatus.VERIFIED_IN_ORDER);
                matchingInvocation = observedInvocation;
                continue;
            }
            if (matchingInvocation == null || invocationVerificationStatus != VerificationStatus.VERIFIED_IN_ORDER) continue;
            AssertionError assertionError = new AssertionError((Object)this.getInvokedOutOfOrderErrorMessage(behaviorDefiningInvocation, matchingInvocation, observedInvocation, assertedAt[0]));
            ((Throwable)((Object)assertionError)).setStackTrace(assertedAt);
            throw assertionError;
        }
        if (matchingInvocation == null) {
            AssertionError assertionError = new AssertionError((Object)this.getAssertInvokedErrorMessage(behaviorDefiningInvocation, assertedAt[0]));
            ((Throwable)((Object)assertionError)).setStackTrace(assertedAt);
            throw assertionError;
        }
    }

    public void assertNotInvoked(BehaviorDefiningInvocation behaviorDefiningInvocation, StackTraceElement[] assertedAt) {
        for (int i = 0; i < this.observedInvocations.size(); ++i) {
            ObservedInvocation observedInvocation = this.observedInvocations.get(i);
            VerificationStatus invocationVerificationStatus = this.invocationVerificationStatuses.get(i);
            if (invocationVerificationStatus != VerificationStatus.UNVERIFIED || !behaviorDefiningInvocation.matches(observedInvocation)) continue;
            AssertionError assertionError = new AssertionError((Object)this.getAssertNotInvokedErrorMessage(behaviorDefiningInvocation, observedInvocation, assertedAt));
            ((Throwable)((Object)assertionError)).setStackTrace(assertedAt);
            throw assertionError;
        }
    }

    public String createFullReport() {
        DefaultScenarioReport fullScenarioReport = new DefaultScenarioReport();
        return fullScenarioReport.createReport(this);
    }

    public String createObservedInvocationsReport() {
        ObservedInvocationsReport observedInvocationsReport = new ObservedInvocationsReport();
        return observedInvocationsReport.createReport(this.getObservedInvocations());
    }

    public String createDetailedObservedInvocationsReport() {
        DetailedObservedInvocationsReport observedInvocationsReport = new DetailedObservedInvocationsReport();
        return observedInvocationsReport.createReport(this.getObservedInvocations());
    }

    public String createSuggestedAssertsReport() {
        SuggestedAssertsReport suggestedAssertsReport = new SuggestedAssertsReport();
        return suggestedAssertsReport.createReport(this.testObject, this.getObservedInvocations());
    }

    protected String getAssertNotInvokedErrorMessage(ProxyInvocation proxyInvocation, ObservedInvocation unexpectedInvocation, StackTraceElement[] assertedAt) {
        StringBuilder message = new StringBuilder();
        message.append("Expected no invocation of ");
        message.append(ReflectionUtils.getSimpleMethodName(proxyInvocation.getMethod()));
        message.append(", but it did occur.\nat ");
        message.append(unexpectedInvocation.getInvokedAt());
        message.append("\n");
        message.append(this.getAssertLocationIndication(assertedAt[0]));
        message.append("\n\n");
        message.append(this.createFullReport());
        return message.toString();
    }

    protected String getAssertInvokedErrorMessage(ProxyInvocation proxyInvocation, StackTraceElement invokedAt) {
        StringBuilder message = new StringBuilder();
        message.append("Expected invocation of ");
        message.append(ReflectionUtils.getSimpleMethodName(proxyInvocation.getMethod()));
        message.append(", but it didn't occur.\n");
        message.append(this.getAssertLocationIndication(invokedAt));
        message.append("\n\n");
        message.append(this.createFullReport());
        return message.toString();
    }

    protected String getInvokedOutOfOrderErrorMessage(BehaviorDefiningInvocation behaviorDefiningInvocation, ObservedInvocation matchingInvocation, ObservedInvocation outOfOrderInvocation, StackTraceElement assertedAt) {
        StringBuilder message = new StringBuilder();
        message.append("Invocation of ");
        message.append(ReflectionUtils.getSimpleMethodName(matchingInvocation.getMethod()));
        message.append(" was expected to be performed after ");
        message.append(ReflectionUtils.getSimpleMethodName(outOfOrderInvocation.getMethod()));
        message.append(" but actually occurred before it.\n");
        message.append(this.getAssertLocationIndication(assertedAt));
        message.append("\n\n");
        message.append(this.createFullReport());
        return message.toString();
    }

    protected String getNoMoreInvocationsErrorMessage(List<ObservedInvocation> unexpectedInvocations, StackTraceElement assertedAt) {
        StringBuilder message = new StringBuilder();
        message.append("No more invocations expected, yet observed following calls:\n");
        message.append(new ObservedInvocationsReport().createReport(unexpectedInvocations));
        message.append("\n");
        message.append(this.getAssertLocationIndication(assertedAt));
        message.append("\n\n");
        message.append(this.createFullReport());
        return message.toString();
    }

    protected String getAssertLocationIndication(StackTraceElement assertedAt) {
        return "asserted at " + assertedAt.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum VerificationStatus {
        UNVERIFIED,
        VERIFIED,
        VERIFIED_IN_ORDER;

    }
}

