/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.report.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.unitils.mock.core.ObservedInvocation;
import org.unitils.mock.core.Scenario;
import org.unitils.mock.report.ScenarioReport;
import org.unitils.mock.report.impl.DetailedObservedInvocationsReport;
import org.unitils.mock.report.impl.ObservedInvocationsReport;
import org.unitils.mock.report.impl.SuggestedAssertsReport;

public class DefaultScenarioReport
implements ScenarioReport {
    public String createReport(Scenario scenario) {
        StringBuilder result = new StringBuilder();
        List<ObservedInvocation> observedInvocations = scenario.getObservedInvocations();
        if (observedInvocations.isEmpty()) {
            return "No invocations observed.\n";
        }
        result.append("Observed scenario:\n\n");
        result.append(new ObservedInvocationsReport().createReport(observedInvocations));
        result.append("\n");
        result.append("Suggested assert statements:\n\n");
        String suggestedAssertsReport = new SuggestedAssertsReport().createReport(scenario.getTestObject(), observedInvocations);
        if (StringUtils.isNotEmpty((String)suggestedAssertsReport)) {
            result.append(suggestedAssertsReport);
            result.append("\n");
        }
        result.append("Detailed scenario:\n\n");
        result.append(new DetailedObservedInvocationsReport().createReport(observedInvocations));
        return result.toString();
    }
}

