/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.cache;

import com.jaspersoft.jasperserver.war.cascade.cache.SessionCache;
import java.util.Map;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheCleaner
extends TimerTask {
    private Map<String, SessionCache> userCachePool;
    private long userCacheTimeout;

    public CacheCleaner(Map<String, SessionCache> userCachePool, long userCacheTimeout) {
        this.userCachePool = userCachePool;
        this.userCacheTimeout = userCacheTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long curTime = System.currentTimeMillis();
        Map<String, SessionCache> map = this.userCachePool;
        synchronized (map) {
            for (String key : this.userCachePool.keySet()) {
                SessionCache cache = this.userCachePool.get(key);
                if (curTime - cache.getLastInteraction() <= this.userCacheTimeout) continue;
                this.userCachePool.remove(key);
            }
        }
    }
}

