/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.token;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.EngineServiceImpl;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.war.action.ReportParametersUtils;
import com.jaspersoft.jasperserver.war.cascade.ControlLogic;
import com.jaspersoft.jasperserver.war.cascade.EventEnvelope;
import com.jaspersoft.jasperserver.war.cascade.EventOption;
import com.jaspersoft.jasperserver.war.cascade.cache.SessionCache;
import com.jaspersoft.jasperserver.war.cascade.token.ControlMapWrapper;
import com.jaspersoft.jasperserver.war.cascade.token.FilterResolver;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.RuntimeInputControlWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.log4j.Logger;
import org.directwebremoting.WebContextFactory;
import org.springframework.context.i18n.LocaleContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenControlLogic
implements ControlLogic {
    private static final String COLUMN_VALUE_SEPARATOR = " | ";
    private static final int COLUMN_VALUE_SEPARATOR_LENGTH = " | ".length();
    public static final String C_DASHBOARD_PREFIX = "input_";
    private static Logger log = Logger.getLogger(TokenControlLogic.class);
    private RepositoryService repositoryService;
    private EngineService engine;
    private DataSourceServiceFactory dsFactories;
    private FilterResolver filterResolver;

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repository) {
        this.repositoryService = repository;
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    public DataSourceServiceFactory getdataSourceServiceFactories() {
        return this.dsFactories;
    }

    public void setdataSourceServiceFactories(DataSourceServiceFactory dsFactories) {
        this.dsFactories = dsFactories;
    }

    public FilterResolver getFilterResolver() {
        return this.filterResolver;
    }

    public void setFilterResolver(FilterResolver filterResolver) {
        this.filterResolver = filterResolver;
    }

    protected ExecutionContext getExecutionContext() {
        EngineServiceImpl cfr_ignored_0 = (EngineServiceImpl)this.engine;
        return EngineServiceImpl.getRuntimeExecutionContext();
    }

    @Override
    public List<EventEnvelope> initialize(String reportUri, List<EventEnvelope> envelopes, SessionCache cache) {
        return this.handleEvents(reportUri, envelopes, cache);
    }

    protected void replaceWithNullSubstitute(EventEnvelope env) {
        for (EventOption opt : env.getOptionsList()) {
            if (!"~NULL~".equals(opt.getValue())) continue;
            opt.setValue(null);
            if (env.getControlType() != 4 && env.getControlType() != 9) continue;
            env.setControlValue("~NULL~");
        }
    }

    @Override
    public List<EventEnvelope> handleEvents(String reportUri, List<EventEnvelope> envelopes, SessionCache cache) {
        boolean isDashboard = false;
        for (EventEnvelope env : envelopes) {
            if (!env.getControlName().startsWith(C_DASHBOARD_PREFIX)) continue;
            isDashboard = true;
            this.removePrefix(C_DASHBOARD_PREFIX, env);
        }
        Map<String, Object> parameterValues = this.getParameterValues(envelopes);
        if (!"".equals(reportUri)) {
            ExecutionContext context = JasperServerUtil.getExecutionContext(LocaleContextHolder.getLocale());
            Map defaultValues = this.engine.getReportInputControlDefaultValues(context, reportUri, null);
            Set<String> keys = parameterValues.keySet();
            for (String key : keys) {
                defaultValues.remove(key);
            }
            parameterValues.putAll(defaultValues);
        }
        for (EventEnvelope queryEnvelope : envelopes) {
            this.processEnvelope(reportUri, cache, parameterValues, queryEnvelope);
        }
        if (isDashboard) {
            for (EventEnvelope env : envelopes) {
                this.addPrefix(C_DASHBOARD_PREFIX, env);
            }
        }
        return envelopes;
    }

    protected void processEnvelope(String reportUri, SessionCache cache, Map<String, Object> parameterValues, EventEnvelope queryEnvelope) {
        this.replaceWithNullSubstitute(queryEnvelope);
        int controlType = queryEnvelope.getControlType();
        if (controlType == 7 || controlType == 4 || controlType == 9 || controlType == 11) {
            this.executeQuery(reportUri, parameterValues, queryEnvelope, cache);
        } else {
            queryEnvelope.setPermanent(true);
        }
    }

    @Override
    public List<EventEnvelope> autoPopulate(String reportUri, List<EventEnvelope> envelopes, String lookupKey, SessionCache cache) {
        return this.handleEvents(reportUri, envelopes, cache);
    }

    protected void addPrefix(String prefixString, EventEnvelope env) {
        env.setControlName(prefixString + env.getControlName());
    }

    protected Map<String, Object> getParameterValues(List<EventEnvelope> envelopes) {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        for (EventEnvelope travEnvelope : envelopes) {
            parameterValues.put(travEnvelope.getControlName(), this.resolveStateForParameter(travEnvelope));
        }
        return parameterValues;
    }

    protected void removePrefix(String prefixString, EventEnvelope env) {
        String currentName = env.getControlName();
        currentName = currentName.substring(prefixString.length());
        env.setControlName(currentName);
    }

    protected Object resolveStateForParameter(EventEnvelope envelope) {
        if (TokenControlLogic.isMultiOption(envelope)) {
            List<EventOption> selections = envelope.getOptionsList();
            ArrayList<String> selectionsAsParameter = new ArrayList<String>(selections.size());
            for (EventOption eo : selections) {
                if (!eo.isSelected()) continue;
                selectionsAsParameter.add(eo.getValue());
            }
            return selectionsAsParameter;
        }
        return envelope.getControlValue();
    }

    protected void populateControlStates(List<EventEnvelope> envelopes, HashMap<String, ControlMapWrapper> persistentControlMap) {
        for (int t = 0; t < envelopes.size(); ++t) {
            EventEnvelope currentEnv = envelopes.get(t);
            ControlMapWrapper cmw = null;
            if (t > 0) {
                ControlMapWrapper prevWrap = persistentControlMap.get(envelopes.get(t - 1).getResourceUriPrefix());
                cmw = new ControlMapWrapper(envelopes.get(t), prevWrap);
                persistentControlMap.put(currentEnv.getResourceUriPrefix(), cmw);
                prevWrap.setNextControl(cmw);
                continue;
            }
            cmw = new ControlMapWrapper(envelopes.get(t));
            persistentControlMap.put(currentEnv.getResourceUriPrefix(), cmw);
        }
    }

    protected void executeQuery(String reportUri, Map parameterValues, EventEnvelope envelope, SessionCache cache) {
        List wrappers;
        if (envelope == null) {
            return;
        }
        String rawQueryString = "";
        String resourceUri = envelope.getResourceUriPrefix();
        ExecutionContext context = JasperServerUtil.getExecutionContext(LocaleContextHolder.getLocale());
        Resource resource = this.repositoryService.getResource(context = EngineServiceImpl.getRuntimeExecutionContext((ExecutionContext)context), resourceUri);
        if (!(resource instanceof InputControl)) {
            return;
        }
        InputControl control = (InputControl)resource;
        String valueColumn = control.getQueryValueColumn();
        String[] visibleColumns = control.getQueryVisibleColumns();
        ResourceReference queryReference = control.getQuery();
        ResourceReference dataSourceRef = null;
        Resource queryResObj = null;
        envelope.setMandatory(control.isMandatory());
        if (queryReference == null) {
            envelope.setPermanent(true);
            return;
        }
        queryResObj = this.getFinalResource(context, queryReference);
        if (queryResObj instanceof Query) {
            rawQueryString = ((Query)queryResObj).getSql();
            dataSourceRef = ((Query)queryResObj).getDataSource();
        }
        if ((wrappers = this.getWrappers(envelope.getWrappersUUID())) != null) {
            for (RuntimeInputControlWrapper wrapper : wrappers) {
                if (!wrapper.getInputControl().getName().equals(envelope.getControlName())) continue;
                Object value = null;
                if (TokenControlLogic.isMultiOption(envelope)) {
                    value = new ArrayList();
                    for (EventOption eventOption : envelope.getOptionsList()) {
                        if (!eventOption.isSelected()) continue;
                        ((List)value).add(eventOption.getValue());
                    }
                } else {
                    for (EventOption eventOption : envelope.getOptionsList()) {
                        if (!eventOption.isSelected()) continue;
                        value = eventOption.getValue();
                        break;
                    }
                }
                ReportParametersUtils.setInputControlParameterValue(wrapper, value, this.repositoryService);
            }
        }
        if (dataSourceRef == null) {
            envelope.setPermanent(true);
            return;
        }
        ReportDataSource dataSource = (ReportDataSource)this.getFinalResource(context, dataSourceRef);
        if (this.getFilterResolver().paramTestNeedsDataSourceInit(dataSource)) {
            ReportDataSourceService dataSourceService = this.engine.createDataSourceService(dataSource);
            dataSourceService.setReportParameterValues(parameterValues);
        }
        if (!this.getFilterResolver().hasParameters(rawQueryString, parameterValues)) {
            envelope.setPermanent(true);
            return;
        }
        Object queryKey = this.getFilterResolver().getCacheKey(rawQueryString, parameterValues);
        if (queryKey == null) {
            return;
        }
        String lookupKey = reportUri + "|" + control.getName() + "|" + queryKey;
        LinkedMap inputData = null;
        if (cache != null) {
            Object cacheInputData = cache.getCacheInfo(this.getClass(), lookupKey);
            if (log.isDebugEnabled()) {
                log.debug((Object)("query result " + (cacheInputData == null ? "not found" : "found    ") + " for key " + lookupKey));
            }
            if (cacheInputData != null && cacheInputData instanceof LinkedMap) {
                inputData = (LinkedMap)cacheInputData;
            }
        }
        if (inputData == null) {
            OrderedMap results = this.engine.executeQuery(null, queryReference, valueColumn, visibleColumns, dataSourceRef, parameterValues);
            inputData = new LinkedMap();
            for (Map.Entry entry : results.entrySet()) {
                Object keyValue = entry.getKey();
                String[] columnValues = (String[])entry.getValue();
                String columnValuesString = "";
                if (columnValues != null && columnValues.length > 0) {
                    StringBuffer visibleColumnBuffer = new StringBuffer();
                    for (int i = 0; i < columnValues.length; ++i) {
                        visibleColumnBuffer.append(COLUMN_VALUE_SEPARATOR);
                        visibleColumnBuffer.append(columnValues[i] != null ? columnValues[i] : "");
                    }
                    columnValuesString = visibleColumnBuffer.substring(COLUMN_VALUE_SEPARATOR_LENGTH);
                }
                inputData.put((Object)(keyValue == null ? null : keyValue.toString()), (Object)new Object[]{keyValue, columnValuesString});
            }
            if (cache != null) {
                cache.setCacheInfo(this.getClass(), lookupKey, inputData);
            }
        }
        boolean isQueryResultsDifferent = true;
        if (wrappers != null) {
            for (RuntimeInputControlWrapper wrapper : wrappers) {
                if (!wrapper.getInputControl().getName().equals(envelope.getControlName())) continue;
                isQueryResultsDifferent = this.isQueryResultsDifferent(wrapper.getQueryResults(), (Map)inputData);
                wrapper.setQueryResults((Map)inputData);
            }
        }
        ArrayList<EventOption> opList = new ArrayList<EventOption>();
        HashSet<String> previousSelections = new HashSet<String>();
        for (EventOption eo : envelope.getOptionsList()) {
            if (!eo.isSelected()) continue;
            previousSelections.add(eo.getValue());
        }
        if (!control.isMandatory() && control.getType() == 4 || control.getType() == 3) {
            opList.add(new EventOption("[NULL]", "~NULL~", previousSelections.contains("~NULL~")));
        }
        boolean setFirstInListSelected = true;
        MapIterator resultIterator = inputData.mapIterator();
        while (resultIterator.hasNext()) {
            resultIterator.next();
            Object[] valSet = (Object[])resultIterator.getValue();
            String valString = String.valueOf(valSet[0]);
            String labelString = String.valueOf(valSet[1]);
            boolean previouslySelected = previousSelections.contains(valString);
            if (previouslySelected) {
                setFirstInListSelected = false;
            }
            opList.add(new EventOption(labelString, valString, previouslySelected));
        }
        if (setFirstInListSelected && !opList.isEmpty() && control.isMandatory() && isQueryResultsDifferent) {
            ((EventOption)opList.get(0)).setSelected(true);
        }
        envelope.setOptionsList(opList);
        if (TokenControlLogic.isMultiOption(envelope)) {
            if (opList.size() > 0) {
                parameterValues.put(control.getName(), this.resolveStateForParameter(envelope));
            }
        } else if (envelope.getControlValue().length() > 0 && opList.size() > 0) {
            boolean overwriteValue = true;
            for (EventOption op : opList) {
                if (!op.getValue().equalsIgnoreCase(envelope.getControlValue())) continue;
                op.setSelected(true);
                overwriteValue = false;
                break;
            }
            if (overwriteValue) {
                envelope.setControlValue(((EventOption)opList.get(0)).getValue());
                parameterValues.put(control.getName(), ((EventOption)opList.get(0)).getValue());
            } else {
                parameterValues.put(control.getName(), envelope.getControlValue());
            }
        } else if (envelope.getControlValue().length() == 0 && opList.size() > 0) {
            if (control.isMandatory()) {
                envelope.setControlValue(((EventOption)opList.get(0)).getValue());
                parameterValues.put(control.getName(), ((EventOption)opList.get(0)).getValue());
            }
        } else {
            envelope.setControlValue("");
        }
    }

    private boolean isQueryResultsDifferent(Map oldQueryResults, Map newQueryResults) {
        if (oldQueryResults.size() != newQueryResults.size()) {
            return true;
        }
        for (Object key : oldQueryResults.keySet()) {
            Object[] oldValSet = (Object[])oldQueryResults.get(key);
            Object[] newValSet = (Object[])newQueryResults.get(key);
            if (newValSet == null || oldValSet.length != newValSet.length) {
                return true;
            }
            for (int i = 0; i < oldValSet.length; ++i) {
                if ((oldValSet[i] != null || newValSet[i] == null) && oldValSet[i].equals(newValSet[i])) continue;
                return true;
            }
        }
        return false;
    }

    private List getWrappers(String wrappersUUID) {
        Map wrappersMap = (Map)WebContextFactory.get().getSession().getAttribute("wrappers");
        if (wrappersMap != null) {
            return (List)wrappersMap.get(wrappersUUID);
        }
        return null;
    }

    public static boolean isMultiOption(EventEnvelope envelope) {
        int controlType = envelope.getControlType();
        return controlType == 6 || controlType == 7 || controlType == 10 || controlType == 11;
    }

    protected Resource getFinalResource(ExecutionContext context, ResourceReference res) {
        Resource finalRes = res.isLocal() ? res.getLocalResource() : this.repositoryService.getResource(context, res.getReferenceURI());
        return finalRes;
    }
}

