/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogSettingsController
implements Controller,
ResourceLoaderAware {
    private static Logger log = Logger.getLogger(LogSettingsController.class);
    private Map<String, String> loggers = new LinkedHashMap<String, String>();
    private Map<String, String> loggerDescriptions;
    private List<String> loggerDescriptionFiles = new ArrayList<String>();
    private ResourceLoader resourceLoader;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String loggerArg = request.getParameter("logger");
        String levelArg = request.getParameter("level");
        this.initLoggerDescriptions();
        if (loggerArg != null && levelArg != null) {
            Logger log = Logger.getLogger((String)loggerArg);
            log.setLevel(Level.toLevel((String)levelArg));
            this.loggers.put(loggerArg, levelArg);
        }
        for (String l : this.loggers.keySet()) {
            Logger log = Logger.getLogger((String)l);
            Level level = log.getEffectiveLevel();
            this.loggers.put(l, level.toString());
        }
        ModelAndView mav = new ModelAndView("modules/administer/logSettings");
        mav.addObject("loggers", this.loggers);
        mav.addObject("loggerDesc", this.loggerDescriptions);
        return mav;
    }

    private void initLoggerDescriptions() {
        if (this.loggerDescriptions != null) {
            return;
        }
        this.loggerDescriptions = new LinkedHashMap<String, String>();
        if (this.loggerDescriptionFiles != null) {
            for (String file : this.loggerDescriptionFiles) {
                try {
                    String props = this.loadWebappFile(file);
                    if (props == null) continue;
                    Properties p = new Properties();
                    p.load(new ByteArrayInputStream(props.getBytes()));
                    for (Object key : p.keySet()) {
                        String keyStr = (String)key;
                        this.loggerDescriptions.put(keyStr, p.getProperty(keyStr));
                        this.loggers.put(keyStr, null);
                    }
                }
                catch (IOException e) {
                    log.warn((Object)"problem loading log descriptions", (Throwable)e);
                }
            }
        }
    }

    private String loadWebappFile(String path) throws IOException {
        int n;
        Resource test = this.resourceLoader.getResource(path);
        InputStream is = test.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((n = is.read(bytes)) > 0) {
            baos.write(bytes, 0, n);
        }
        return baos.toString();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public List<String> getLoggerDescriptionFiles() {
        return this.loggerDescriptionFiles;
    }

    public void setLoggerDescriptionFiles(List<String> loggerDescriptionFiles) {
        this.loggerDescriptionFiles = loggerDescriptionFiles;
    }
}

