/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.tags;

import com.jaspersoft.jasperserver.war.dto.RuntimeInputControlWrapper;
import com.jaspersoft.jasperserver.war.tags.BaseTagSupport;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class InputControlLabelTag
extends BaseTagSupport {
    protected static final Log log = LogFactory.getLog(InputControlLabelTag.class);
    public static final String DEFAULT_LABEL_JSP = "/WEB-INF/jsp/modules/inputControls/InputControlLabel.jsp";
    public static final String INPUT_CONTROL_ATTRIBUTE_NAME = "control";
    public static final String CONTROL_LABEL_ATTRIBUTE_NAME = "controlLabel";
    public static final String KEY_PREAMBLE = "$R{";
    public static final String KEY_POSTAMBLE = "}";
    private RuntimeInputControlWrapper control;
    private MessageSource messageSource;
    private String labelJsp;

    protected int doStartTagInternal() {
        return 0;
    }

    public int doEndTag() throws JspException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(INPUT_CONTROL_ATTRIBUTE_NAME, this.getControl());
        attributes.put(CONTROL_LABEL_ATTRIBUTE_NAME, this.resolveLabel());
        this.includeNested(this.getLabelJsp(), attributes);
        return 6;
    }

    public String resolveLabel() {
        String promptLabel = this.control.getControlInfo().getPromptLabel();
        String label = promptLabel != null && promptLabel.length() > 0 ? promptLabel : this.control.getInputControl().getLabel();
        Pattern p = Pattern.compile("^\\$R\\{(.+)\\}(.*)$");
        Matcher m = p.matcher(label);
        if (m.matches() && this.messageSource != null) {
            String labelKey = m.group(1);
            String labelPostfix = m.group(2);
            try {
                label = this.messageSource.getMessage(labelKey, null, LocaleContextHolder.getLocale());
            }
            catch (Exception ex) {
                // empty catch block
            }
            label = label + labelPostfix;
        }
        return label;
    }

    public RuntimeInputControlWrapper getControl() {
        return this.control;
    }

    public void setControl(RuntimeInputControlWrapper control) {
        this.control = control;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String getLabelJsp() {
        String jsp = this.labelJsp;
        if (jsp == null) {
            jsp = DEFAULT_LABEL_JSP;
        }
        return jsp;
    }

    public void setLabelJsp(String labelJsp) {
        this.labelJsp = labelJsp;
    }
}

