/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.tags;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.war.action.hyperlinks.HyperlinkProducerFactoryFlowFactory;
import com.jaspersoft.jasperserver.war.tags.JasperViewerTag;
import com.jaspersoft.jasperserver.war.util.JRHtmlExportUtils;
import com.jaspersoft.jasperserver.war.util.SessionObjectSerieAccessor;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public class JasperDashboardViewerTag
extends RequestContextAwareTag {
    protected static final Log log = LogFactory.getLog(JasperViewerTag.class);
    public static final String DEFAULT_RENDER_JSP = "/WEB-INF/jsp/modules/JasperDashboardViewer.jsp";
    public static final String DEFAULT_JASPER_PRINT_ATTRIBUTE = "jasperPrint";
    public static final String DEFAULT_PAGE_INDEX_ATTRIBUTE = "pageIndex";
    public static final String DEFAULT_LINK_PRODUCER_FACTORY_ATTRIBUTE = "hyperlinkHandlerFactory";
    public static final String EMPTY_REPORT_ATTRIBUTE = "emptyReport";
    protected static final String JASPER_PRINT_ACCESSOR_BEAN_NAME = "jasperPrintAccessor";
    public static final String INNER_PAGINATION_ATTRIBUTE = "innerPagination";
    private boolean innerPagination;
    private String imageServlet;
    private String page;
    private String renderJsp;
    private String providedExporterClassName;
    private Map exporterParameters;
    private String jasperPrintAttribute = "jasperPrint";
    private String pageIndexAttribute = "pageIndex";
    private String linkProducerFactoryAttribute = "hyperlinkHandlerFactory";

    protected int doStartTagInternal() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        try {
            JasperPrint jasperPrint = this.getJasperPrint(request);
            if (jasperPrint == null) {
                log.error((Object)"There is no JasperPrint object cannot be accessed.");
                return 6;
            }
            request.setAttribute("page", (Object)this.page);
            request.setAttribute(INNER_PAGINATION_ATTRIBUTE, (Object)this.innerPagination);
            boolean emptyReport = jasperPrint.getPages().isEmpty();
            request.setAttribute(EMPTY_REPORT_ATTRIBUTE, (Object)emptyReport);
            if (!emptyReport) {
                Integer pageIndex = (Integer)request.getAttribute(this.getPageIndexAttribute());
                if (pageIndex == null) {
                    pageIndex = new Integer(0);
                }
                int lastPageIndex = jasperPrint.getPages().size() - 1;
                request.setAttribute(DEFAULT_PAGE_INDEX_ATTRIBUTE, (Object)pageIndex);
                request.setAttribute("lastPageIndex", (Object)new Integer(lastPageIndex));
                JRHtmlExporter exporter = new JRHtmlExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, (Object)new Boolean(true));
                exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)pageIndex);
                String imageURI = response.encodeURL(this.imageServlet + "image=");
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)imageURI);
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)"");
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, (Object)"");
                exporter.setParameter((JRExporterParameter)JRHtmlExportUtils.PARAMETER_HTTP_REQUEST, (Object)request);
                HyperlinkProducerFactoryFlowFactory linkProducerFactory = (HyperlinkProducerFactoryFlowFactory)request.getAttribute(this.getLinkProducerFactoryAttribute());
                if (linkProducerFactory != null) {
                    JRHyperlinkProducerFactory hyperlinkProducerFactory = linkProducerFactory.getHyperlinkProducerFactory(request, response);
                    exporter.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)hyperlinkProducerFactory);
                }
                request.setAttribute("exporter", (Object)exporter);
            }
            BodyContent nestedContent = this.pageContext.pushBody();
            boolean popped = false;
            try {
                this.pageContext.include(this.getRenderJsp());
                popped = true;
                this.pageContext.popBody();
                nestedContent.writeOut((Writer)this.pageContext.getOut());
            }
            finally {
                if (!popped) {
                    this.pageContext.popBody();
                }
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e, (Throwable)e);
            }
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    protected JasperPrint getJasperPrint(HttpServletRequest request) {
        JasperPrint jasperPrint;
        SessionObjectSerieAccessor jasperPrintAccessor = this.getJasperPrintAccessor();
        ReportUnitResult result = (ReportUnitResult)jasperPrintAccessor.getObject(request, this.getJasperPrintAttribute());
        JasperPrint jasperPrint2 = jasperPrint = result == null ? null : result.getJasperPrint();
        if (jasperPrint == null) {
            throw new JSException("jsexception.jasperprint.not.found", new Object[]{this.getJasperPrintAttribute()});
        }
        return jasperPrint;
    }

    protected SessionObjectSerieAccessor getJasperPrintAccessor() {
        WebApplicationContext applicationContext = this.getRequestContext().getWebApplicationContext();
        SessionObjectSerieAccessor jasperPrintAccessor = (SessionObjectSerieAccessor)applicationContext.getBean(JASPER_PRINT_ACCESSOR_BEAN_NAME, SessionObjectSerieAccessor.class);
        return jasperPrintAccessor;
    }

    public String getImageServlet() {
        return this.imageServlet;
    }

    public void setImageServlet(String imageServlet) {
        this.imageServlet = imageServlet;
    }

    public void setInnerPagination(String innerPagination) {
        this.innerPagination = innerPagination.equals("true");
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getRenderJsp() {
        if (this.renderJsp == null || this.renderJsp.trim().length() == 0) {
            return DEFAULT_RENDER_JSP;
        }
        return this.renderJsp;
    }

    public void setRenderJsp(String renderJsp) {
        this.renderJsp = renderJsp;
    }

    public String getExporterClassName() {
        return this.providedExporterClassName;
    }

    public void setExporterClassName(String exporterClassName) {
        this.providedExporterClassName = exporterClassName;
    }

    public Map getExporterParameters() {
        return this.exporterParameters;
    }

    public void setExporterParameters(Map exporterParameters) {
        this.exporterParameters = exporterParameters;
    }

    private JRExporter defaultExporter(JasperPrint jasperPrint, Integer pageIndex) {
        JRHtmlExporter exporter = new JRHtmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, (Object)new Boolean(true));
        exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)pageIndex);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)(this.imageServlet + "?image="));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)"");
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, (Object)"");
        return exporter;
    }

    private JRExporter providedExporter(JasperPrint jasperPrint, Integer pageIndex) throws Exception {
        Class<?> exporterClass = Class.forName(this.providedExporterClassName);
        JRExporter exporter = (JRExporter)exporterClass.newInstance();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, (Object)new Boolean(true));
        exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)pageIndex);
        return exporter;
    }

    private void setParameters(JRExporter exporter) {
        if (this.exporterParameters == null || this.exporterParameters.size() == 0) {
            return;
        }
        for (Map.Entry entry : this.exporterParameters.entrySet()) {
            exporter.setParameter((JRExporterParameter)entry.getKey(), entry.getValue());
        }
    }

    public String getJasperPrintAttribute() {
        return this.jasperPrintAttribute;
    }

    public void setJasperPrintAttribute(String jasperPrintAccessorAttribute) {
        this.jasperPrintAttribute = jasperPrintAccessorAttribute;
    }

    public String getPageIndexAttribute() {
        return this.pageIndexAttribute;
    }

    public void setPageIndexAttribute(String pageIndexAttribute) {
        this.pageIndexAttribute = pageIndexAttribute;
    }

    public String getLinkProducerFactoryAttribute() {
        return this.linkProducerFactoryAttribute;
    }

    public void setLinkProducerFactoryAttribute(String linkHandlerFactoryAttribute) {
        this.linkProducerFactoryAttribute = linkHandlerFactoryAttribute;
    }
}

