/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.themes;

import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.theme.SessionThemeResolver;
import org.springframework.web.util.WebUtils;

public class JSThemeResolver
extends SessionThemeResolver {
    public static final String THEME_PARAMETER = "theme";
    private ThemeResolver delegate;

    public String resolveThemeName(HttpServletRequest request) {
        String requestTheme = request.getParameter(THEME_PARAMETER);
        if (requestTheme != null && requestTheme.length() > 0) {
            if (!this.isLoginPage(request)) {
                this.setThemeName(request, null, requestTheme);
            }
            return requestTheme;
        }
        String currentTheme = null;
        currentTheme = (String)WebUtils.getSessionAttribute((HttpServletRequest)request, (String)THEME_SESSION_ATTRIBUTE_NAME);
        if (currentTheme != null && currentTheme.length() > 0) {
            return currentTheme;
        }
        if (this.delegate != null) {
            currentTheme = this.delegate.resolveThemeName(request);
        }
        if (currentTheme == null || currentTheme.length() == 0) {
            currentTheme = this.getDefaultThemeName();
        }
        if (!this.isLoginPage(request)) {
            this.setThemeName(request, null, currentTheme);
        }
        return currentTheme;
    }

    protected boolean isLoginPage(HttpServletRequest request) {
        return request.getRequestURI().contains("login.jsp");
    }

    public ThemeResolver getDelegate() {
        return this.delegate;
    }

    public void setDelegate(ThemeResolver delegate) {
        this.delegate = delegate;
    }
}

