/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;
import org.mortbay.io.Portable;

public class ByteArrayBuffer
extends AbstractBuffer {
    private byte[] _bytes;

    public ByteArrayBuffer(byte[] bytes) {
        this(bytes, 0, bytes.length, 2);
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length) {
        this(bytes, index, length, 2);
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length, int access) {
        super(2, false);
        this._bytes = bytes;
        this.setPutIndex(index + length);
        this.setGetIndex(index);
        this._access = access;
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length, int access, boolean isVolatile) {
        super(2, isVolatile);
        this._bytes = bytes;
        this.setPutIndex(index + length);
        this.setGetIndex(index);
        this._access = access;
    }

    public ByteArrayBuffer(int size) {
        this(new byte[size], 0, size, 2);
        this.setPutIndex(0);
    }

    public ByteArrayBuffer(String value) {
        super(2, false);
        this._bytes = Portable.getBytes(value);
        this.setGetIndex(0);
        this.setPutIndex(this._bytes.length);
        this._access = 0;
        this._string = value;
    }

    public byte[] array() {
        return this._bytes;
    }

    public int capacity() {
        return this._bytes.length;
    }

    public byte get() {
        return this._bytes[this._get++];
    }

    public byte peek(int index) {
        return this._bytes[index];
    }

    public int peek(int index, byte[] b, int offset, int length) {
        int l = length;
        if (index + l > this.capacity()) {
            l = this.capacity() - index;
        }
        if (l <= 0) {
            return -1;
        }
        Portable.arraycopy(this._bytes, index, b, offset, l);
        return l;
    }

    public void poke(int index, byte b) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index<0: " + index + "<0");
        }
        if (index > this.capacity()) {
            throw new IllegalArgumentException("index>capacity(): " + index + ">" + this.capacity());
        }
        this._bytes[index] = b;
    }

    public void wrap(byte[] b, int off, int len) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (this.isImmutable()) {
            throw new IllegalStateException("IMMUTABLE");
        }
        this._bytes = b;
        this.clear();
        this.setGetIndex(off);
        this.setPutIndex(off + len);
    }

    public void wrap(byte[] b) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (this.isImmutable()) {
            throw new IllegalStateException("IMMUTABLE");
        }
        this._bytes = b;
        this.setGetIndex(0);
        this.setPutIndex(b.length);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this._bytes, this.getIndex(), this.length());
        this.clear();
    }

    public int readFrom(InputStream in, int max) throws IOException {
        if (max < 0 || max > this.space()) {
            max = this.space();
        }
        int p = this.putIndex();
        int len = 0;
        int total = 0;
        int available = max;
        while (total < max && (len = in.read(this._bytes, p, available)) >= 0) {
            if (len > 0) {
                total += len;
                available -= len;
                this.setPutIndex(p += len);
            }
            if (in.available() > 0) continue;
        }
        if (len < 0 && total == 0) {
            return -1;
        }
        return total;
    }

    public static class CaseInsensitive
    extends ByteArrayBuffer
    implements Buffer.CaseInsensitve {
        public CaseInsensitive(String s) {
            super(s);
        }

        public CaseInsensitive(byte[] b, int o, int l, int rw) {
            super(b, o, l, rw);
        }
    }
}

