/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.OlapConnectionServiceImpl;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Result;
import java.io.InputStream;
import junit.textui.TestRunner;
import mondrian.olap.Axis;
import mondrian.olap.Connection;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OlapConnectionTest
extends BaseJasperServerTest {
    private static final Log log = LogFactory.getLog(OlapConnectionTest.class);
    protected final String foodMartSchema2006URI = "/queries/FoodmartSchema2006.xml";
    protected final String foodMartSchema2006UpperURI = "/queries/FoodmartSchema2006Upper.xml";
    protected final String foodMartJaSchemaURI = "/queries/FoodMart_ja.xml";
    protected final String sugarCRMSchemaURI = "/queries/SugarCRMSchema.xml";
    protected final String sugarCRMSchemaUpperURI = "/queries/SugarcrmSchemaUpper.xml";
    private ExecutionContext executionContext;
    private OlapConnectionServiceImpl olapConnectionServiceTarget;
    public static String SAMPLE_FOODMART_JA_MDX_QUERY = "select {[Measures].[Unit Sales\u65e5\u672c\u8a9e], [Measures].[Store Cost\u65e5\u672c\u8a9e], [Measures].[Store Sales\u65e5\u672c\u8a9e]} on columns, {([Promotion Media\u65e5\u672c\u8a9e].[All Media\u65e5\u672c\u8a9e], [Product\u65e5\u672c\u8a9e].[All Products\u65e5\u672c\u8a9e])} ON rows from [Sales\u65e5\u672c\u8a9e] where ([Time\u65e5\u672c\u8a9e].[2006])";
    public static String SAMPLE_FOODMART_MDX_QUERY = "select {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales]} on columns, {([Promotion Media].[All Media], [Product].[All Products])} ON rows from Sales where ([Time].[2006].[Q4].[12])";
    private String SAMPLE_SUGAR_CRM_MDX_QUERY = "select {[Measures].[Total Sale Amount], [Measures].[Number of Sales], [Measures].[Avg Sale Amount], [Measures].[Avg Time To Close (Days)], [Measures].[Avg Close Probability]} ON COLUMNS,  NON EMPTY {([Account Categorization].[All Accounts], [Close Period].[All Periods])} ON ROWS  from [SalesAnalysis]  where [Sale State].[All Types].[Closed Won]";
    private final boolean DO_PSEUDO_JAPANESE_FOODMART = false;
    private static final String FOODMART_REPORT_JRXML = "/reports/jasper/MondrianFoodMartSalesReport2006.jrxml";

    public OlapConnectionTest() {
        this.setAutowireMode(1);
    }

    public OlapConnectionTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    public static void main(String[] args) {
        TestRunner.run(OlapConnectionTest.class);
    }

    protected void onSetUp() throws Exception {
        this.executionContext = new ExecutionContextImpl();
        this.basicAuthSetup();
    }

    protected void onTearDown() {
        Resource savedResource = this.getRepositoryService().getResource(this.executionContext, "/analysis/views/Test_Sugar_View");
        if (savedResource != null) {
            this.getRepositoryService().deleteResource(this.executionContext, savedResource.getURI());
        }
        if ((savedResource = this.getRepositoryService().getResource(this.executionContext, "/analysis/connections/SugarCRMTest")) != null) {
            this.getRepositoryService().deleteResource(this.executionContext, savedResource.getURI());
        }
    }

    protected void createFoodmartSchemaResource() {
        this.createOrUpdateSchemaResource("/analysis/schemas", "FoodmartSchema", "FoodmartSchema", "Foodmart Analysis Schema", "/queries/FoodmartSchema2006.xml");
    }

    protected void createFoodmartSchemaUpperResource() {
        this.createOrUpdateSchemaResource("/analysis/schemas", "FoodmartSchemaUpper", "Foodmart Schema Uppercase", "Foodmart Analysis Schema Uppercase", "/queries/FoodmartSchema2006Upper.xml");
    }

    protected void createFoodmartJaSchemaResource() {
        this.createOrUpdateSchemaResource("/analysis/schemas", "FoodmartJaSchema", "Foodmart Schema Pseudo Japanese", "Foodmart Analysis Pseudo Japanese Schema", "/queries/FoodMart_ja.xml");
    }

    protected void createSugarCRMSchemaResource() {
        this.createOrUpdateSchemaResource("/analysis/schemas", "SugarCRMSchema", "SugarCRM Schema", "SugarCRM Analysis Schema", "/queries/SugarCRMSchema.xml");
    }

    protected void createSugarCRMSchemaUpperResource() {
        this.createOrUpdateSchemaResource("/analysis/schemas", "SugarCRMSchemaUpper", "SugarCRM Schema Uppercase", "SugarCRM Analysis Schema Upper Case", "/queries/SugarcrmSchemaUpper.xml");
    }

    protected void createFoodmartJDBCDataSourceResource() throws Exception {
        this.createJDBCDataSourceResource("/analysis/datasources", "FoodmartDataSource", "Foodmart Data Source", "Foodmart Data Source", this.getJdbcProps().getProperty("foodmart.jdbc.driverClassName"), this.getJdbcProps().getProperty("foodmart.jdbc.url"), this.getJdbcProps().getProperty("foodmart.jdbc.username"), this.getJdbcProps().getProperty("foodmart.jdbc.password"));
    }

    protected void createFoodmartJNDIDataSourceResource() {
        this.createJNDIDataSourceResource("/analysis/datasources", "FoodmartDataSourceJNDI", "Foodmart Data Source JNDI", "Foodmart Data Source JNDI", "jdbc/foodmart");
    }

    protected void createFoodmartJaDataSourceResource() throws Exception {
        this.createJDBCDataSourceResource("/analysis/datasources", "FoodmartJaDataSource", "Foodmart Japanese Data Source", "Foodmart Japanese Data Source", this.getJdbcProps().getProperty("foodmart_ja.jdbc.driverClassName"), this.getJdbcProps().getProperty("foodmart_ja.jdbc.url"), this.getJdbcProps().getProperty("foodmart_ja.jdbc.username"), this.getJdbcProps().getProperty("foodmart_ja.jdbc.password"));
    }

    protected void createSugarCRMDataSourceResource() throws Exception {
        this.createJDBCDataSourceResource("/analysis/datasources", "SugarCRMDataSource", "SugarCRM Data Source", "SugarCRM Data Source", this.getJdbcProps().getProperty("test.jdbc.driverClassName"), this.getJdbcProps().getProperty("test.jdbc.url"), this.getJdbcProps().getProperty("test.jdbc.username"), this.getJdbcProps().getProperty("test.jdbc.password"));
    }

    protected void createSugarCRMDataSourceResourceJNDI() {
        this.createJNDIDataSourceResource("/analysis/datasources", "SugarCRMDataSourceJNDI", "SugarCRM Data Source JNDI", "SugarCRM Data Source JNDI", "jdbc/sugarcrm");
    }

    protected void createFoodmartMondrianConnectionResource() throws Exception {
        String schemaResourceReference = "/analysis/schemas/FoodmartSchema";
        if (this.getJdbcProps().getProperty("foodmart.upperCaseNames") != null && this.getJdbcProps().getProperty("foodmart.upperCaseNames").equalsIgnoreCase("true")) {
            schemaResourceReference = "/analysis/schemas/FoodmartSchemaUpper";
        }
        this.createMondrianConnectionResource("/analysis/connections", "Foodmart", "Foodmart Mondrian Connection", "Foodmart Mondrian Analysis Connection", schemaResourceReference, "/analysis/datasources/FoodmartDataSourceJNDI");
    }

    protected void createFoodmartJaMondrianConnectionResource() {
        this.createMondrianConnectionResource("/analysis/connections", "FoodmartJa", "FoodmartJa Mondrian Connection", "FoodmartJa Mondrian Analysis Connection", "/analysis/schemas/FoodmartJaSchema", "/analysis/datasources/FoodmartJaDataSource");
    }

    protected void createSugarCRMMondrianConnectionResource() throws Exception {
        String schemaResourceReference = "/analysis/schemas/SugarCRMSchema";
        if (this.getJdbcProps().getProperty("sugarcrm.upperCaseNames") != null && this.getJdbcProps().getProperty("sugarcrm.upperCaseNames").equalsIgnoreCase("true")) {
            schemaResourceReference = "/analysis/schemas/SugarCRMSchemaUpper";
        }
        this.createMondrianConnectionResource("/analysis/connections", "SugarCRM", "SugarCRM Mondrian Connection", "SugarCRM Mondrian Analysis Connection: only opportunities", schemaResourceReference, "/analysis/datasources/SugarCRMDataSourceJNDI");
    }

    protected void createSugarCRMTestMondrianConnectionResource() throws Exception {
        String schemaResourceReference = "/analysis/schemas/SugarCRMSchema";
        if (this.getJdbcProps().getProperty("sugarcrm.upperCaseNames") != null && this.getJdbcProps().getProperty("sugarcrm.upperCaseNames").equalsIgnoreCase("true")) {
            schemaResourceReference = "/analysis/schemas/SugarCRMSchemaUpper";
        }
        this.createMondrianConnectionResource("/analysis/connections", "SugarCRMTest", "SugarCRM Mondrian Connection - Test Only", "SugarCRM Mondrian Analysis Connection: test only", schemaResourceReference, "/analysis/datasources/SugarCRMDataSource");
    }

    protected void createFoodmartXMLAConnectionResource() {
        this.createXMLAConnectionResource("/analysis/connections", "SugarCRMXmlaConnection", "SugarCRM XML/A Connection", "SugarCRM XML/A Connection", "SugarCRM", "Provider=Mondrian;DataSource=SugarCRM;", "http://localhost:8080/jasperserver/xmla", "jasperadmin", "jasperadmin");
    }

    protected void createSugarCRMXMLAConnectionResource() {
        this.createXMLAConnectionResource("/analysis/connections", "FoodmartXmlaConnection", "Foodmart XML/A Connection", "Foodmart XML/A Connection", "Foodmart", "Provider=Mondrian;DataSource=Foodmart;", "http://localhost:8080/jasperserver/xmla", "jasperadmin", "jasperadmin");
    }

    protected void createFoodmartMondrianXMLADefinitionResource() {
        this.creatMondrianXMLADefinitionResource("/analysis/xmla/definitions", "FoodmartXmlaDefinition", "Foodmart Mondrian XMLA definition", "Foodmart Mondrian XMLA definition", "Foodmart", "/analysis/connections/Foodmart");
    }

    protected void createSugarCRMMondrianXMLADefinitionResource() {
        this.creatMondrianXMLADefinitionResource("/analysis/xmla/definitions", "SugarCRMXmlaDefinition", "SugarCRM Mondrian XMLA definition", "SugarCRM Mondrian XMLA definition", "SugarCRM", "/analysis/connections/SugarCRM");
    }

    protected void createFoodmartJaOlapUnit() {
        this.creatOlapUnitResource("/analysis/views", "FoodmartJa_sample_unit_1", "FoodmartJa Sample Analysis View", "Sample Analysis View: 2006 Q1 FoodmartJa Unit Sales", "/analysis/connections/FoodmartJa", SAMPLE_FOODMART_JA_MDX_QUERY, true);
    }

    protected void createFoodmartOlapUnit() {
        this.creatOlapUnitResource("/analysis/views", "Foodmart_sample", "Foodmart Sample Analysis View", "Sample Analysis View: 2006 Q1 Foodmart Unit Sales", "/analysis/connections/Foodmart", SAMPLE_FOODMART_MDX_QUERY, true);
    }

    protected void createSugarCRMXmlaOlapUnit() {
        this.creatOlapUnitResource("/analysis/views", "SugarCRM_xmla_sample", "SugarCRM Sample XMLA Analysis View", "Sample SugarCRM Analysis View (XMLA): Sales Performance by Industry/Account", "/analysis/connections/SugarCRMXmlaConnection", this.SAMPLE_SUGAR_CRM_MDX_QUERY, true);
    }

    protected void createFoodmartXmlaOlapUnit() {
        this.creatOlapUnitResource("/analysis/views", "Foodmart_xmla_sample", "Foodmart Sample XMLA Analysis View", "Sample XMLA Analysis View: 2006 Q1 Foodmart Unit Sales", "/analysis/connections/FoodmartXmlaConnection", SAMPLE_FOODMART_MDX_QUERY, true);
    }

    protected void createSugarCRMOlapUnit() {
        this.creatOlapUnitResource("/analysis/views", "SugarCRM_sample", "SugarCRM Sample Analysis View", "Sample SugarCRM Analysis View: Sales Performance by Industry/Account", "/analysis/connections/SugarCRM", this.SAMPLE_SUGAR_CRM_MDX_QUERY, true);
    }

    protected void executeSampleFoodmartQuery() {
        this.assertQueryShape("/analysis/connections/Foodmart", SAMPLE_FOODMART_MDX_QUERY, "", new int[]{0, 0});
    }

    protected void executeSampleSugarQuery() {
        this.assertQueryShape("/analysis/connections/SugarCRM", this.SAMPLE_SUGAR_CRM_MDX_QUERY, "Total Sale Amount", new int[]{5, 1});
    }

    protected void executeSampleSugarTestQuery() {
        this.assertQueryShape("/analysis/connections/SugarCRMTest", this.SAMPLE_SUGAR_CRM_MDX_QUERY, "Total Sale Amount", new int[]{5, 1});
    }

    public void assertQueryShape(String connResourceName, String mdxQuery, String expectedCaption, int[] expectedAxesLengths) {
        Connection monConnection = this.getOlapConnectionServiceTarget().getMondrianConnection(null, connResourceName);
        Query monQuery = monConnection.parseQuery(mdxQuery);
        mondrian.olap.Result monResult = monConnection.execute(monQuery);
        Axis[] axes = monResult.getAxes();
        Position pos = (Position)axes[0].getPositions().get(0);
        Member m0 = (Member)pos.get(0);
        String caption = m0.getCaption();
        OlapConnectionTest.assertEquals((String)("Number of axes - expected: " + expectedAxesLengths.length + ",  got: " + axes.length), (int)axes.length, (int)expectedAxesLengths.length);
        String axesDetail = "";
        for (int i = 0; i < axes.length; ++i) {
            OlapConnectionTest.assertEquals((String)("Axis " + i + " length error: expected " + expectedAxesLengths[i] + ", got " + axes[i].getPositions().size()), (int)expectedAxesLengths[i], (int)axes[i].getPositions().size());
            axesDetail = axesDetail + " " + axes[i].getPositions().size();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("caption = " + caption + ", " + "axes.length=" + axes.length + ", " + "axes.lengths=" + axesDetail));
        }
        OlapConnectionTest.assertEquals((String)caption, (String)expectedCaption);
    }

    public void olapUnitTest() {
        OlapUnit view = this.creatOlapUnitResource("/analysis/views", "Test_Sugar_View", "Test SugarCRM View with JDBC", "Test SugarCRM View with JDBC", "/analysis/connections/SugarCRMTest", this.SAMPLE_SUGAR_CRM_MDX_QUERY, false);
        OlapConnectionTest.assertTrue((String)"validation of SugarCRM test view _not_ in DB failed", (boolean)this.getOlapConnectionService().validate(null, view).getValidationState().equals("VALID"));
        this.getOlapConnectionService().saveResource(null, "/analysis/views", (Resource)view);
        view = (OlapUnit)this.getRepositoryService().getResource(null, "/analysis/views/Test_Sugar_View");
        OlapConnectionTest.assertTrue((String)"validation of SugarCRM test view in DB failed", (boolean)this.getOlapConnectionService().validate(null, view).getValidationState().equals("VALID"));
        this.executeSampleSugarTestQuery();
        OlapModel sampleSugarModel = this.getModel("Test_Sugar_View");
    }

    public void testOlapConnection() throws Exception {
        this.createFoodmartSchemaResource();
        this.createFoodmartSchemaUpperResource();
        this.createSugarCRMSchemaResource();
        this.createSugarCRMSchemaUpperResource();
        this.createFoodmartJDBCDataSourceResource();
        this.createFoodmartJNDIDataSourceResource();
        this.createSugarCRMDataSourceResource();
        this.createSugarCRMDataSourceResourceJNDI();
        this.createFoodmartMondrianConnectionResource();
        this.createFoodmartXMLAConnectionResource();
        this.createSugarCRMMondrianConnectionResource();
        this.createSugarCRMTestMondrianConnectionResource();
        this.createSugarCRMXMLAConnectionResource();
        this.createFoodmartOlapUnit();
        this.createSugarCRMOlapUnit();
        this.createSugarCRMXmlaOlapUnit();
        this.createFoodmartXmlaOlapUnit();
        this.createFoodmartMondrianXMLADefinitionResource();
        this.createSugarCRMMondrianXMLADefinitionResource();
        Folder analysisReports = this.createAnalysisReportsFolder();
        this.createMondrianFoodmartReport(analysisReports);
        this.createXmlaFoodmartReport(analysisReports);
        this.olapUnitTest();
        this.getModel("SugarCRM_xmla_sample");
    }

    private void assertOlapModelResult(OlapModel m, int expectedNumCells) {
        try {
            m.initialize();
            Result r = m.getResult();
            log.info((Object)("cell count = " + r.getCells().size()));
            OlapConnectionTest.assertNotNull((Object)r);
            OlapConnectionTest.assertTrue((String)("sample query returned " + r.getCells().size() + " cells, when expecting " + expectedNumCells), (r.getCells().size() == expectedNumCells ? 1 : 0) != 0);
        }
        catch (OlapException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private OlapModel getModel(String viewName) {
        OlapUnit unit = (OlapUnit)this.getRepositoryService().getResource(null, "/analysis/views/" + viewName);
        return this.getOlapConnectionService().createOlapModel(null, unit);
    }

    protected void createXmlaFoodmartReport(Folder parent) {
        this.createOlapFoodmartReport(parent, "/analysis/reports/", "FoodmartSalesXmlaReport", "Foodmart XML/A Sales Report", "Report with XML/A Datasource", "/analysis/connections/FoodmartXmlaConnection");
    }

    protected void createMondrianFoodmartReport(Folder parent) {
        this.createOlapFoodmartReport(parent, "/analysis/reports/", "FoodmartSalesMondrianReport", "Foodmart Mondrian Sales Report", "Report with Mondrian Datasource", "/analysis/connections/Foodmart");
    }

    protected Folder createAnalysisReportsFolder() {
        return this.createOrUpdateFolder("/analysis", "reports", "Analysis Reports");
    }

    public void createOlapFoodmartReport(Folder parent, String path, String name, String label, String desc, String connectionUri) {
        boolean newRU = false;
        ReportUnit ru = (ReportUnit)this.getRepositoryService().getResource(null, path + name, ReportUnit.class);
        if (ru == null) {
            ru = (ReportUnit)this.getRepositoryService().newResource(this.executionContext, ReportUnit.class);
            ru.setParentFolder(parent);
            ru.setName(name);
            newRU = true;
        }
        ru.setLabel(label);
        ru.setDescription(desc);
        FileResource report = null;
        if (!newRU) {
            report = (FileResource)ru.getMainReport().getLocalResource();
            assert (report != null);
        } else {
            report = (FileResource)this.getRepositoryService().newResource(this.executionContext, FileResource.class);
            report.setFileType("jrxml");
            report.setName("FoodmartSalesReportJRXML");
            report.setLabel("FoodmartSalesReportJRXML");
        }
        report.readData(((Object)((Object)this)).getClass().getResourceAsStream(FOODMART_REPORT_JRXML));
        ru.setMainReport(report);
        ru.setDataSourceReference(connectionUri);
        this.getRepositoryService().saveResource(this.executionContext, (Resource)ru);
        Resource savedResource = this.getRepositoryService().getResource(this.executionContext, path + name);
        OlapConnectionTest.assertNotNull((Object)savedResource);
        OlapConnectionTest.assertTrue((boolean)(savedResource instanceof ReportUnit));
        ReportUnit savedRU = (ReportUnit)savedResource;
        ResourceReference savedDSRef = savedRU.getDataSource();
        OlapConnectionTest.assertNotNull((Object)savedDSRef);
        OlapConnectionTest.assertFalse((boolean)savedDSRef.isLocal());
        OlapConnectionTest.assertEquals((String)connectionUri, (String)savedDSRef.getReferenceURI());
    }

    public Folder createOrUpdateFolder(String folderParentURI, String folderName, String folderLabel) {
        Folder aFolder = null;
        aFolder = this.getRepositoryService().getFolder(null, folderParentURI + "/" + folderName);
        if (aFolder == null) {
            aFolder = new FolderImpl();
            aFolder.setParentFolder(folderParentURI);
            aFolder.setName(folderName);
        }
        aFolder.setLabel(folderLabel);
        this.getRepositoryService().saveFolder(this.executionContext, aFolder);
        return aFolder;
    }

    public void createOrUpdateSchemaResource(String schemaFolderParentURI, String schemaName, String schemaLabel, String schemaDescription, String resourcePath) {
        FileResource schemaResource = (FileResource)this.getRepositoryService().getResource(null, schemaFolderParentURI + "/" + schemaName, FileResource.class);
        if (schemaResource == null) {
            schemaResource = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
            schemaResource.setParentFolder(schemaFolderParentURI);
            schemaResource.setName(schemaName);
        }
        schemaResource.setLabel(schemaLabel);
        schemaResource.setDescription(schemaDescription);
        schemaResource.setFileType("olapMondrianSchema");
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(resourcePath);
        schemaResource.readData(in);
        this.getOlapConnectionService().saveResource(null, schemaFolderParentURI, (Resource)schemaResource);
    }

    public void createJDBCDataSourceResource(String dataSourceFolderParentURI, String dataSourceName, String dataSourceLabel, String dataSourceDescription, String driverClassName, String connectionURL, String username, String password) {
        JdbcReportDataSource dataSourceResource = (JdbcReportDataSource)this.getRepositoryService().getResource(null, dataSourceFolderParentURI + "/" + dataSourceName, JdbcReportDataSource.class);
        if (dataSourceResource == null) {
            dataSourceResource = (JdbcReportDataSource)this.getRepositoryService().newResource(null, JdbcReportDataSource.class);
            dataSourceResource.setParentFolder(dataSourceFolderParentURI);
            dataSourceResource.setName(dataSourceName);
        }
        dataSourceResource.setLabel(dataSourceLabel);
        dataSourceResource.setDescription(dataSourceDescription);
        dataSourceResource.setDriverClass(driverClassName);
        dataSourceResource.setConnectionUrl(connectionURL);
        dataSourceResource.setUsername(username);
        dataSourceResource.setPassword(password);
        this.getOlapConnectionService().saveResource(null, dataSourceFolderParentURI, (Resource)dataSourceResource);
    }

    public void createJNDIDataSourceResource(String dataSourceFolderParentURI, String dataSourceName, String dataSourceLabel, String dataSourceDescription, String jndiURI) {
        JndiJdbcReportDataSource dataSourceResource = (JndiJdbcReportDataSource)this.getRepositoryService().getResource(null, dataSourceFolderParentURI + "/" + dataSourceName, JndiJdbcReportDataSource.class);
        if (dataSourceResource == null) {
            dataSourceResource = (JndiJdbcReportDataSource)this.getRepositoryService().newResource(null, JndiJdbcReportDataSource.class);
            dataSourceResource.setParentFolder(dataSourceFolderParentURI);
            dataSourceResource.setName(dataSourceName);
        }
        dataSourceResource.setLabel(dataSourceLabel);
        dataSourceResource.setDescription(dataSourceDescription);
        dataSourceResource.setJndiName(jndiURI);
        this.getOlapConnectionService().saveResource(null, dataSourceFolderParentURI, (Resource)dataSourceResource);
    }

    public void createMondrianConnectionResource(String mondrianConnectionFolderParentURI, String mondrianConnectionName, String mondrianConnectionLabel, String mondrianConnectionDescription, String schemaURI, String dataSourceURI) {
        MondrianConnection mondrianConnectionResource = (MondrianConnection)this.getRepositoryService().getResource(null, mondrianConnectionFolderParentURI + "/" + mondrianConnectionName, MondrianConnection.class);
        if (mondrianConnectionResource == null) {
            mondrianConnectionResource = (MondrianConnection)this.getRepositoryService().newResource(null, MondrianConnection.class);
            mondrianConnectionResource.setParentFolder(mondrianConnectionFolderParentURI);
            mondrianConnectionResource.setName(mondrianConnectionName);
        }
        mondrianConnectionResource.setLabel(mondrianConnectionName);
        mondrianConnectionResource.setDescription(mondrianConnectionDescription);
        mondrianConnectionResource.setSchemaReference(schemaURI);
        mondrianConnectionResource.setDataSourceReference(dataSourceURI);
        this.getOlapConnectionService().saveResource(null, mondrianConnectionFolderParentURI, (Resource)mondrianConnectionResource);
    }

    public void createXMLAConnectionResource(String xmlaConnectionFolderParentURI, String xmlaConnectionName, String xmlaConnectionLabel, String xmlaConnectionDescription, String catalog, String xmlaDataSource, String URI, String username, String password) {
        XMLAConnection xmlaConnection = (XMLAConnection)this.getRepositoryService().getResource(null, xmlaConnectionFolderParentURI + "/" + xmlaConnectionName, XMLAConnection.class);
        if (xmlaConnection == null) {
            xmlaConnection = (XMLAConnection)this.getRepositoryService().newResource(null, XMLAConnection.class);
            xmlaConnection.setParentFolder(xmlaConnectionFolderParentURI);
            xmlaConnection.setName(xmlaConnectionName);
        }
        xmlaConnection.setLabel(xmlaConnectionLabel);
        xmlaConnection.setDescription(xmlaConnectionDescription);
        xmlaConnection.setCatalog(catalog);
        xmlaConnection.setDataSource(xmlaDataSource);
        xmlaConnection.setURI(URI);
        xmlaConnection.setUsername(username);
        xmlaConnection.setPassword(password);
        this.getOlapConnectionService().saveResource(null, xmlaConnectionFolderParentURI, (Resource)xmlaConnection);
    }

    public void creatMondrianXMLADefinitionResource(String xmlaDefinitionFolderParentURI, String xmlaDefinitionName, String xmlaDefinitionLabel, String xmlaDefinitionDescription, String catalog, String mondrianConnectionURI) {
        MondrianXMLADefinition mondrianXmlaConnection = (MondrianXMLADefinition)this.getRepositoryService().getResource(null, xmlaDefinitionFolderParentURI + "/" + xmlaDefinitionName, MondrianXMLADefinition.class);
        if (mondrianXmlaConnection == null) {
            mondrianXmlaConnection = (MondrianXMLADefinition)this.getRepositoryService().newResource(null, MondrianXMLADefinition.class);
            mondrianXmlaConnection.setParentFolder(xmlaDefinitionFolderParentURI);
            mondrianXmlaConnection.setName(xmlaDefinitionName);
        }
        mondrianXmlaConnection.setLabel(xmlaDefinitionLabel);
        mondrianXmlaConnection.setDescription(xmlaDefinitionDescription);
        mondrianXmlaConnection.setCatalog(catalog);
        mondrianXmlaConnection.setMondrianConnectionReference(mondrianConnectionURI);
        this.getOlapConnectionService().saveResource(null, xmlaDefinitionFolderParentURI, (Resource)mondrianXmlaConnection);
    }

    public OlapUnit creatOlapUnitResource(String olapUnitFolderParentURI, String olapUnitName, String olapUnitLabel, String olapUnitDescription, String connectionReference, String mdxQuery, boolean saveUnit) {
        OlapUnit olapUnit = (OlapUnit)this.getRepositoryService().getResource(null, olapUnitFolderParentURI + "/" + olapUnitName, OlapUnit.class);
        if (olapUnit == null) {
            olapUnit = (OlapUnit)this.getRepositoryService().newResource(null, OlapUnit.class);
            olapUnit.setParentFolder(olapUnitFolderParentURI);
            olapUnit.setName(olapUnitName);
        }
        olapUnit.setLabel(olapUnitLabel);
        olapUnit.setDescription(olapUnitDescription);
        olapUnit.setOlapClientConnectionReference(connectionReference);
        olapUnit.setMdxQuery(mdxQuery);
        if (saveUnit) {
            this.getOlapConnectionService().saveResource(null, olapUnitFolderParentURI, (Resource)olapUnit);
        }
        return olapUnit;
    }

    public void setOlapConnectionServiceTarget(OlapConnectionServiceImpl olapConnectionServiceTarget) {
        this.olapConnectionServiceTarget = olapConnectionServiceTarget;
    }

    public OlapConnectionServiceImpl getOlapConnectionServiceTarget() {
        return this.olapConnectionServiceTarget;
    }
}

