/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.TenantImpl;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import junit.textui.TestRunner;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

public class TenantServiceTest
extends AbstractDependencyInjectionSpringContextTests {
    static final int ORG_COUNT = 5;
    static final String ID_PREFIX = "test_org_";
    static final String ALIAS_PREFIX = "TO ";
    static final String NAME_PREFIX = "Test Organization ";
    static final String URI_PREFIX = "/";
    static final String FOLDER_UIR_PREFIX = "/organizations";
    List<String> deleteList;
    Properties jdbcProps;
    UserAuthorityService userAuthorityService;
    TenantService tenantService;

    public TenantServiceTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    public static void main(String[] args) {
        TestRunner.run(TenantServiceTest.class);
    }

    protected String[] getConfigLocations() {
        try {
            this.loadJdbcProps();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.jdbcProps.getProperty("metadata.additionalSettings") == null) {
            return new String[]{"hibernateConfig.xml", "userAuthorityService.xml", "viewService.xml", "methodAndObjectSecurity.xml"};
        }
        return new String[]{"hibernateConfig.xml", this.jdbcProps.getProperty("metadata.additionalSettings"), "userAuthorityService.xml", "viewService.xml", "methodAndObjectSecurity.xml"};
    }

    protected Properties loadJdbcProps() throws IOException, FileNotFoundException, NamingException {
        this.jdbcProps = new Properties();
        String jdbcPropFile = System.getProperty("test.hibernate.jdbc.properties");
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(jdbcPropFile));
        this.jdbcProps.load(is);
        is.close();
        return this.jdbcProps;
    }

    protected void onSetUp() throws Exception {
        super.onSetUp();
        this.tenantService = (TenantService)this.getApplicationContext().getBean("tenantService");
        Tenant root = this.tenantService.getTenant((ExecutionContext)new ExecutionContextImpl(), "organizations");
        this.deleteList = new ArrayList<String>();
        for (int i = 1; i <= 5; ++i) {
            Tenant t = this.createTenant(Integer.toString(i), root);
            this.tenantService.putTenant(null, t);
            this.deleteList.add(t.getId());
            for (int j = 1; j <= 5; ++j) {
                Tenant tt = this.createTenant(Integer.toString(i) + Integer.toString(j), t);
                this.tenantService.putTenant(null, tt);
                this.deleteList.add(tt.getId());
            }
        }
    }

    public void onTearDown() {
        Collections.reverse(this.deleteList);
        for (String id : this.deleteList) {
            this.tenantService.deleteTenant(null, id);
        }
    }

    private Tenant createTenant(String number, Tenant parent) {
        TenantImpl t = new TenantImpl();
        t.setId(ID_PREFIX + number);
        t.setAlias(ALIAS_PREFIX + number);
        t.setTenantName(NAME_PREFIX + number);
        StringBuilder uri = new StringBuilder();
        StringBuilder fUri = new StringBuilder();
        if (parent != null) {
            t.setParentId(parent.getId());
            uri.append(parent.getTenantUri());
            fUri.append(parent.getTenantFolderUri());
        }
        if (uri.lastIndexOf(URI_PREFIX) != uri.length() - 1) {
            uri.append(URI_PREFIX);
        }
        if (fUri.lastIndexOf(URI_PREFIX) != fUri.length() - 1) {
            fUri.append(URI_PREFIX);
        }
        uri.append(t.getId());
        fUri.append("organizations").append(URI_PREFIX).append(t.getId());
        t.setTenantUri(uri.toString());
        t.setTenantFolderUri(fUri.toString());
        return t;
    }

    public void testGetTenant() {
        Tenant t = this.tenantService.getTenant((ExecutionContext)new ExecutionContextImpl(), "organizations");
        TenantServiceTest.assertNotNull((Object)t);
        TenantServiceTest.assertEquals((String)"organizations", (String)t.getId());
    }

    public void testPutTenant() {
        Tenant genTenant = this.createTenant(Integer.toString(0), null);
        this.tenantService.putTenant((ExecutionContext)new ExecutionContextImpl(), genTenant);
        Tenant tenant = this.tenantService.getTenant((ExecutionContext)new ExecutionContextImpl(), genTenant.getId());
        TenantServiceTest.assertNotNull((Object)tenant);
        this.tenantService.deleteTenant(null, tenant.getId());
        TenantServiceTest.assertEquals((String)genTenant.getId(), (String)tenant.getId());
        TenantServiceTest.assertEquals((String)genTenant.getTenantName(), (String)tenant.getTenantName());
    }

    public void testDeleteTenant() {
        String id = Integer.toString(1) + Integer.toString(1);
        Tenant genTenant = this.createTenant(id, null);
        this.tenantService.deleteTenant((ExecutionContext)new ExecutionContextImpl(), genTenant.getId());
        Tenant tenant = this.tenantService.getTenant((ExecutionContext)new ExecutionContextImpl(), genTenant.getId());
        TenantServiceTest.assertNull((Object)tenant);
        this.deleteList.remove(genTenant.getId());
    }

    public void testGetAllSubTenantList() {
        TenantServiceTest.assertNotNull((Object)this.tenantService);
        List tenants = this.tenantService.getAllSubTenantList((ExecutionContext)new ExecutionContextImpl(), "organizations");
        TenantServiceTest.assertNotNull((Object)tenants);
        TenantServiceTest.assertEquals((int)31, (int)tenants.size());
        Tenant genTenant = this.createTenant(Integer.toString(1), null);
        tenants = this.tenantService.getAllSubTenantList((ExecutionContext)new ExecutionContextImpl(), genTenant.getId());
        TenantServiceTest.assertNotNull((Object)tenants);
        TenantServiceTest.assertEquals((int)5, (int)tenants.size());
    }
}

