/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.util.test;

import com.jaspersoft.jasperserver.export.CommandBean;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.ParametersImpl;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class BaseExportTestCase
extends BaseJasperServerTest {
    protected static final String TEST_BASE_DIR = "target";
    protected static final String EXPORT_COMMAND_BEAN_NAME = "exportCommandBean";
    protected static final String IMPORT_COMMAND_BEAN_NAME = "importCommandBean";
    protected static final String PARAM_EXPORT_DIR = "output-dir";
    protected static final String PARAM_EXPORT_URIS = "uris";
    protected static final String PARAM_EXPORT_REPORT_JOB_URIS = "report-jobs";
    protected static final String PARAM_EXPORT_USERS = "users";
    protected static final String PARAM_EXPORT_ROLES = "roles";
    protected static final String PARAM_IMPORT_DIR = "input-dir";
    protected static final String PARAM_IMPORT_ZIP = "input-zip";
    protected static final String PARAM_IMPORT_PREPEND_PATH = "prepend-path";
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static final Random random = new Random(System.currentTimeMillis());
    private List exportFolders = new ArrayList();

    public BaseExportTestCase() {
        this.setAutowireMode(1);
    }

    public BaseExportTestCase(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    protected Object getBean(String beanName) {
        return this.applicationContext.getBean(beanName);
    }

    public void onSetUp() throws Exception {
        this.exportFolders.clear();
        this.basicAuthSetup();
    }

    public void onTearDown() throws Exception {
        this.deleteExportFolders();
    }

    protected void deleteExportFolders() {
        for (String folder : this.exportFolders) {
            this.deleteFolder(new File(folder));
        }
    }

    protected void deleteFolder(File folder) {
        if (folder.exists() && folder.isDirectory()) {
            File[] subFiles = folder.listFiles();
            if (subFiles != null) {
                for (int i = 0; i < subFiles.length; ++i) {
                    File subFile = subFiles[i];
                    if (subFile.isFile()) {
                        subFile.delete();
                        continue;
                    }
                    if (!subFile.isDirectory()) continue;
                    this.deleteFolder(subFile);
                }
            }
            folder.delete();
        }
    }

    protected String createExportDir() {
        String dir = TEST_BASE_DIR + FILE_SEPARATOR + "export_" + random.nextInt();
        this.exportFolders.add(dir);
        return dir;
    }

    protected void performExport(Parameters params) {
        CommandBean exporter = (CommandBean)this.getBean(EXPORT_COMMAND_BEAN_NAME);
        exporter.process(params);
    }

    protected void performImport(Parameters params) {
        CommandBean importer = (CommandBean)this.getBean(IMPORT_COMMAND_BEAN_NAME);
        importer.process(params);
    }

    protected Parameters createParameters() {
        return new ParametersImpl();
    }
}

