/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.quartz.Calendar;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.calendar.CalendarComparator;

public class AnnualCalendar
extends BaseCalendar
implements Calendar,
Serializable {
    private ArrayList excludeDays = new ArrayList();
    private boolean dataSorted = false;

    public AnnualCalendar() {
    }

    public AnnualCalendar(Calendar baseCalendar) {
        super(baseCalendar);
    }

    public ArrayList getDaysExcluded() {
        return this.excludeDays;
    }

    public boolean isDayExcluded(java.util.Calendar day) {
        if (day == null) {
            throw new IllegalArgumentException("Parameter day must not be null");
        }
        int dmonth = day.get(2);
        int dday = day.get(5);
        if (!this.dataSorted) {
            Collections.sort(this.excludeDays, new CalendarComparator());
            this.dataSorted = true;
        }
        Iterator iter = this.excludeDays.iterator();
        while (iter.hasNext()) {
            java.util.Calendar cl = (java.util.Calendar)iter.next();
            if (dmonth < cl.get(2)) {
                return false;
            }
            if (dday != cl.get(5) || dmonth != cl.get(2)) continue;
            return true;
        }
        return false;
    }

    public void setDaysExcluded(ArrayList days) {
        if (days == null) {
            this.excludeDays = new ArrayList();
        }
        this.excludeDays = days;
        this.dataSorted = false;
    }

    public void setDayExcluded(java.util.Calendar day, boolean exclude) {
        if (this.isDayExcluded(day)) {
            return;
        }
        this.excludeDays.add(day);
        this.dataSorted = false;
    }

    public boolean isTimeIncluded(long timeStamp) {
        if (!super.isTimeIncluded(timeStamp)) {
            return false;
        }
        java.util.Calendar day = AnnualCalendar.getJavaCalendar(timeStamp);
        return !this.isDayExcluded(day);
    }

    public long getNextIncludedTime(long timeStamp) {
        long newTimeStamp;
        java.util.Calendar day;
        long baseTime = super.getNextIncludedTime(timeStamp);
        if (baseTime > 0L && baseTime > timeStamp) {
            timeStamp = baseTime;
        }
        if (!this.isDayExcluded(day = AnnualCalendar.getJavaCalendar(newTimeStamp = AnnualCalendar.buildHoliday(timeStamp)))) {
            return timeStamp;
        }
        while (this.isDayExcluded(day)) {
            day.add(5, 1);
        }
        return day.getTime().getTime();
    }
}

