/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.decoration.inheritance;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.maven.doxia.site.decoration.inheritance.PathDescriptor;

public abstract class PathUtils {
    private PathUtils() {
    }

    public static final PathDescriptor convertPath(PathDescriptor oldPath, PathDescriptor newPath) throws MalformedURLException {
        String relative = PathUtils.getRelativePath(oldPath, newPath);
        if (relative == null) {
            return oldPath;
        }
        return new PathDescriptor(relative);
    }

    public static final String getRelativePath(PathDescriptor oldPathDescriptor, PathDescriptor newPathDescriptor) throws MalformedURLException {
        if (oldPathDescriptor.isFile() && !newPathDescriptor.isFile()) {
            if (oldPathDescriptor.isRelative()) {
                return oldPathDescriptor.getPath();
            }
            return null;
        }
        if (!oldPathDescriptor.isFile()) {
            URL oldUrl = oldPathDescriptor.getPathUrl();
            URL newUrl = newPathDescriptor.getPathUrl();
            if (newUrl.getProtocol().equalsIgnoreCase(oldUrl.getProtocol()) && newUrl.getHost().equalsIgnoreCase(oldUrl.getHost()) && newUrl.getPort() == oldUrl.getPort()) {
                String oldPath = oldPathDescriptor.getPath();
                String newPath = newPathDescriptor.getPath();
                return PathUtils.getRelativeWebPath(newPath, oldPath);
            }
            return null;
        }
        String oldPath = oldPathDescriptor.getPath();
        String newPath = newPathDescriptor.getPath();
        if (oldPath == null || newPath == null) {
            return null;
        }
        return PathUtils.getRelativeFilePath(oldPath, newPath);
    }

    public static final String getRelativeWebPath(String oldPath, String newPath) {
        String resultPath = PathUtils.buildRelativePath(newPath, oldPath, '/');
        if (newPath.endsWith("/") && !resultPath.endsWith("/")) {
            return resultPath + "/";
        }
        return resultPath;
    }

    public static final String getRelativeFilePath(String oldPath, String newPath) {
        String fromPath = new File(oldPath).getPath();
        String toPath = new File(newPath).getPath();
        if (toPath.matches("^\\[a-zA-Z]:")) {
            toPath = toPath.substring(1);
        }
        if (fromPath.matches("^\\[a-zA-Z]:")) {
            fromPath = fromPath.substring(1);
        }
        if (fromPath.startsWith(":", 1)) {
            fromPath = fromPath.substring(0, 1).toLowerCase() + fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1)) {
            toPath = toPath.substring(0, 1).toLowerCase() + toPath.substring(1);
        }
        if (toPath.startsWith(":", 1) && fromPath.startsWith(":", 1) && !toPath.substring(0, 1).equals(fromPath.substring(0, 1))) {
            return null;
        }
        if (toPath.startsWith(":", 1) && !fromPath.startsWith(":", 1) || !toPath.startsWith(":", 1) && fromPath.startsWith(":", 1)) {
            return null;
        }
        String resultPath = PathUtils.buildRelativePath(toPath, fromPath, File.separatorChar);
        if (newPath.endsWith(File.separator) && !resultPath.endsWith(File.separator)) {
            return resultPath + File.separator;
        }
        return resultPath;
    }

    private static final String buildRelativePath(String toPath, String fromPath, char separatorChar) {
        StringTokenizer toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        int count = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count;
        }
        toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        while (count-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        String relativePath = "";
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath = relativePath + "..";
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath = relativePath + separatorChar;
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath = relativePath + separatorChar;
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath = relativePath + toTokeniser.nextToken();
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath = relativePath + separatorChar;
        }
        return relativePath;
    }
}

