/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.decoration.io.xpp3;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.doxia.site.decoration.Banner;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.LinkItem;
import org.apache.maven.doxia.site.decoration.Logo;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.PublishDate;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.site.decoration.Version;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class DecorationXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, DecorationModel decorationModel) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(decorationModel.getModelEncoding(), null);
        this.writeDecorationModel(decorationModel, "project", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeBanner(Banner banner, String tagName, XmlSerializer serializer) throws IOException {
        if (banner != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (banner.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(banner.getName()).endTag(this.NAMESPACE, "name");
            }
            if (banner.getSrc() != null) {
                serializer.startTag(this.NAMESPACE, "src").text(banner.getSrc()).endTag(this.NAMESPACE, "src");
            }
            if (banner.getAlt() != null) {
                serializer.startTag(this.NAMESPACE, "alt").text(banner.getAlt()).endTag(this.NAMESPACE, "alt");
            }
            if (banner.getHref() != null) {
                serializer.startTag(this.NAMESPACE, "href").text(banner.getHref()).endTag(this.NAMESPACE, "href");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeBody(Body body, String tagName, XmlSerializer serializer) throws IOException {
        if (body != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (body.getHead() != null) {
                ((Xpp3Dom)body.getHead()).writeToSerializer(this.NAMESPACE, serializer);
            }
            if (body.getLinks() != null && body.getLinks().size() > 0) {
                serializer.startTag(this.NAMESPACE, "links");
                iter = body.getLinks().iterator();
                while (iter.hasNext()) {
                    o = (LinkItem)iter.next();
                    this.writeLinkItem((LinkItem)o, "item", serializer);
                }
                serializer.endTag(this.NAMESPACE, "links");
            }
            if (body.getBreadcrumbs() != null && body.getBreadcrumbs().size() > 0) {
                serializer.startTag(this.NAMESPACE, "breadcrumbs");
                iter = body.getBreadcrumbs().iterator();
                while (iter.hasNext()) {
                    o = (LinkItem)iter.next();
                    this.writeLinkItem((LinkItem)o, "item", serializer);
                }
                serializer.endTag(this.NAMESPACE, "breadcrumbs");
            }
            if (body.getMenus() != null && body.getMenus().size() > 0) {
                iter = body.getMenus().iterator();
                while (iter.hasNext()) {
                    o = (Menu)iter.next();
                    this.writeMenu((Menu)o, "menu", serializer);
                }
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDecorationModel(DecorationModel decorationModel, String tagName, XmlSerializer serializer) throws IOException {
        if (decorationModel != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (decorationModel.getName() != null) {
                serializer.attribute(this.NAMESPACE, "name", decorationModel.getName());
            }
            if (decorationModel.getBannerLeft() != null) {
                this.writeBanner(decorationModel.getBannerLeft(), "bannerLeft", serializer);
            }
            if (decorationModel.getBannerRight() != null) {
                this.writeBanner(decorationModel.getBannerRight(), "bannerRight", serializer);
            }
            if (decorationModel.getPublishDate() != null) {
                this.writePublishDate(decorationModel.getPublishDate(), "publishDate", serializer);
            }
            if (decorationModel.getVersion() != null) {
                this.writeVersion(decorationModel.getVersion(), "version", serializer);
            }
            if (decorationModel.getPoweredBy() != null && decorationModel.getPoweredBy().size() > 0) {
                serializer.startTag(this.NAMESPACE, "poweredBy");
                Iterator iter = decorationModel.getPoweredBy().iterator();
                while (iter.hasNext()) {
                    Logo o = (Logo)iter.next();
                    this.writeLogo(o, "logo", serializer);
                }
                serializer.endTag(this.NAMESPACE, "poweredBy");
            }
            if (decorationModel.getSkin() != null) {
                this.writeSkin(decorationModel.getSkin(), "skin", serializer);
            }
            if (decorationModel.getBody() != null) {
                this.writeBody(decorationModel.getBody(), "body", serializer);
            }
            if (decorationModel.getCustom() != null) {
                ((Xpp3Dom)decorationModel.getCustom()).writeToSerializer(this.NAMESPACE, serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeLinkItem(LinkItem linkItem, String tagName, XmlSerializer serializer) throws IOException {
        if (linkItem != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (linkItem.getName() != null) {
                serializer.attribute(this.NAMESPACE, "name", linkItem.getName());
            }
            if (linkItem.getHref() != null) {
                serializer.attribute(this.NAMESPACE, "href", linkItem.getHref());
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeLogo(Logo logo, String tagName, XmlSerializer serializer) throws IOException {
        if (logo != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (logo.getImg() != null) {
                serializer.attribute(this.NAMESPACE, "img", logo.getImg());
            }
            if (logo.getName() != null) {
                serializer.attribute(this.NAMESPACE, "name", logo.getName());
            }
            if (logo.getHref() != null) {
                serializer.attribute(this.NAMESPACE, "href", logo.getHref());
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeMenu(Menu menu, String tagName, XmlSerializer serializer) throws IOException {
        if (menu != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (menu.getName() != null) {
                serializer.attribute(this.NAMESPACE, "name", menu.getName());
            }
            if (menu.getInherit() != null) {
                serializer.attribute(this.NAMESPACE, "inherit", menu.getInherit());
            }
            if (menu.isInheritAsRef()) {
                serializer.attribute(this.NAMESPACE, "inheritAsRef", String.valueOf(menu.isInheritAsRef()));
            }
            if (menu.getRef() != null) {
                serializer.attribute(this.NAMESPACE, "ref", menu.getRef());
            }
            if (menu.getImg() != null) {
                serializer.attribute(this.NAMESPACE, "img", menu.getImg());
            }
            if (menu.getItems() != null && menu.getItems().size() > 0) {
                Iterator iter = menu.getItems().iterator();
                while (iter.hasNext()) {
                    MenuItem o = (MenuItem)iter.next();
                    this.writeMenuItem(o, "item", serializer);
                }
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeMenuItem(MenuItem menuItem, String tagName, XmlSerializer serializer) throws IOException {
        if (menuItem != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (menuItem.isCollapse()) {
                serializer.attribute(this.NAMESPACE, "collapse", String.valueOf(menuItem.isCollapse()));
            }
            if (menuItem.getRef() != null) {
                serializer.attribute(this.NAMESPACE, "ref", menuItem.getRef());
            }
            if (menuItem.getName() != null) {
                serializer.attribute(this.NAMESPACE, "name", menuItem.getName());
            }
            if (menuItem.getHref() != null) {
                serializer.attribute(this.NAMESPACE, "href", menuItem.getHref());
            }
            if (menuItem.getDescription() != null) {
                serializer.startTag(this.NAMESPACE, "description").text(menuItem.getDescription()).endTag(this.NAMESPACE, "description");
            }
            if (menuItem.getItems() != null && menuItem.getItems().size() > 0) {
                Iterator iter = menuItem.getItems().iterator();
                while (iter.hasNext()) {
                    MenuItem o = (MenuItem)iter.next();
                    this.writeMenuItem(o, "item", serializer);
                }
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePublishDate(PublishDate publishDate, String tagName, XmlSerializer serializer) throws IOException {
        if (publishDate != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (publishDate.getPosition() != null) {
                serializer.attribute(this.NAMESPACE, "position", publishDate.getPosition());
            }
            if (publishDate.getFormat() != null) {
                serializer.attribute(this.NAMESPACE, "format", publishDate.getFormat());
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeSkin(Skin skin, String tagName, XmlSerializer serializer) throws IOException {
        if (skin != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (skin.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(skin.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (skin.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(skin.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (skin.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(skin.getVersion()).endTag(this.NAMESPACE, "version");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeVersion(Version version, String tagName, XmlSerializer serializer) throws IOException {
        if (version != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (version.getPosition() != null) {
                serializer.attribute(this.NAMESPACE, "position", version.getPosition());
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

