/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.search.action;

import com.jaspersoft.jasperserver.search.common.RepositorySearchConfiguration;
import com.jaspersoft.jasperserver.search.common.SearchMode;
import com.jaspersoft.jasperserver.search.factory.RepositorySearchModeFactory;
import com.jaspersoft.jasperserver.search.state.InitialStateResolver;
import com.jaspersoft.jasperserver.search.util.JSONConverter;
import com.jaspersoft.jasperserver.war.action.BaseFormAction;
import org.springframework.context.i18n.LocaleContextHolder;
import com.jaspersoft.jasperserver.api.JSException;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;
import org.springframework.webflow.execution.RequestContext;

/**
 * Base search action handler.
 *
 * @author Yuriy Plakosh
 */
public class BaseSearchAction  extends BaseFormAction {
    // Session attributes.
    private static final String ATTRIBUTE_SEARCH_HOLDER = "searchHolder";

    // Request parameters.
    public static final String PARAMETER_SOURCE_FOLDER_URI = "sourceFolderUri";
    public static final String PARAMETER_FOLDER = "folder";
    public static final String PARAMETER_SELECTED_RESOURCES = "selectedResources";
    public static final String PARAMETER_DEST_FOLDER_URI = "destFolderUri";
    public static final String PARAMETER_SELECTED_RESOURCE = "selectedResource";
    private static final String PARAMETER_MODE = "mode";
    private static final String PARAMETER_LAST_MODE = "lastMode";

    private RepositorySearchModeFactory repositorySearchModeFactory;

    public void setRepositorySearchModeFactory(RepositorySearchModeFactory repositorySearchModeFactory) {
        this.repositorySearchModeFactory = repositorySearchModeFactory;
    }

    protected JSONConverter getConverter(RequestContext context) {
        return repositorySearchModeFactory.getConverter(getMode(context));
    }

    protected RepositorySearchConfiguration getConfiguration(RequestContext context) {
        return repositorySearchModeFactory.getConfiguration(getMode(context));
    }

    protected InitialStateResolver getInitialStateResolver(RequestContext context) {
        return repositorySearchModeFactory.getInitialStateResolver(getMode(context));
    }

    protected String getErrorMessage(Exception e) {
        String errorMsg;
        if (e instanceof JSException) {
            JSException jse = (JSException)e;
            errorMsg = messages.getMessage(jse.getMessage(), jse.getArgs(), LocaleContextHolder.getLocale());
        } else {
            errorMsg = e.getMessage();
        }

        return errorMsg;
    }

    protected void initSearchHolder(RequestContext context) {
        // Creating search holder if necessary.
        SearchHolder searchHolder = getSearchHolder(context);
        if (searchHolder == null) {
            searchHolder = new SearchHolder();
            context.getExternalContext().getSessionMap().put(ATTRIBUTE_SEARCH_HOLDER, searchHolder);
        }
    }

    protected SearchHolder getSearchHolder(RequestContext context) {
        SharedAttributeMap session = context.getExternalContext().getSessionMap();

        return (SearchHolder)session.get(ATTRIBUTE_SEARCH_HOLDER);
    }

    protected SearchMode getMode(RequestContext context) {
        ParameterMap map = context.getRequestParameters();

        SearchMode mode = SearchMode.BROWSE; // Default mode.

        String lastModeParameter = (String)map.get(PARAMETER_LAST_MODE, String.class);
        if (Boolean.parseBoolean(lastModeParameter)) {
            mode = getSearchHolder(context).getLastMode(); 
        } else {
            String modeParameter = (String)map.get(PARAMETER_MODE, String.class);

            if (modeParameter != null && SearchMode.SEARCH.toString().equals(modeParameter)) {
                mode = SearchMode.SEARCH;
            }
        }

        return mode;
    }

    protected Object getParameter(RequestContext context, String name, Class clazz) {
        ParameterMap map = context.getRequestParameters();

        if (map.contains(name)) {
            return map.get(name, clazz);
        } else {
            return null;
        }
    }
}
