/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl;

import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;

import com.jaspersoft.jasperserver.api.engine.common.domain.Result;


/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: AbstractAttributedObject.java 2140 2006-02-21 06:41:21Z tony $
 */
public class ReportUnitResult implements Result
{
	
	private String reportUnitURI;
	private JasperPrint jasperPrint = null;
	private JRVirtualizer virtualizer = null;

	public ReportUnitResult(
			String reportUnitURI,
			JasperPrint jasperPrint,
			JRVirtualizer virtualizer
			)
	{
		this.reportUnitURI = reportUnitURI;
		this.jasperPrint = jasperPrint;
		this.virtualizer = virtualizer;
	}
	
	/**
	 * @deprecated use {@link #ReportUnitResult(String, JasperPrint, JRVirtualizer)}
	 * to include the report unit URI as well
	 */
	public ReportUnitResult(
		JasperPrint jasperPrint,
		JRVirtualizer virtualizer
		)
	{
		this(null, jasperPrint, virtualizer);
	}
	
	/**
	 * 
	 */
	public JasperPrint getJasperPrint()
	{
		return jasperPrint;
	}
	
	/**
	 * 
	 */
	public JRVirtualizer getVirtualizer()
	{
		return virtualizer;
	}

	/**
	 * Returns the URI of the report unit for which this result was created.
	 * 
	 * @return the report unit URI
	 */
	public String getReportUnitURI()
	{
		return reportUnitURI;
	}
	
}
