/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.MsgIn;
import com.ingres.gcf.dam.OutBuff;
import com.ingres.gcf.dam.TlConst;
import com.ingres.gcf.util.CompatCI;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.TraceLog;
import java.util.Random;

public class MsgConn
extends MsgIn
implements TlConst,
GcfErr {
    private OutBuff cncl = null;
    private boolean lock_active = false;
    private Thread lock_thread = null;
    private Object lock_obj = new Object();
    private static byte[] KS = new byte[384];
    private static byte[] kbuff = new byte[8];
    private static Random rand = new Random(System.currentTimeMillis());

    public MsgConn(String string, byte[][] byArray, TraceLog traceLog) throws SqlEx {
        super(string, byArray, traceLog);
        this.title = "Msg[" + this.connID() + "]";
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        if (this.cncl != null) {
            try {
                this.cncl.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.cncl = null;
            }
        }
        super.disconnect();
    }

    public synchronized void close() {
        if (!this.isClosed()) {
            super.close();
            this.disconnect();
        }
    }

    public synchronized void cancel() throws SqlEx {
        if (this.cncl == null) {
            try {
                this.cncl = new OutBuff(this.socket.getOutputStream(), this.connID(), 16, this.trace.getTraceLog());
                this.cncl.setProtoLvl(this.tl_proto_lvl);
            }
            catch (Exception exception) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error creating cancel buffer: " + exception.getMessage());
                }
                this.disconnect();
                throw SqlEx.get(ERR_GC4001_CONNECT_ERR, exception);
            }
        }
        try {
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": interrupt network connection");
            }
            this.cncl.begin((short)21065, 0);
            this.cncl.flush();
        }
        catch (SqlEx sqlEx) {
            this.disconnect();
            throw sqlEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws SqlEx {
        Object object = this.lock_obj;
        synchronized (object) {
            while (this.lock_active) {
                if (this.lock_thread == Thread.currentThread()) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.title + ".lock(): connection locked by " + Thread.currentThread());
                    }
                    throw SqlEx.get(ERR_GC4005_SEQUENCING);
                }
                try {
                    this.lock_obj.wait();
                }
                catch (Exception exception) {}
            }
            this.lock_thread = Thread.currentThread();
            this.lock_active = true;
            if (this.trace.enabled(5)) {
                this.trace.write(this.title + ".lock(): owner " + this.lock_thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.lock_obj;
        synchronized (object) {
            if (this.lock_thread == null || !this.lock_active) {
                if (this.trace.enabled(5)) {
                    this.trace.write(this.title + ".unlock(): conn not locked!");
                }
                this.lock_thread = null;
                this.lock_active = false;
            } else {
                if (this.trace.enabled(5)) {
                    this.trace.write(this.title + ".unlock(): owner " + this.lock_thread);
                    if (this.lock_thread != Thread.currentThread()) {
                        this.trace.write(this.title + ".unlock(): current thread " + Thread.currentThread());
                    }
                }
                this.lock_active = false;
                this.lock_thread = null;
                this.lock_obj.notify();
            }
        }
    }

    public byte[] encode(String string, byte[] byArray, String string2) throws SqlEx {
        byte[] byArray2;
        try {
            byArray2 = MsgConn.encode(this.char_set.getBytes(string), byArray, this.char_set.getBytes(string2));
        }
        catch (Exception exception) {
            throw SqlEx.get(ERR_GC401E_CHAR_ENCODE);
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = null;
        byte[] byArray5 = KS;
        synchronized (KS) {
            int n;
            int n2 = 0;
            for (n = 0; n < 8; ++n) {
                if (n2 >= byArray.length) {
                    n2 = 0;
                }
                MsgConn.kbuff[n] = (byte)(byArray[n2++] ^ (byArray2 != null ? byArray2[n] : (byte)0));
            }
            CompatCI.setkey(kbuff, KS);
            int n3 = byArray3.length / 7 + 1;
            byArray4 = new byte[n3 * 8];
            n2 = 0;
            n = 0;
            for (int i = 0; i < n3; ++i) {
                byArray4[n++] = (byte)rand.nextInt(256);
                for (int j = 1; j < 8; ++j) {
                    if (n2 < byArray3.length) {
                        byArray4[n++] = byArray3[n2++];
                        continue;
                    }
                    if (n2 > byArray3.length) {
                        byArray4[n++] = (byte)rand.nextInt(256);
                        continue;
                    }
                    byArray4[n++] = 0;
                    ++n2;
                }
            }
            CompatCI.encode(byArray4, 0, byArray4.length, KS, byArray4, 0);
            // ** MonitorExit[var9_4] (shouldn't be in output)
            return byArray4;
        }
    }
}

