/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlEx;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;

public class SqlVarChar
extends SqlData
implements ByteArray {
    private static final byte[] empty = new byte[0];
    protected byte[] value = empty;
    protected int limit = -1;
    protected int length = 0;
    protected CharSet charSet = null;

    public SqlVarChar(CharSet charSet) {
        super(true);
        this.charSet = charSet;
    }

    public SqlVarChar(CharSet charSet, int n) {
        this(charSet);
        this.limit = n;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int n) {
        this.ensure(n);
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int n) {
        int n2 = this.limit = n < 0 ? -1 : n;
        if (this.limit >= 0 && this.length > this.limit) {
            this.length = this.limit;
        }
    }

    public void limit(int n, boolean bl) {
        this.limit(n);
        if (bl) {
            this.ensure(n);
        }
    }

    public int length() {
        return this.length;
    }

    public void clear() {
        this.setNotNull();
        this.length = 0;
    }

    public void set(SqlVarChar sqlVarChar) {
        if (sqlVarChar == null || sqlVarChar.isNull()) {
            this.setNull();
        } else {
            this.clear();
            this.put(sqlVarChar.value, 0, sqlVarChar.length);
        }
    }

    public int put(byte by) {
        if (this.limit >= 0 && this.length >= this.limit) {
            return 0;
        }
        this.ensure(this.length + 1);
        this.value[this.length++] = by;
        return 1;
    }

    public int put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    public int put(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n3 = this.limit < 0 ? n2 : this.limit - this.length;
        if (n2 > n3) {
            n2 = n3;
        }
        this.ensure(this.length + n2);
        System.arraycopy(byArray, n, this.value, this.length, n2);
        this.length += n2;
        return n2;
    }

    public byte get(int n) {
        return n >= this.length ? (byte)0 : this.value[n];
    }

    public byte[] get() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.value, 0, byArray, 0, this.length);
        return byArray;
    }

    public int get(byte[] byArray) {
        return this.get(0, byArray.length, byArray, 0);
    }

    public int get(int n, int n2, byte[] byArray, int n3) {
        int n4;
        int n5 = n4 = n >= this.length ? 0 : this.length - n;
        if (n2 > n4) {
            n2 = n4;
        }
        System.arraycopy(this.value, n, byArray, n3, n2);
        return n2;
    }

    protected void ensure(int n) {
        if (this.limit >= 0 && n > this.limit) {
            n = this.limit;
        }
        if (n > this.value.length) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.value, 0, byArray, 0, this.length);
            this.value = byArray;
        }
    }

    public void setBoolean(boolean bl) throws SqlEx {
        this.setString(Boolean.toString(bl));
    }

    public void setByte(byte by) throws SqlEx {
        this.setString(Byte.toString(by));
    }

    public void setShort(short s) throws SqlEx {
        this.setString(Short.toString(s));
    }

    public void setInt(int n) throws SqlEx {
        this.setString(Integer.toString(n));
    }

    public void setLong(long l) throws SqlEx {
        this.setString(Long.toString(l));
    }

    public void setFloat(float f) throws SqlEx {
        this.setString(Float.toString(f));
    }

    public void setDouble(double d) throws SqlEx {
        this.setString(Double.toString(d));
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setString(bigDecimal.toString());
        }
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            byte[] byArray;
            try {
                byArray = this.charSet.getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw SqlEx.get(ERR_GC401E_CHAR_ENCODE);
            }
            if (byArray.length > this.value.length) {
                int n = byArray.length;
                if (this.limit >= 0 && n > this.limit) {
                    n = this.limit;
                }
                this.setNotNull();
                this.value = byArray;
                this.length = n;
            } else {
                this.clear();
                this.put(byArray);
            }
        }
    }

    public void setDate(Date date, TimeZone timeZone) throws SqlEx {
        if (date == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatDate((java.util.Date)date, timeZone));
        } else {
            this.setString(SqlDates.formatDate((java.util.Date)date, false));
        }
    }

    public void setTime(Time time, TimeZone timeZone) throws SqlEx {
        if (time == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatTime((java.util.Date)time, timeZone));
        } else {
            this.setString(SqlDates.formatTime((java.util.Date)time, false));
        }
    }

    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SqlEx {
        if (timestamp == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatTimestamp((java.util.Date)timestamp, timeZone));
        } else {
            this.setString(SqlDates.formatTimestamp((java.util.Date)timestamp, false));
        }
    }

    public boolean getBoolean() throws SqlEx {
        String string = this.getString(this.length).trim();
        return string.equals("1") ? true : Boolean.valueOf(string);
    }

    public byte getByte() throws SqlEx {
        byte by;
        try {
            by = Byte.parseByte(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return by;
    }

    public short getShort() throws SqlEx {
        short s;
        try {
            s = Short.parseShort(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return s;
    }

    public int getInt() throws SqlEx {
        int n;
        try {
            n = Integer.parseInt(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return n;
    }

    public long getLong() throws SqlEx {
        long l;
        try {
            l = Long.parseLong(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return l;
    }

    public float getFloat() throws SqlEx {
        float f;
        try {
            f = Float.parseFloat(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return f;
    }

    public double getDouble() throws SqlEx {
        double d;
        try {
            d = Double.parseDouble(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return d;
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return bigDecimal;
    }

    public String getString() throws SqlEx {
        return this.getString(this.length);
    }

    public String getString(int n) throws SqlEx {
        if (n > this.length) {
            n = this.length;
        }
        try {
            return this.charSet.getString(this.value, 0, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlEx.get(ERR_GC401E_CHAR_ENCODE);
        }
    }

    public Date getDate(TimeZone timeZone) throws SqlEx {
        String string = this.getString(this.length).trim();
        return timeZone == null ? SqlDates.parseDate(string, false) : SqlDates.parseDate(string, timeZone);
    }

    public Time getTime(TimeZone timeZone) throws SqlEx {
        String string = this.getString(this.length).trim();
        return timeZone == null ? SqlDates.parseTime(string, false) : SqlDates.parseTime(string, timeZone);
    }

    public Timestamp getTimestamp(TimeZone timeZone) throws SqlEx {
        String string = this.getString(this.length).trim();
        return timeZone == null ? SqlDates.parseTimestamp(string, false) : SqlDates.parseTimestamp(string, timeZone);
    }

    public InputStream getAsciiStream() throws SqlEx {
        return SqlVarChar.getAscii(this.getString());
    }

    public InputStream getUnicodeStream() throws SqlEx {
        return SqlVarChar.getUnicode(this.getString());
    }

    public Reader getCharacterStream() throws SqlEx {
        return SqlVarChar.getCharacter(this.getString());
    }

    public Object getObject() throws SqlEx {
        return this.getString();
    }

    public Object getObject(int n) throws SqlEx {
        return this.getString(n);
    }
}

