/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.wizard;

import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.ComponentSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.wizard.PageListener;
import com.tonbeller.wcf.wizard.WizardPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class WizardComponent
extends ComponentSupport {
    private List pages = new ArrayList();
    private WizardPage current = null;
    private static Logger logger = Logger.getLogger(WizardComponent.class);
    private PageListener pageListener = new PageListener(){

        public void onNext(RequestContext context) throws Exception {
            WizardComponent.this.setCurrentPageIndex(WizardComponent.this.getCurrentPageIndex() + 1);
        }

        public void onBack(RequestContext context) throws Exception {
            WizardComponent.this.setCurrentPageIndex(WizardComponent.this.getCurrentPageIndex() - 1);
        }

        public void onFinish(RequestContext context) throws Exception {
            int pageCnt = WizardComponent.this.pages.size();
            int cur = WizardComponent.this.getCurrentPageIndex();
            for (int i = cur + 1; i < pageCnt; ++i) {
                WizardPage page = (WizardPage)WizardComponent.this.pages.get(i);
                page.pageSkipped();
            }
            WizardComponent.this.setCurrentPageIndex(0);
        }

        public void onCancel(RequestContext context) throws Exception {
            WizardComponent.this.setCurrentPageIndex(0);
        }
    };

    public WizardComponent(String id, Component parent) {
        super(id, parent);
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public int getCurrentPageIndex() {
        return this.pages.indexOf(this.current);
    }

    public void setCurrentPageIndex(int page) {
        if (page >= this.pages.size()) {
            throw new IllegalArgumentException("Invalid index " + page);
        }
        this.current = (WizardPage)this.pages.get(page);
        this.adjustVisibility();
    }

    public WizardPage getCurrentPage() {
        return this.current;
    }

    public void setCurrentPage(WizardPage page) {
        if (!this.pages.contains(page)) {
            throw new IllegalArgumentException("page must be registered with the wizard");
        }
        this.current = page;
        this.adjustVisibility();
    }

    public void addPage(WizardPage page) {
        this.pages.add(page);
        page.addPageListener(this.pageListener);
        int cnt = this.pages.size();
        for (int i = 0; i < cnt; ++i) {
            WizardPage wp = (WizardPage)this.pages.get(i);
            if (cnt == 1) {
                wp.pageAdded(WizardPage.WizardPagePosition.SINGLE_PAGE);
                continue;
            }
            if (i == 0) {
                wp.pageAdded(WizardPage.WizardPagePosition.FIRST_PAGE);
                continue;
            }
            if (i == cnt - 1) {
                wp.pageAdded(WizardPage.WizardPagePosition.LAST_PAGE);
                continue;
            }
            wp.pageAdded(WizardPage.WizardPagePosition.MIDDLE_PAGE);
        }
    }

    public void removePage(WizardPage page) {
        page.removePageListener(this.pageListener);
        this.pages.remove(page);
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        this.setCurrentPageIndex(0);
    }

    public Document render(RequestContext context) throws Exception {
        return this.current.render(context);
    }

    private void adjustVisibility() {
        int pageCnt = this.pages.size();
        for (int i = 0; i < pageCnt; ++i) {
            WizardPage p;
            p.setVisible((p = (WizardPage)this.pages.get(i)) == this.current && this.isVisible());
        }
    }

    public WizardPage getPage(int idx) {
        return (WizardPage)this.pages.get(idx);
    }
}

