/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ReportExecuter;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: ReportUnitRequestBase.java 19922 2010-12-11 14:59:51Z tmatyashovsky $
 */
public abstract class ReportUnitRequestBase implements Request {
	
	private static final AtomicInteger COUNTER = new AtomicInteger();
	
	private final String id;
	private Map reportParameters;

	protected ReportUnitRequestBase(Map reportParameters) {
		this.id = System.identityHashCode(this) 
			+ "_" + System.currentTimeMillis() 
			+ "_" + COUNTER.incrementAndGet();

		this.reportParameters = reportParameters;
	}

	/**
	 *
	 */
	public Map getReportParameters()
	{
		return reportParameters;
	}

	/**
	 *
	 */
	public void setReportParameters(Map reportParameters)
	{
		this.reportParameters = reportParameters;
	}

	public String getId()
	{
		return id;
	}
	
	public abstract ReportUnitResult execute(ExecutionContext context, ReportExecuter executer);

}
