/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import java.util.TimeZone;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory;

/**
 * @author swood
 *
 */
public class JndiJdbcReportDataSourceServiceFactory implements ReportDataSourceServiceFactory {

	private static final Log log = LogFactory.getLog(JndiJdbcReportDataSourceServiceFactory.class);
	
	private Context ctx = null;
	
	public JndiJdbcReportDataSourceServiceFactory() {
		try {
			
			// Set the context here, as it is a heavyweight constructor
			
			ctx = new InitialContext();
		} catch (NamingException e) {
			log.error(e);
			throw new JSException(e);
		}
	}

	/* (non-Javadoc)
	 * @see com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory#createService(com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource)
	 */
	public ReportDataSourceService createService(ReportDataSource dataSource) {
		try {
			if (!(dataSource instanceof JndiJdbcReportDataSource)) {
				throw new JSException("jsexception.invalid.jndi.jdbc.datasource", new Object[] {dataSource.getClass()});
			}
			JndiJdbcReportDataSource jndiDataSource = (JndiJdbcReportDataSource) dataSource;
			
			String jndiName = jndiDataSource.getJndiName();
			
			DataSource ds = (DataSource) ctx.lookup("java:comp/env/" + jndiName);
			TimeZone timeZone = jndiDataSource.getTimezone() != null ? TimeZone.getTimeZone(jndiDataSource.getTimezone()) : null;
			return new JdbcDataSourceService(ds, timeZone);
		} catch (NamingException e) {
			if (log.isDebugEnabled())
				log.debug(e, e);
			throw new JSExceptionWrapper(e);
		}
	}

}
