/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.cascade.cache;

import java.util.*;

/**
 * CacheCleaner
 * @author jwhang
 * @version $Id: CacheCleaner.java 19932 2010-12-11 15:24:29Z tmatyashovsky $
 */

public class CacheCleaner extends TimerTask {

    private Map<String, SessionCache> userCachePool;
    private long userCacheTimeout;

    public CacheCleaner(Map<String, SessionCache> userCachePool,
            long userCacheTimeout){
        this.userCachePool = userCachePool;
        this.userCacheTimeout = userCacheTimeout;
    }

    public void run(){
        long curTime = System.currentTimeMillis();

        synchronized (userCachePool) {
            for (String key : userCachePool.keySet()){
                SessionCache cache = userCachePool.get(key);
                if ((curTime - cache.getLastInteraction()) > userCacheTimeout) {
                    //remove this object.
                    userCachePool.remove(key);
                }
            }
        }
    }
}
