/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.FileBufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class FileBufferedDataContainer
implements DataContainer {
    public static final int DEFAULT_MEMORY_THRESHOLD = 65536;
    public static final int DEFAULT_INITIAL_MEMORY_BUFFER = 16384;
    private int memoryThreshold;
    private transient FileBufferedOutputStream data;

    public FileBufferedDataContainer() {
        this(65536, 16384);
    }

    public FileBufferedDataContainer(int memoryThreshold, int initialMemoryBuffer) {
        this.memoryThreshold = memoryThreshold;
        this.createDataBuffer(initialMemoryBuffer);
    }

    private void createDataBuffer(int initialMemoryBuffer) {
        this.data = new FileBufferedOutputStream(this.memoryThreshold, initialMemoryBuffer);
    }

    public OutputStream getOutputStream() {
        return this.data;
    }

    public byte[] getData() {
        return DataContainerStreamUtil.readData(this.getInputStream());
    }

    public InputStream getInputStream() {
        try {
            return this.data.getDataInputStream();
        }
        catch (IOException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public int dataSize() {
        return this.data.size();
    }

    public boolean hasData() {
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.memoryThreshold);
        stream.writeInt(this.data.size());
        DataContainerStreamUtil.writeObjectByteData(stream, this.data.getDataInputStream());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.memoryThreshold = stream.readInt();
        int size = stream.readInt();
        this.createDataBuffer(size <= this.memoryThreshold ? size : this.memoryThreshold);
        DataContainerStreamUtil.readObjectByteData(stream, size, this.data);
        this.data.close();
    }
}

