/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui.inputcontrols.ui;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.InputControlQueryDataRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ItemRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel[] labels = null;
    int columns = 0;

    public ItemRenderer(int columns) {
        this.setOpaque(true);
        GridLayout g = new GridLayout(1, columns);
        this.setLayout(g);
        this.columns = columns;
        this.labels = new JLabel[columns];
        for (int i = 0; i < columns; ++i) {
            this.labels[i] = new JLabel(" ");
            this.add(this.labels[i]);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null && value instanceof InputControlQueryDataRow) {
            InputControlQueryDataRow icqdr = (InputControlQueryDataRow)value;
            if (value != null) {
                for (int i = 0; i < this.columns; ++i) {
                    String s = " ";
                    try {
                        if (icqdr.getColumnValues().get(i) != null) {
                            s = "" + icqdr.getColumnValues().get(i);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.getLabels()[i].setText(s);
                }
                this.updateUI();
            }
        } else {
            this.getLabels()[0].setText(value + "");
            for (int i = 1; i < this.columns; ++i) {
                this.getLabels()[i].setText(" ");
            }
        }
        if (isSelected) {
            this.setBackground(Color.black);
            for (int i = 0; i < this.columns; ++i) {
                this.getLabels()[i].setForeground(Color.white);
            }
        } else {
            this.setBackground(Color.white);
            for (int i = 0; i < this.columns; ++i) {
                this.getLabels()[i].setForeground(Color.black);
            }
        }
        return this;
    }

    public JLabel[] getLabels() {
        return this.labels;
    }

    public void setLabels(JLabel[] labels) {
        this.labels = labels;
    }
}

