/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator.ElementValidationItem;
import com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator.ImageElementValidationItem;
import com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator.JrxmlValidationDialog;
import com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator.SubReportElementValidationItem;
import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.SubReportElement;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class UploadResourcesDialog
extends JDialog
implements Runnable {
    private JrxmlValidationDialog validationDialog = null;
    private List resourceItems = null;
    private JLabel jLabel;
    private JProgressBar jProgressBar1;

    public UploadResourcesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jProgressBar1.setMinimum(0);
        this.jProgressBar1.setMaximum(100);
        this.jProgressBar1.setValue(0);
        Misc.centerFrame((Component)this);
    }

    public void setLabel(String label) {
        this.jLabel.setText(label);
    }

    public void setCompletation(int d) {
        this.jProgressBar1.setValue(d);
    }

    public void startProcessing() {
        Thread t = new Thread(this);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block16: {
            this.jProgressBar1.setValue(0);
            this.jLabel.setText(IRPlugin.getString("uploadResourcesDialog.adaptingJRXML", "Adapting JRXML source..."));
            JrxmlValidationDialog vd = this.getValidationDialog();
            this.jProgressBar1.setValue(5);
            for (int i = 0; i < this.resourceItems.size(); ++i) {
                ElementValidationItem iev;
                this.jProgressBar1.setValue(15);
                ElementValidationItem evi = (ElementValidationItem)this.resourceItems.get(i);
                ResourceDescriptor newDescriptor = new ResourceDescriptor();
                newDescriptor.setUriString(evi.getParentFolder() + "/" + evi.getResourceName());
                newDescriptor.setParentFolder(evi.getParentFolder());
                newDescriptor.setName(evi.getResourceName());
                newDescriptor.setLabel(evi.getResourceName());
                newDescriptor.setIsNew(true);
                newDescriptor.setHasData(true);
                if (evi instanceof ImageElementValidationItem) {
                    iev = (ImageElementValidationItem)evi;
                    Image img = ((ImageReportElement)iev.getReportElement()).getImg();
                    ((ImageReportElement)iev.getReportElement()).setImageExpression("\"" + iev.getProposedExpression() + "\"");
                    ((ImageReportElement)iev.getReportElement()).setImg(img);
                    this.jProgressBar1.setValue(20);
                    newDescriptor.setWsType("img");
                } else if (evi instanceof SubReportElementValidationItem) {
                    iev = (SubReportElementValidationItem)evi;
                    ((SubReportElement)iev.getReportElement()).setSubreportExpression("\"" + iev.getProposedExpression() + "\"");
                    newDescriptor.setWsType("jrxml");
                }
                this.jLabel.setText(IRPlugin.getFormattedString("uploadResourcesDialog.uploadingResource", "Uploading {0}", new Object[]{evi.getOriginalFileName().getName()}));
                System.out.println("Modifing resource with RU " + vd.getReportUnit());
                System.out.flush();
                vd.getServer().getWSClient().modifyReportUnitResource(vd.getReportUnit() != null ? vd.getReportUnit().getDescriptor().getUriString() : null, newDescriptor, evi.getOriginalFileName());
                this.jProgressBar1.setValue((int)(100.0 / (double)i));
            }
            vd.getReport().saveXMLFile();
            IRPlugin.getMainInstance().getRepositoryExplorer().refreshContentNodeObject(vd.getReportUnit());
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        UploadResourcesDialog.this.setVisible(false);
                        UploadResourcesDialog.this.dispose();
                    }
                });
            }
            catch (Exception ex3) {}
            break block16;
            catch (Exception ex) {
                try {
                    final Exception ex2 = ex;
                    ex.printStackTrace();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                UploadResourcesDialog.this.setVisible(false);
                                UploadResourcesDialog.this.dispose();
                                JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), IRPlugin.getFormattedString("uploadResourcesDialog.uploadingResourceError", "An error occurred during resource upload:\n{0}", new Object[]{ex2.getMessage()}), "Error", 0);
                            }
                        });
                    }
                    catch (Exception ex3) {
                        // empty catch block
                    }
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception ex3) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception exception) {}
            }
        }
        this.getValidationDialog().elaborationFinished(true);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.startProcessing();
        }
        super.setVisible(b);
    }

    private void initComponents() {
        this.jLabel = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel.setText("Uploading resources...");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 8);
        this.getContentPane().add((Component)this.jLabel, gridBagConstraints);
        this.jProgressBar1.setPreferredSize(new Dimension(250, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 8);
        this.getContentPane().add((Component)this.jProgressBar1, gridBagConstraints);
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new UploadResourcesDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public JrxmlValidationDialog getValidationDialog() {
        return this.validationDialog;
    }

    public void setValidationDialog(JrxmlValidationDialog validationDialog) {
        this.validationDialog = validationDialog;
    }

    public List getResourceItems() {
        return this.resourceItems;
    }

    public void setResourceItems(List resourceItems) {
        this.resourceItems = resourceItems;
    }
}

