/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapCacheRegion {
    private final BitKey bitKey;
    private final Map<Integer, StarColumnPredicate> columnPredicates = new HashMap<Integer, StarColumnPredicate>();
    private Map<List<RolapStar.Column>, StarPredicate> predicates = new HashMap<List<RolapStar.Column>, StarPredicate>();

    public RolapCacheRegion(RolapStar star, List<RolapStar.Measure> starMeasureList) {
        this.bitKey = BitKey.Factory.makeBitKey(star.getColumnCount());
        for (RolapStar.Measure measure : starMeasureList) {
            this.bitKey.set(measure.getBitPosition());
        }
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.bitKey;
    }

    public void addPredicate(RolapStar.Column column, StarColumnPredicate predicate) {
        int bitPosition = column.getBitPosition();
        assert (!this.bitKey.get(bitPosition));
        this.bitKey.set(bitPosition);
        this.columnPredicates.put(bitPosition, predicate);
    }

    public StarColumnPredicate getPredicate(int columnOrdinal) {
        return this.columnPredicates.get(columnOrdinal);
    }

    public void addPredicate(StarPredicate predicate) {
        List<RolapStar.Column> columnList = predicate.getConstrainedColumnList();
        this.predicates.put(new ArrayList<RolapStar.Column>(columnList), predicate);
        for (RolapStar.Column column : columnList) {
            this.bitKey.set(column.getBitPosition());
        }
    }

    public Collection<StarPredicate> getPredicates() {
        return this.predicates.values();
    }
}

