/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.reflect.Modifier;
import org.springframework.core.type.ClassMetadata;

public class StandardClassMetadata
implements ClassMetadata {
    private final Class introspectedClass;

    public StandardClassMetadata(Class introspectedClass) {
        this.introspectedClass = introspectedClass;
    }

    public final Class getIntrospectedClass() {
        return this.introspectedClass;
    }

    public String getClassName() {
        return this.getIntrospectedClass().getName();
    }

    public boolean isInterface() {
        return this.getIntrospectedClass().isInterface();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getIntrospectedClass().getModifiers());
    }

    public boolean isConcrete() {
        return !this.isInterface() && !this.isAbstract();
    }

    public boolean isIndependent() {
        return !this.hasEnclosingClass() || this.getIntrospectedClass().getDeclaringClass() != null && Modifier.isStatic(this.getIntrospectedClass().getModifiers());
    }

    public boolean hasEnclosingClass() {
        return this.getIntrospectedClass().getEnclosingClass() != null;
    }

    public String getEnclosingClassName() {
        Class<?> enclosingClass = this.getIntrospectedClass().getEnclosingClass();
        return enclosingClass != null ? enclosingClass.getName() : null;
    }

    public boolean hasSuperClass() {
        return this.getIntrospectedClass().getSuperclass() != null;
    }

    public String getSuperClassName() {
        Class superClass = this.getIntrospectedClass().getSuperclass();
        return superClass != null ? superClass.getName() : null;
    }

    public String[] getInterfaceNames() {
        Class<?>[] ifcs = this.getIntrospectedClass().getInterfaces();
        String[] ifcNames = new String[ifcs.length];
        for (int i = 0; i < ifcs.length; ++i) {
            ifcNames[i] = ifcs[i].getName();
        }
        return ifcNames;
    }
}

