/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.resources.paint;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.flexdock.plaf.resources.paint.Painter;
import org.flexdock.plaf.resources.paint.PainterResource;

public class DefaultPainter
implements Painter {
    public static final Color DEFAULT_BG_COLOR = UIManager.getColor("Panel.background");
    public static final Color DEFAULT_BG_COLOR_ACTIVE = UIManager.getColor("InternalFrame.activeTitleBackground");
    protected PainterResource painterResource;

    public void paint(Graphics g, int width, int height, boolean active, JComponent titlebar) {
        Color c = this.getBackgroundColor(active);
        g.setColor(c);
        g.fillRect(0, 0, width, height);
    }

    protected Color getBackgroundColor(boolean active) {
        return active ? this.getBackgroundColorActive() : this.getBackgroundColorInactive();
    }

    protected Color getBackgroundColorInactive() {
        return this.painterResource.getBgColor() == null ? DEFAULT_BG_COLOR : this.painterResource.getBgColor();
    }

    protected Color getBackgroundColorActive() {
        return this.painterResource.getBgColorActive() == null ? DEFAULT_BG_COLOR_ACTIVE : this.painterResource.getBgColorActive();
    }

    public PainterResource getPainterResource() {
        return this.painterResource;
    }

    public void setPainterResource(PainterResource painterResource) {
        this.painterResource = painterResource;
    }
}

