/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.engine.common.service.VirtualizerFactory;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GZipVirtualizerFactory
implements VirtualizerFactory {
    private static final Log log = LogFactory.getLog(GZipVirtualizerFactory.class);
    public static final int DEFAULT_MAX_SIZE = 200;
    private int maxSize = 200;

    public JRVirtualizer getVirtualizer() {
        JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(this.maxSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created GZip virtualizer " + virtualizer + " using " + this.maxSize + " as maxSize"));
        }
        return virtualizer;
    }

    public void disposeVirtualizer(JRVirtualizer virtualizer) {
        if (virtualizer != null) {
            virtualizer.cleanup();
            if (log.isDebugEnabled() && log.isDebugEnabled()) {
                log.debug((Object)("Disposed virtualizer " + virtualizer));
            }
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

