/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.DbcpDataSource;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.PooledDataSource;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.PooledJdbcDataSourceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPoolFactory;

public class DbcpDataSourceFactory
implements PooledJdbcDataSourceFactory {
    private static final Log log = LogFactory.getLog(DbcpDataSourceFactory.class);
    private ObjectPoolFactory objectPoolFactory;

    public PooledDataSource createPooledDataSource(String driverClass, String url, String username, String password) {
        this.registerDriver(driverClass);
        return new DbcpDataSource(this.objectPoolFactory, url, username, password);
    }

    public PooledDataSource createPooledDataSource(String driverClass, String url, String username, String password, boolean defaultReadOnly, boolean defaultAutoCommit) {
        this.registerDriver(driverClass);
        return new DbcpDataSource(this.objectPoolFactory, url, username, password, defaultReadOnly, defaultAutoCommit);
    }

    protected void registerDriver(String driverClass) {
        try {
            Class.forName(driverClass, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public ObjectPoolFactory getObjectPoolFactory() {
        return this.objectPoolFactory;
    }

    public void setObjectPoolFactory(ObjectPoolFactory genericObjectPoolFactory) {
        this.objectPoolFactory = genericObjectPoolFactory;
    }
}

