/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationDetail;
import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationDetailImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationResultImpl;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.domain.Result;
import com.jaspersoft.jasperserver.api.engine.common.service.BuiltInParameterProvider;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.IQueryManipulator;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlsInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ReportExecuter;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequestBase;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CacheableCompiledReports;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CompiledReportProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.DefaultRepositoryContextManager;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.InternalReportCompiler;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JasperReportInputControlInformation;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportInputControlsInformationImpl;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.RepositoryContextManager;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DefaultProtectionDomainProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JRQueryExecuterAdapter;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JarsClassLoader;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.ProtectionDomainProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryCacheMap;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryResourceClassLoader;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryResourceKey;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryUtil;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.ResourceCollector;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo.RepositoryURLHandlerFactory;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCache;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCacheableItem;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarFile;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.fill.JRParameterDefaultValuesEvaluator;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class EngineServiceImpl
implements EngineService,
ReportExecuter,
CompiledReportProvider,
InternalReportCompiler,
InitializingBean {
    protected static final Log log = LogFactory.getLog(EngineServiceImpl.class);
    protected static final Log valueQueryLog = LogFactory.getLog((String)"valueQueryLog");
    private DataSourceServiceFactory dataSourceServiceFactories;
    protected RepositoryService repository;
    private SecurityContextProvider securityContextProvider;
    private ProtectionDomainProvider reportJarsProtectionDomainProvider = new DefaultProtectionDomainProvider();
    private String reportParameterLabelKeyPrefix;
    private IQueryManipulator queryManipulator = null;
    private RepositoryCacheMap tempJarFiles;
    private RepositoryCache compiledReportsCache;
    private final ReferenceMap jarsClassLoaderCache;
    private final ReferenceMap resourcesClassLoaderCache;
    private RepositoryCacheableItem cacheableCompiledReports;
    private RepositoryContextManager repositoryContextManager;
    private List builtInParameterProviders = new ArrayList();
    private AuditContext auditContext;

    public EngineServiceImpl() {
        this.jarsClassLoaderCache = new ReferenceMap(2, 1);
        this.resourcesClassLoaderCache = new ReferenceMap(2, 1);
        this.cacheableCompiledReports = new CacheableCompiledReports(this);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.repositoryContextManager == null) {
            this.repositoryContextManager = new DefaultRepositoryContextManager(this.repository, this);
        }
        this.createJarFilesCache();
    }

    public IQueryManipulator getQueryManipulator() {
        return this.queryManipulator;
    }

    public void setQueryManipulator(IQueryManipulator queryManipulator) {
        this.queryManipulator = queryManipulator;
    }

    public RepositoryService getRepositoryService() {
        return this.repository;
    }

    public void setRepositoryService(RepositoryService repository) {
        this.repository = repository;
    }

    public RepositoryCache getCompiledReportsCache() {
        return this.compiledReportsCache;
    }

    public void setCompiledReportsCache(RepositoryCache compiledReportsCache) {
        this.compiledReportsCache = compiledReportsCache;
    }

    public RepositoryCacheableItem getCacheableCompiledReports() {
        return this.cacheableCompiledReports;
    }

    public void setCacheableCompiledReports(RepositoryCacheableItem cacheableCompiledReports) {
        this.cacheableCompiledReports = cacheableCompiledReports;
    }

    public RepositoryContextManager getRepositoryContextManager() {
        return this.repositoryContextManager;
    }

    public void setRepositoryContextManager(RepositoryContextManager repositoryContextManager) {
        this.repositoryContextManager = repositoryContextManager;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public List getBuiltInParameterProviders() {
        return this.builtInParameterProviders;
    }

    public void setBuiltInParameterProviders(List builtInParameterProviders) {
        this.builtInParameterProviders = builtInParameterProviders;
    }

    protected void createJarFilesCache() {
        this.tempJarFiles = new RepositoryCacheMap(this.repository, this.repositoryContextManager, new TempJarFileCacheObject());
    }

    protected InputStream getFileResourceDataStream(ExecutionContext context, FileResource fileResource) {
        InputStream data;
        if (fileResource.hasData()) {
            data = fileResource.getDataStream();
        } else {
            FileResourceData resourceData = this.repository.getResourceData(context, fileResource.getURIString());
            data = resourceData.getDataStream();
        }
        return data;
    }

    protected RepositoryCacheMap.CacheObject getCacheJarFile(ExecutionContext context, FileResource jar, boolean cache) {
        return this.tempJarFiles.cache(context, jar, cache);
    }

    protected byte[] getFileResourceData(ExecutionContext context, FileResource fileResource) {
        byte[] data;
        if (fileResource.hasData()) {
            data = fileResource.getData();
        } else {
            FileResourceData resourceData = this.repository.getResourceData(context, fileResource.getURIString());
            data = resourceData.getData();
        }
        return data;
    }

    public DataSourceServiceFactory getDataSourceServiceFactories() {
        return this.dataSourceServiceFactories;
    }

    public void setDataSourceServiceFactories(DataSourceServiceFactory dataSourceServiceFactories) {
        this.dataSourceServiceFactories = dataSourceServiceFactories;
    }

    public Result execute(ExecutionContext context, Request request) {
        ReportUnitRequestBase reportUnitRequest = (ReportUnitRequestBase)request;
        return reportUnitRequest.execute(context, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToPdf(ExecutionContext context, String reportUnitURI, Map exportParameters) {
        ReportUnit reportUnit = (ReportUnit)this.getRepositoryResource(context, reportUnitURI);
        this.setThreadRepositoryContext(context, null, reportUnitURI);
        try {
            OrigContextClassLoader origContext = this.setContextClassLoader(context, reportUnit, false);
            try {
                exportParameters.put(JRExporterParameter.URL_HANDLER_FACTORY, RepositoryURLHandlerFactory.getInstance());
                JRPdfExporter exporter = new JRPdfExporter();
                exporter.setParameters(exportParameters);
                exporter.exportReport();
            }
            finally {
                this.revert(origContext);
            }
        }
        catch (JRException e) {
            log.error((Object)"Error while exporting report to PDF", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        finally {
            this.resetThreadRepositoryContext();
        }
    }

    protected void setThreadRepositoryContext(ExecutionContext context, ReportUnit reportUnit, String reportUnitURI) {
        context = EngineServiceImpl.getRuntimeExecutionContext(context);
        this.repositoryContextManager.setRepositoryContext(context, reportUnitURI, reportUnit);
    }

    protected void resetThreadRepositoryContext() {
        this.repositoryContextManager.resetRepositoryContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReportUnitResult fillReport(ExecutionContext context, ReportUnit reportUnit, Map parameters, boolean inMemoryUnit) {
        context = EngineServiceImpl.getRuntimeExecutionContext(context);
        this.setThreadRepositoryContext(context, reportUnit, reportUnit.getURIString());
        try {
            Map unitResources = this.loadFinalResources(context, reportUnit);
            OrigContextClassLoader origContext = this.setContextClassLoader(context, unitResources, inMemoryUnit);
            try {
                Query query;
                JasperReport report = this.getJasperReport(context, reportUnit, inMemoryUnit);
                Map reportParameters = this.getReportParameters(context, report, parameters);
                this.setReportTemplates(context, unitResources, reportParameters);
                ReportDataSource datasource = null;
                ResourceReference queryRef = reportUnit.getQuery();
                Query query2 = query = queryRef == null ? null : (Query)this.getFinalResource(context, queryRef);
                if (query != null && query.getDataSource() != null) {
                    datasource = (ReportDataSource)this.getFinalResource(context, query.getDataSource());
                }
                ResourceReference dsRef = reportUnit.getDataSource();
                if (datasource == null && dsRef != null) {
                    datasource = (ReportDataSource)this.getFinalResource(context, dsRef);
                }
                ReportUnitResult reportUnitResult = this.fillReport(context, reportUnit, report, reportParameters, datasource, query);
                this.revert(origContext);
                return reportUnitResult;
            }
            catch (Throwable throwable) {
                this.revert(origContext);
                throw throwable;
            }
        }
        finally {
            this.resetThreadRepositoryContext();
        }
    }

    protected Map getReportParameters(ExecutionContext context, JasperReport report, Map requestParameters) {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("REPORT_URL_HANDLER_FACTORY", RepositoryURLHandlerFactory.getInstance());
        if (context != null && context.getLocale() != null && reportParameters.get("REPORT_LOCALE") == null) {
            reportParameters.put("REPORT_LOCALE", context.getLocale());
        }
        if (context != null && context.getTimeZone() != null) {
            reportParameters.put("REPORT_TIME_ZONE", context.getTimeZone());
        }
        if (requestParameters != null) {
            reportParameters.putAll(requestParameters);
        }
        this.setBuiltinParameters(context, true, report.getParameters(), reportParameters, null);
        return reportParameters;
    }

    protected void setReportTemplates(ExecutionContext context, Map unitResources, Map reportParameters) {
        if (!reportParameters.containsKey("REPORT_TEMPLATES")) {
            ArrayList<JRTemplate> templates = new ArrayList<JRTemplate>();
            for (FileResource resource : unitResources.values()) {
                if (!resource.getFileType().equals("jrtx")) continue;
                JRTemplate template = this.loadTemplate(context, resource);
                templates.add(template);
            }
            reportParameters.put("REPORT_TEMPLATES", templates);
        }
    }

    protected JRTemplate loadTemplate(ExecutionContext context, FileResource resource) {
        InputStream templateDataStream = this.getFileResourceDataStream(context, resource);
        try {
            return JRXmlTemplateLoader.load((InputStream)templateDataStream);
        }
        catch (JRRuntimeException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected void revert(OrigContextClassLoader origContext) {
        if (origContext.set) {
            Thread.currentThread().setContextClassLoader(origContext.origClassLoader);
            for (RepositoryCacheMap.CacheObject cacheJarFile : origContext.jars) {
                if (cacheJarFile.isCached()) continue;
                JarFile jarFile = (JarFile)cacheJarFile.getObject();
                this.dispose(jarFile);
            }
        }
    }

    protected OrigContextClassLoader setContextClassLoader(ExecutionContext context, ReportUnit reportUnit, boolean inMemoryUnit) {
        Map unitResources = this.loadFinalResources(context, reportUnit);
        return this.setContextClassLoader(context, unitResources, inMemoryUnit);
    }

    protected Map loadFinalResources(ExecutionContext context, ReportUnit reportUnit) {
        List resources = reportUnit.getResources();
        LinkedHashMap<ResourceReference, FileResource> finalResources = new LinkedHashMap<ResourceReference, FileResource>();
        if (resources != null && !resources.isEmpty()) {
            for (ResourceReference resRef : resources) {
                FileResource resource = this.getFinalFileResource(context, resRef);
                finalResources.put(resRef, resource);
            }
        }
        return finalResources;
    }

    protected OrigContextClassLoader setContextClassLoader(ExecutionContext context, Map unitResources, boolean inMemoryUnit) {
        OrigContextClassLoader origContext;
        Map resourceBundleKeys;
        ClassLoader jarsClassLoader;
        Thread thread = Thread.currentThread();
        ClassLoader origClassLoader = thread.getContextClassLoader();
        ClassLoader newClassLoader = null;
        List jarFiles = this.getJarFiles(context, unitResources, !inMemoryUnit);
        if (jarFiles.isEmpty()) {
            jarsClassLoader = origClassLoader;
        } else {
            newClassLoader = jarsClassLoader = this.getJarsClassLoader(origClassLoader, jarFiles);
        }
        if (RepositoryUtil.hasThreadRepositoryContext() && !(resourceBundleKeys = this.getResourceBundleKeys(context, unitResources)).isEmpty()) {
            newClassLoader = this.getResourcesClassLoader(jarsClassLoader, resourceBundleKeys, inMemoryUnit);
        }
        if (newClassLoader == null) {
            origContext = OrigContextClassLoader.NOT_SET;
        } else {
            origContext = new OrigContextClassLoader(origClassLoader, jarFiles);
            thread.setContextClassLoader(newClassLoader);
        }
        return origContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader getJarsClassLoader(ClassLoader origClassLoader, List jarFiles) {
        ClassLoader classLoader;
        boolean caching;
        RepositoryCacheMap.CacheObject cacheJarFile;
        Iterator it = jarFiles.iterator();
        for (caching = true; caching && it.hasNext(); caching &= cacheJarFile.isCached()) {
            cacheJarFile = (RepositoryCacheMap.CacheObject)it.next();
        }
        if (caching) {
            Map childrenClassLoaders;
            ReferenceMap referenceMap = this.jarsClassLoaderCache;
            synchronized (referenceMap) {
                childrenClassLoaders = (Map)this.jarsClassLoaderCache.get((Object)origClassLoader);
                if (childrenClassLoaders == null) {
                    childrenClassLoaders = new ReferenceMap(0, 1);
                    this.jarsClassLoaderCache.put((Object)origClassLoader, (Object)childrenClassLoaders);
                }
            }
            Object classLoaderKey = this.getJarFileNames(jarFiles);
            Map map = childrenClassLoaders;
            synchronized (map) {
                classLoader = (ClassLoader)childrenClassLoaders.get(classLoaderKey);
                if (classLoader == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating class loader for parent " + origClassLoader + " and jars " + classLoaderKey));
                    }
                    classLoader = this.createJarsClassLoader(origClassLoader, jarFiles);
                    childrenClassLoaders.put(classLoaderKey, classLoader);
                }
            }
        }
        classLoader = this.createJarsClassLoader(origClassLoader, jarFiles);
        return classLoader;
    }

    protected ClassLoader createJarsClassLoader(ClassLoader origClassLoader, List jarFiles) {
        JarFile[] jars = new JarFile[jarFiles.size()];
        int i = 0;
        Iterator it = jarFiles.iterator();
        while (it.hasNext()) {
            jars[i] = (JarFile)((RepositoryCacheMap.CacheObject)it.next()).getObject();
            ++i;
        }
        return new JarsClassLoader(jars, origClassLoader, this.reportJarsProtectionDomainProvider.getProtectionDomain());
    }

    private Object getJarFileNames(List jarFiles) {
        ArrayList<String> jarFileNames = new ArrayList<String>(jarFiles.size());
        Iterator it = jarFiles.iterator();
        while (it.hasNext()) {
            JarFile jar = (JarFile)((RepositoryCacheMap.CacheObject)it.next()).getObject();
            jarFileNames.add(jar.getName());
        }
        return jarFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader getResourcesClassLoader(ClassLoader parent, Map resourceBundleKeys, boolean inMemoryUnit) {
        ClassLoader repositoryResourceClassLoader;
        if (inMemoryUnit) {
            repositoryResourceClassLoader = new RepositoryResourceClassLoader(parent, resourceBundleKeys, true);
        } else {
            Map childrenClassLoaders;
            Object object = this.resourcesClassLoaderCache;
            synchronized (object) {
                childrenClassLoaders = (Map)this.resourcesClassLoaderCache.get((Object)parent);
                if (childrenClassLoaders == null) {
                    childrenClassLoaders = new ReferenceMap(0, 1);
                    this.resourcesClassLoaderCache.put((Object)parent, (Object)childrenClassLoaders);
                }
            }
            object = childrenClassLoaders;
            synchronized (object) {
                repositoryResourceClassLoader = (ClassLoader)childrenClassLoaders.get(resourceBundleKeys);
                if (repositoryResourceClassLoader == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating class loader for parent " + parent + " and resources " + resourceBundleKeys));
                    }
                    repositoryResourceClassLoader = new RepositoryResourceClassLoader(parent, resourceBundleKeys, false);
                    childrenClassLoaders.put(resourceBundleKeys, repositoryResourceClassLoader);
                }
            }
        }
        return repositoryResourceClassLoader;
    }

    protected List getJarFiles(ExecutionContext context, Map unitResources, boolean cache) {
        ArrayList<RepositoryCacheMap.CacheObject> jarFiles = new ArrayList<RepositoryCacheMap.CacheObject>();
        for (FileResource resource : unitResources.values()) {
            if (!resource.getFileType().equals("jar")) continue;
            RepositoryCacheMap.CacheObject cacheJarFile = this.getCacheJarFile(context, resource, cache);
            jarFiles.add(cacheJarFile);
        }
        return jarFiles;
    }

    protected Map getResourceBundleKeys(ExecutionContext context, Map unitResources) {
        HashMap<String, RepositoryResourceKey> resourceBundleKeys = new HashMap<String, RepositoryResourceKey>();
        for (Map.Entry entry : unitResources.entrySet()) {
            ResourceReference resRef = (ResourceReference)entry.getKey();
            FileResource finalResource = (FileResource)entry.getValue();
            if (!finalResource.getFileType().equals("prop")) continue;
            String resName = resRef.isLocal() ? resRef.getLocalResource().getName() : finalResource.getName();
            String resPathKey = this.repositoryContextManager.getRepositoryPathKey(finalResource.getURIString());
            String uri = this.repositoryContextManager.getRepositoryUriForKey(resPathKey);
            RepositoryResourceKey resourceKey = new RepositoryResourceKey(resPathKey, uri, finalResource.getVersion(), finalResource.getCreationDate());
            resourceBundleKeys.put(resName, resourceKey);
        }
        return resourceBundleKeys;
    }

    protected JasperReport getJasperReport(ExecutionContext context, ReportUnit reportUnit, boolean inMemoryUnit) {
        FileResource reportRes = (FileResource)this.getFinalResource(context, reportUnit.getMainReport());
        try {
            JasperReport report;
            if (inMemoryUnit) {
                InputStream fileResourceData = this.getFileResourceDataStream(context, reportRes);
                report = this.compileReport(fileResourceData);
            } else {
                InputStream compiledReport = this.getCompiledReport(context, reportRes);
                try {
                    report = (JasperReport)JRLoader.loadObject((InputStream)compiledReport);
                }
                catch (JRException e) {
                    Throwable cause = e.getCause();
                    if (cause == null || !(cause instanceof InvalidClassException)) {
                        throw e;
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)"InvalidClassException caught while loading compiled report, clearing the compiled report cache");
                    }
                    this.clearCompiledReportCache();
                    compiledReport = this.getCompiledReport(context, reportRes);
                    report = (JasperReport)JRLoader.loadObject((InputStream)compiledReport);
                }
            }
            return report;
        }
        catch (JRException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected void clearCompiledReportCache() {
        this.compiledReportsCache.clearCache(this.cacheableCompiledReports);
    }

    protected void addReportUnitToAuditEvent(final ReportUnit reportUnit) {
        this.getAuditContext().doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                auditEvent.setResourceUri(reportUnit.getURI());
                EngineServiceImpl.this.auditContext.setResourceTypeToAuditEvent(reportUnit.getResourceType(), auditEvent);
                String uri = reportUnit.getDataSource() != null ? reportUnit.getDataSource().getReferenceURI() : "";
                EngineServiceImpl.this.getAuditContext().addPropertyToAuditEvent("dataSource", (Object)uri, auditEvent);
            }
        });
    }

    protected void addPropertyToAuditEvent(final String propertyType, final Object param) {
        this.getAuditContext().doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                EngineServiceImpl.this.getAuditContext().addPropertyToAuditEvent(propertyType, param, auditEvent);
            }
        });
    }

    protected ReportUnitResult fillReport(ExecutionContext context, ReportUnit reportUnit, JasperReport report, Map reportParameters, ReportDataSource datasource, Query query) {
        ReportDataSourceService dataSourceService = null;
        boolean dsClosing = false;
        this.addReportUnitToAuditEvent(reportUnit);
        try {
            if (datasource != null) {
                dataSourceService = this.createDataSourceService(datasource);
                dataSourceService.setReportParameterValues(reportParameters);
            }
            long renderingStartTime = System.currentTimeMillis();
            this.addPropertyToAuditEvent("reportRenderingStartTime", new Date(renderingStartTime));
            JasperPrint print = query == null ? this.fillReport(report, reportParameters, null) : this.fillQueryReport(context, report, reportParameters, query);
            this.addPropertyToAuditEvent("reportRenderingTime", System.currentTimeMillis() - renderingStartTime);
            dsClosing = true;
            if (dataSourceService != null) {
                dataSourceService.closeConnection();
                dataSourceService = null;
            }
            ReportUnitResult reportUnitResult = new ReportUnitResult(reportUnit.getURIString(), print, (JRVirtualizer)reportParameters.get("REPORT_VIRTUALIZER"));
            return reportUnitResult;
        }
        catch (JRException e) {
            log.error((Object)"Error while filling report", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        finally {
            if (!dsClosing && dataSourceService != null) {
                try {
                    dataSourceService.closeConnection();
                }
                catch (Exception e) {
                    log.error((Object)"Error while closing data source connection", (Throwable)e);
                }
            }
        }
    }

    protected JRDataSource createQueryDataSource(JRQueryExecuter queryExecuter) throws JRException {
        return queryExecuter.createDatasource();
    }

    protected JasperPrint fillReport(JasperReport report, Map parameters, JRDataSource dataSource) throws JRException {
        JasperPrint filled = dataSource == null ? JasperFillManager.fillReport((JasperReport)report, (Map)parameters) : JasperFillManager.fillReport((JasperReport)report, (Map)parameters, (JRDataSource)dataSource);
        return filled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JasperPrint fillQueryReport(ExecutionContext context, JasperReport report, Map reportParameters, Query query) throws JRException {
        JRQueryExecuter queryExecuter = JRQueryExecuterAdapter.createQueryExecuter(report, reportParameters, query);
        boolean closing = false;
        try {
            JRDataSource reportDatasource = this.createQueryDataSource(queryExecuter);
            JasperPrint printReport = this.fillReport(report, reportParameters, reportDatasource);
            closing = true;
            queryExecuter.close();
            JasperPrint jasperPrint = printReport;
            return jasperPrint;
        }
        finally {
            if (!closing) {
                queryExecuter.close();
            }
        }
    }

    public ReportDataSourceService createDataSourceService(ReportDataSource dataSource) {
        ReportDataSourceServiceFactory factory = (ReportDataSourceServiceFactory)this.getDataSourceServiceFactories().getBean(dataSource.getClass());
        return factory.createService(dataSource);
    }

    public Resource[] getResources(ResourceReference jrxmlReference) {
        FileResource jrxml = (FileResource)this.getFinalResource(null, jrxmlReference);
        return ResourceCollector.getResources(this.getFileResourceDataStream(null, jrxml));
    }

    protected Resource getRepositoryResource(ExecutionContext context, String uri) {
        return this.getRepositoryService().getResource(context, uri);
    }

    public ExecutionContext getRuntimeExecutionContext() {
        return EngineServiceImpl.getRuntimeExecutionContext(null);
    }

    public static ExecutionContext getRuntimeExecutionContext(ExecutionContext originalContext) {
        return ExecutionContextImpl.getRuntimeExecutionContext((ExecutionContext)originalContext);
    }

    public Resource getFinalResource(ExecutionContext context, ResourceReference res) {
        Resource finalRes = res.isLocal() ? res.getLocalResource() : this.getRepositoryResource(context, res.getReferenceURI());
        return finalRes;
    }

    protected FileResource getFinalFileResource(ExecutionContext context, ResourceReference resRef) {
        ExecutionContext runtimeContext = EngineServiceImpl.getRuntimeExecutionContext(context);
        FileResource res = (FileResource)this.getFinalResource(runtimeContext, resRef);
        while (res.isReference()) {
            res = (FileResource)this.getRepositoryResource(runtimeContext, res.getReferenceURI());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult validate(ExecutionContext context, ReportUnit reportUnit) {
        OrigContextClassLoader origContext = this.setContextClassLoader(context, reportUnit, true);
        ValidationResultImpl result = new ValidationResultImpl();
        try {
            List resources;
            ResourceReference mainReport = reportUnit.getMainReport();
            if (mainReport != null) {
                this.validateJRXML(context, result, mainReport);
            }
            if ((resources = reportUnit.getResources()) != null && !resources.isEmpty()) {
                for (ResourceReference resource : resources) {
                    this.validateJRXML(context, result, resource);
                }
            }
        }
        finally {
            this.revert(origContext);
        }
        return result;
    }

    protected void validateJRXML(ExecutionContext context, ValidationResultImpl result, ResourceReference resourceRef) {
        FileResource resource = this.getFinalFileResource(context, resourceRef);
        if (resource.getFileType().equals("jrxml")) {
            try {
                JasperCompileManager.compileReport((InputStream)this.getFileResourceDataStream(context, resource));
            }
            catch (JRException e) {
                ValidationDetailImpl detail = new ValidationDetailImpl();
                detail.setValidationClass(FileResource.class);
                detail.setName(resource.getName());
                detail.setLabel(resource.getLabel());
                detail.setResult("ERROR");
                detail.setException((Exception)((Object)e));
                detail.setMessage(e.getMessage());
                result.addValidationDetail((ValidationDetail)detail);
            }
        }
    }

    public ReportUnitResult executeReport(ExecutionContext context, String reportUnitURI, Map parameters) {
        ReportUnit reportUnit = (ReportUnit)this.getRepositoryResource(context, reportUnitURI);
        return this.fillReport(context, reportUnit, parameters, false);
    }

    public ReportUnitResult executeReport(ExecutionContext context, ReportUnit reportUnit, Map parameters) {
        return this.fillReport(context, reportUnit, parameters, true);
    }

    public InputStream getCompiledReport(ExecutionContext context, InputStream jrxmlData) {
        JasperReport report = this.compileReport(jrxmlData);
        byte[] reportBytes = this.reportBytes(report);
        return new ByteArrayInputStream(reportBytes);
    }

    protected JasperReport compileReport(InputStream jrxmlData) {
        try {
            JasperDesign design = JRXmlLoader.load((InputStream)jrxmlData);
            JasperReport report = JasperCompileManager.compileReport((JasperDesign)design);
            return report;
        }
        catch (JRException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected InputStream getCompiledReport(ExecutionContext context, FileResource jrxml) {
        return this.compiledReportsCache.cache(context, jrxml, this.cacheableCompiledReports);
    }

    protected byte[] reportBytes(JasperReport report) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JRSaver.saveObject((Object)report, (OutputStream)bout);
            byte[] reportBytes = bout.toByteArray();
            return reportBytes;
        }
        catch (JRException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    public InputStream getCompiledReport(ExecutionContext context, String jrxmlURI) {
        return this.compiledReportsCache.cache(context, jrxmlURI, this.cacheableCompiledReports);
    }

    private void addReportUnitTypeToAudit(final ReportUnit reportUnit) {
        this.auditContext.doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                if (reportUnit != null) {
                    if (auditEvent.getResourceType() == null) {
                        EngineServiceImpl.this.auditContext.setResourceTypeToAuditEvent(reportUnit.getResourceType(), auditEvent);
                    }
                    if (auditEvent.getResourceUri() == null) {
                        auditEvent.setResourceUri(reportUnit.getURI());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JasperReport getMainJasperReport(ExecutionContext context, String reportUnitURI) {
        ReportUnit reportUnit = (ReportUnit)this.getRepositoryResource(context, reportUnitURI);
        this.addReportUnitTypeToAudit(reportUnit);
        OrigContextClassLoader origContext = this.setContextClassLoader(context, reportUnit, false);
        try {
            JasperReport jasperReport;
            JasperReport jasperReport2 = jasperReport = this.getJasperReport(context, reportUnit, false);
            return jasperReport2;
        }
        finally {
            this.revert(origContext);
        }
    }

    public void release() {
        this.tempJarFiles.release();
    }

    protected void dispose(JarFile jarFile) {
        try {
            jarFile.close();
        }
        catch (IOException e) {
            log.warn((Object)("Unable to close jar file \"" + jarFile.getName() + "\""), (Throwable)e);
        }
        File file = new File(jarFile.getName());
        if (file.exists() && !file.delete()) {
            log.warn((Object)("Unable to delete jar file \"" + jarFile.getName() + "\""));
        }
    }

    public void clearCaches(Class resourceItf, String resourceURI) {
        if (FileResource.class.isAssignableFrom(resourceItf)) {
            this.compiledReportsCache.clearCache(resourceURI, this.cacheableCompiledReports);
            this.tempJarFiles.remove(resourceURI);
        }
    }

    public SecurityContextProvider getSecurityContextProvider() {
        return this.securityContextProvider;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public OrderedMap executeQuery(ExecutionContext context, ResourceReference queryReference, String keyColumn, String[] resultColumns, ResourceReference defaultDataSourceReference) {
        return this.executeQuery(context, queryReference, keyColumn, resultColumns, defaultDataSourceReference, null);
    }

    protected void addReportUnitToAuditEvent(final String dataSourceUri) {
        this.getAuditContext().doInAuditContext("inputControlsQuery", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                EngineServiceImpl.this.getAuditContext().addPropertyToAuditEvent("dataSource", (Object)dataSourceUri, auditEvent);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedMap executeQuery(ExecutionContext context, ResourceReference queryReference, String keyColumn, String[] resultColumns, ResourceReference defaultDataSourceReference, Map parameterValues) {
        Query query = (Query)this.getFinalResource(context = EngineServiceImpl.getRuntimeExecutionContext(context), queryReference);
        ResourceReference dataSourceReference = query.getDataSource();
        if (dataSourceReference == null) {
            dataSourceReference = defaultDataSourceReference;
        }
        this.addReportUnitToAuditEvent(query.getDataSource() != null ? query.getDataSource().getTargetURI() : null);
        if (dataSourceReference == null) {
            return null;
        }
        ReportDataSource dataSource = (ReportDataSource)this.getFinalResource(context, dataSourceReference);
        ReportDataSourceService dataSourceService = this.createDataSourceService(dataSource);
        boolean dsClosing = false;
        try {
            HashMap parameters = new HashMap();
            if (parameterValues != null) {
                parameters.putAll(parameterValues);
            }
            ArrayList additionalParameters = new ArrayList();
            this.setBuiltinParameters(context, false, null, parameters, additionalParameters);
            dataSourceService.setReportParameterValues(parameters);
            if (this.queryManipulator != null) {
                query.setSql(this.queryManipulator.updateQuery(query.getSql(), parameters));
            }
            long start = System.currentTimeMillis();
            OrderedMap result = JRQueryExecuterAdapter.executeQuery(query, keyColumn, resultColumns, parameters, additionalParameters);
            if (valueQueryLog.isDebugEnabled()) {
                valueQueryLog.debug((Object)("query took " + (System.currentTimeMillis() - start) + " ms: " + query.getSql()));
                valueQueryLog.debug((Object)("params: " + parameters));
            }
            dsClosing = true;
            if (dataSourceService != null) {
                dataSourceService.closeConnection();
                dataSourceService = null;
            }
            OrderedMap orderedMap = result;
            return orderedMap;
        }
        finally {
            if (!dsClosing && dataSourceService != null) {
                try {
                    dataSourceService.closeConnection();
                }
                catch (Exception e) {
                    log.error((Object)"Error while closing data source connection", (Throwable)e);
                }
            }
        }
    }

    public void setBuiltinParameters(ExecutionContext context, boolean onlyExistingParameters, JRParameter[] existingJRParameters, Map parametersMap, List additionalParameters) {
        for (Object o : this.getBuiltInParameterProviders()) {
            BuiltInParameterProvider pProvider = (BuiltInParameterProvider)o;
            List results = pProvider.getParameters(context, additionalParameters, parametersMap);
            for (Object[] aResult : results) {
                this.setBuiltInParameter(context, onlyExistingParameters, existingJRParameters, parametersMap, additionalParameters, aResult);
            }
            if (!onlyExistingParameters) continue;
            for (JRParameter jrParameter : existingJRParameters) {
                Object[] aResult;
                Object parameterMapValue = parametersMap.get(jrParameter.getName());
                if (parameterMapValue != null || (aResult = pProvider.getParameter(context, additionalParameters, parametersMap, jrParameter.getName())) == null) continue;
                this.setBuiltInParameter(context, onlyExistingParameters, existingJRParameters, parametersMap, additionalParameters, aResult);
            }
        }
    }

    public void setBuiltInParameter(ExecutionContext context, boolean onlyExistingParameters, JRParameter[] existingJRParameters, Map parametersMap, List additionalParameters, Object[] aResult) {
        JRParameter jrParameter = (JRParameter)aResult[0];
        Object aValue = aResult[1];
        boolean set = false;
        Object parameterFromMap = parametersMap.get(jrParameter.getName());
        JRParameter existingJRParameter = null;
        if (onlyExistingParameters) {
            for (JRParameter existingJRParameterFromArray : existingJRParameters) {
                if (!existingJRParameterFromArray.getName().equals(jrParameter.getName())) continue;
                existingJRParameter = existingJRParameterFromArray;
                break;
            }
        }
        if (onlyExistingParameters) {
            if (existingJRParameter != null) {
                if (existingJRParameter.getDefaultValueExpression() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Report parameter " + jrParameter.getName() + " has a default value expression, not setting value"));
                    }
                } else if (!existingJRParameter.getValueClass().isAssignableFrom(jrParameter.getValueClass())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Report parameter " + jrParameter.getName() + " type " + jrParameter.getValueClassName() + " not compatible with java.lang.String, not setting value"));
                    }
                } else {
                    set = true;
                }
            }
        } else if (parameterFromMap == null) {
            set = true;
        }
        if (set) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting report parameter " + jrParameter.getName() + " to " + aValue));
            }
            if (!onlyExistingParameters) {
                additionalParameters.add(jrParameter);
            }
            parametersMap.put(jrParameter.getName(), aValue);
        }
    }

    public ResourceLookup[] getDataSources(ExecutionContext context, String queryLanguage) {
        ResourceLookup[] datasources;
        if (queryLanguage == null) {
            datasources = this.repository.findResource(context, FilterCriteria.createFilter(ReportDataSource.class));
        } else {
            Set dataSourceTypes = this.dataSourceServiceFactories.getSupportingDataSourceTypes(queryLanguage);
            if (dataSourceTypes == null || dataSourceTypes.isEmpty()) {
                datasources = null;
            } else {
                FilterCriteria[] criteria = new FilterCriteria[dataSourceTypes.size()];
                int i = 0;
                for (Class type : dataSourceTypes) {
                    criteria[i] = FilterCriteria.createFilter((Class)type);
                    ++i;
                }
                datasources = this.repository.findResources(context, criteria);
            }
        }
        return datasources;
    }

    public String getQueryLanguage(ExecutionContext context, ResourceReference jrxmlResource) {
        JasperDesign jasperDesign = this.loadJRXML(context, jrxmlResource);
        JRQuery query = jasperDesign.getQuery();
        return query == null ? null : query.getLanguage();
    }

    protected JasperDesign loadJRXML(ExecutionContext context, ResourceReference jrxmlResource) {
        JasperDesign jasperDesign;
        FileResource jrxmlRes = this.getFinalFileResource(context, jrxmlResource);
        InputStream jrxmlData = this.getFileResourceDataStream(context, jrxmlRes);
        boolean close = true;
        try {
            jasperDesign = JRXmlLoader.load((InputStream)jrxmlData);
            close = false;
            jrxmlData.close();
        }
        catch (JRException e) {
            log.error((Object)"Error parsing JRXML", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (close) {
                try {
                    jrxmlData.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        return jasperDesign;
    }

    public Set getDataSourceTypes(ExecutionContext context, String queryLanguage) {
        return this.dataSourceServiceFactories.getSupportingDataSourceTypes(queryLanguage);
    }

    /*
     * Loose catch block
     */
    public Map getReportInputControlDefaultValues(ExecutionContext context, String reportURI, Map initialParameters) {
        ReportUnit reportUnit = (ReportUnit)this.getRepositoryResource(context, reportURI);
        List inputControls = reportUnit.getInputControls();
        if (inputControls == null || inputControls.isEmpty()) {
            return null;
        }
        this.setThreadRepositoryContext(context, reportUnit, reportUnit.getURIString());
        try {
            OrigContextClassLoader origContext = this.setContextClassLoader(context, reportUnit, false);
            try {
                JasperReport report = this.getJasperReport(context, reportUnit, false);
                initialParameters = this.getReportParameters(context, report, initialParameters);
                Map paramValues = JRParameterDefaultValuesEvaluator.evaluateParameterDefaultValues((JasperReport)report, (Map)initialParameters);
                HashMap inputValues = new HashMap();
                for (ResourceReference inputControlRef : inputControls) {
                    InputControl inputControl = (InputControl)this.getFinalResource(EngineServiceImpl.getRuntimeExecutionContext(context), inputControlRef);
                    Object value = paramValues.get(inputControl.getName());
                    inputValues.put(inputControl.getName(), value);
                }
                HashMap hashMap = inputValues;
                return hashMap;
            }
            catch (JRException e) {
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
            finally {
                this.revert(origContext);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resetThreadRepositoryContext();
        }
    }

    public ProtectionDomainProvider getReportJarsProtectionDomainProvider() {
        return this.reportJarsProtectionDomainProvider;
    }

    public void setReportJarsProtectionDomainProvider(ProtectionDomainProvider protectionDomainProvider) {
        this.reportJarsProtectionDomainProvider = protectionDomainProvider;
    }

    /*
     * Loose catch block
     */
    public ReportInputControlsInformation getReportInputControlsInformation(ExecutionContext context, String reportURI, Map initialParameters) {
        ReportUnit reportUnit = (ReportUnit)this.getRepositoryResource(context, reportURI);
        List inputControls = reportUnit.getInputControls();
        if (inputControls == null || inputControls.isEmpty()) {
            return null;
        }
        this.setThreadRepositoryContext(context, reportUnit, reportUnit.getURIString());
        try {
            OrigContextClassLoader origContext = this.setContextClassLoader(context, reportUnit, false);
            try {
                JasperReport report = this.getJasperReport(context, reportUnit, false);
                initialParameters = this.getReportParameters(context, report, initialParameters);
                HashMap<String, JRParameter> parametersMap = new HashMap<String, JRParameter>();
                JRParameter[] params = report.getParameters();
                for (int i = 0; i < params.length; ++i) {
                    parametersMap.put(params[i].getName(), params[i]);
                }
                ResourceBundle reportBundle = this.loadResourceBundle(context, report);
                Map paramValues = JRParameterDefaultValuesEvaluator.evaluateParameterDefaultValues((JasperReport)report, (Map)initialParameters);
                ReportInputControlsInformationImpl infos = new ReportInputControlsInformationImpl();
                for (ResourceReference inputControlRef : inputControls) {
                    InputControl inputControl = (InputControl)this.getFinalResource(EngineServiceImpl.getRuntimeExecutionContext(context), inputControlRef);
                    String name = inputControl.getName();
                    JRParameter param = (JRParameter)parametersMap.get(name);
                    if (param == null) continue;
                    JasperReportInputControlInformation info = new JasperReportInputControlInformation();
                    info.setReportParameter(param);
                    Object value = paramValues.get(name);
                    info.setDefaultValue(value);
                    String label = inputControl.getLabel();
                    if (reportBundle != null) {
                        String paramLabelKey = this.reportParameterLabelKeyPrefix + name;
                        try {
                            label = reportBundle.getString(paramLabelKey);
                        }
                        catch (MissingResourceException e) {
                            // empty catch block
                        }
                    }
                    info.setPromptLabel(label);
                    infos.setInputControlInformation(name, info);
                }
                ReportInputControlsInformationImpl reportInputControlsInformationImpl = infos;
                return reportInputControlsInformationImpl;
            }
            catch (JRException e) {
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
            finally {
                this.revert(origContext);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resetThreadRepositoryContext();
        }
    }

    protected ResourceBundle loadResourceBundle(ExecutionContext context, JasperReport report) {
        ResourceBundle bundle = null;
        String baseName = report.getResourceBundle();
        if (baseName != null) {
            Locale locale;
            Locale locale2 = locale = context == null ? null : context.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            bundle = JRResourcesUtil.loadResourceBundle((String)baseName, (Locale)locale);
        }
        return bundle;
    }

    public String getReportParameterLabelKeyPrefix() {
        return this.reportParameterLabelKeyPrefix;
    }

    public void setReportParameterLabelKeyPrefix(String reportParameterLabelKeyPrefix) {
        this.reportParameterLabelKeyPrefix = reportParameterLabelKeyPrefix;
    }

    public byte[] compileReport(ExecutionContext context, FileResource resource) {
        InputStream jrxmlData = this.getFileResourceDataStream(context, resource);
        JasperReport report = this.compileReport(jrxmlData);
        byte[] reportBytes = this.reportBytes(report);
        return reportBytes;
    }

    protected static class OrigContextClassLoader {
        public final boolean set;
        public final ClassLoader origClassLoader;
        public final List jars;
        public static final OrigContextClassLoader NOT_SET = new OrigContextClassLoader(false);

        private OrigContextClassLoader(boolean set) {
            this.set = set;
            this.origClassLoader = null;
            this.jars = null;
        }

        public OrigContextClassLoader(ClassLoader origClassLoader, List jars) {
            this.set = true;
            this.origClassLoader = origClassLoader;
            this.jars = jars;
        }
    }

    protected final class TempJarFileCacheObject
    implements RepositoryCacheMap.ObjectCache {
        protected TempJarFileCacheObject() {
        }

        public boolean isValid(Object o) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object create(ExecutionContext context, FileResource res) {
            try {
                File tempFile = File.createTempFile("report_jar", ".jar");
                tempFile.deleteOnExit();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Created temp jar file \"" + tempFile.getPath() + "\" for resource \"" + res.getURIString() + "\""));
                }
                byte[] data = EngineServiceImpl.this.getFileResourceData(context, res);
                BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(tempFile));
                try {
                    ((OutputStream)fileOut).write(data);
                    ((OutputStream)fileOut).flush();
                }
                finally {
                    ((OutputStream)fileOut).close();
                }
                JarFile jarFile = new JarFile(tempFile);
                return jarFile;
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                throw new JSExceptionWrapper((Exception)e);
            }
        }

        public void release(Object o) {
            EngineServiceImpl.this.dispose((JarFile)o);
        }
    }
}

