/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.BaseJdbcDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcDataSourceService
extends BaseJdbcDataSource {
    private static final Log log = LogFactory.getLog(JdbcDataSourceService.class);
    private final DataSource dataSource;
    private TimeZone timezone;

    public JdbcDataSourceService(DataSource dataSource, TimeZone timezone) {
        this.dataSource = dataSource;
        this.timezone = timezone;
    }

    protected Connection createConnection() {
        try {
            Connection c = this.dataSource.getConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)"CreateConnection successful at com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcDataSourceService.createConnection");
            }
            return c;
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error creating connection.", (Throwable)e);
            }
            throw new JSException("jsexception.error.creating.connection", (Throwable)e);
        }
    }

    public void setReportParameterValues(Map parameterValues) {
        super.setReportParameterValues(parameterValues);
        parameterValues.put("DATABASE_TIMEZONE", this.timezone);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

