/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.BuiltInParameterProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JRQueryExecuterAdapter;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserProfileBuiltInParameterProvider
implements BuiltInParameterProvider {
    public static final String LOGGED_IN_USER_PARAMETER_PREFIX = "LoggedInUser";
    public static final String LOGGED_IN_USER_NAME_PARAMETER = "LoggedInUsername";
    public static final String[] LOGGED_IN_USER_STANDARD_PARAMETERS = new String[]{"LoggedInUser", "LoggedInUsername"};

    public List<Object[]> getParameters(ExecutionContext context, List jrParameters, Map parameters) {
        ArrayList<Object[]> userProfileParameters = new ArrayList<Object[]>();
        for (String parameterName : LOGGED_IN_USER_STANDARD_PARAMETERS) {
            Object[] result = this.getParameter(context, jrParameters, parameters, parameterName);
            if (result == null) continue;
            userProfileParameters.add(result);
        }
        return userProfileParameters;
    }

    public Object[] getParameter(ExecutionContext context, List jrParameters, Map parameters, String name) {
        if (name == null || !name.toLowerCase().startsWith(LOGGED_IN_USER_PARAMETER_PREFIX.toLowerCase())) {
            return null;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (!(auth.getPrincipal() instanceof MetadataUserDetails)) {
            return null;
        }
        MetadataUserDetails userDetails = (MetadataUserDetails)auth.getPrincipal();
        if (name.equalsIgnoreCase(LOGGED_IN_USER_PARAMETER_PREFIX)) {
            MetadataUserDetails returnUserDetails = null;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(userDetails);
                out.flush();
                out.close();
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
                returnUserDetails = (MetadataUserDetails)in.readObject();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
                return null;
            }
            returnUserDetails.setPassword(null);
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, User.class), returnUserDetails};
        }
        String variableName = name.substring(LOGGED_IN_USER_PARAMETER_PREFIX.length());
        if (variableName.equalsIgnoreCase("name")) {
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, String.class), userDetails.getUsername() != null ? userDetails.getUsername() : ""};
        }
        if (variableName.equalsIgnoreCase("Fullname")) {
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, String.class), userDetails.getFullName() != null ? userDetails.getFullName() : ""};
        }
        if (variableName.equalsIgnoreCase("EmailAddress")) {
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, String.class), userDetails.getEmailAddress() != null ? userDetails.getEmailAddress() : ""};
        }
        if (variableName.equalsIgnoreCase("Enabled")) {
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, Boolean.class), userDetails.isEnabled()};
        }
        if (variableName.equalsIgnoreCase("ExternallyDefined")) {
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, Boolean.class), userDetails.isExternallyDefined()};
        }
        if (variableName.equalsIgnoreCase("TenantId")) {
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, String.class), userDetails.getTenantId() != null ? userDetails.getTenantId() : ""};
        }
        if (variableName.startsWith("Roles")) {
            ArrayList<String> roleNames = new ArrayList<String>(userDetails.getRoles().size());
            for (Object o : userDetails.getRoles()) {
                Role r = (Role)o;
                roleNames.add(r.getRoleName());
            }
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, Collection.class), roleNames};
        }
        if (variableName.equalsIgnoreCase("Attributes")) {
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, Collection.class), userDetails.getAttributes()};
        }
        if (variableName.equalsIgnoreCase("AttributeNames")) {
            ArrayList<String> keys = new ArrayList<String>(userDetails.getAttributes().size());
            for (Object o : userDetails.getAttributes()) {
                ProfileAttribute att = (ProfileAttribute)o;
                keys.add(att.getAttrName());
            }
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, Collection.class), keys};
        }
        if (variableName.equalsIgnoreCase("AttributeValues")) {
            ArrayList<String> values = new ArrayList<String>(userDetails.getAttributes().size());
            for (Object o : userDetails.getAttributes()) {
                ProfileAttribute att = (ProfileAttribute)o;
                values.add(att.getAttrValue());
            }
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, Collection.class), values};
        }
        if (variableName.startsWith("Attribute_")) {
            String attrName = variableName.substring("Attribute_".length());
            String result = "";
            for (Object o : userDetails.getAttributes()) {
                ProfileAttribute att = (ProfileAttribute)o;
                if (!att.getAttrName().equalsIgnoreCase(attrName)) continue;
                result = att.getAttrValue();
            }
            return new Object[]{JRQueryExecuterAdapter.makeParameter(name, String.class), result};
        }
        return null;
    }

    public String getLoggedInUserParameterPrefix() {
        return LOGGED_IN_USER_PARAMETER_PREFIX;
    }
}

