/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class QuartzSchedulerControl
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(QuartzSchedulerControl.class);
    private Scheduler scheduler;
    private ApplicationContext applicationContext;

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void start() {
        try {
            if (this.getScheduler().isInStandbyMode() && !this.applicationContext.containsBean("importCommandMetadata")) {
                this.getScheduler().start();
            } else if (!this.getScheduler().isInStandbyMode()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Scheduler already running.");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Scheduler can't be started in the scope of import-export tool.");
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Error starting the scheduler", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }
}

