/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.preauth;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.preauth.PreAuthenticatedAuthenticationToken;

public class PreAuthenticatedAuthenticationTokenTests
extends TestCase {
    public void testPreAuthenticatedAuthenticationTokenRequestWithDetails() {
        String principal = "dummyUser";
        String credentials = "dummyCredentials";
        String details = "dummyDetails";
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)principal, (Object)credentials);
        token.setDetails((Object)details);
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)principal, (Object)token.getPrincipal());
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)credentials, (Object)token.getCredentials());
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)details, (Object)token.getDetails());
        PreAuthenticatedAuthenticationTokenTests.assertNull((Object)token.getAuthorities());
    }

    public void testPreAuthenticatedAuthenticationTokenRequestWithoutDetails() {
        String principal = "dummyUser";
        String credentials = "dummyCredentials";
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)principal, (Object)credentials);
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)principal, (Object)token.getPrincipal());
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)credentials, (Object)token.getCredentials());
        PreAuthenticatedAuthenticationTokenTests.assertNull((Object)token.getDetails());
        PreAuthenticatedAuthenticationTokenTests.assertNull((Object)token.getAuthorities());
    }

    public void testPreAuthenticatedAuthenticationTokenResponse() {
        String principal = "dummyUser";
        String credentials = "dummyCredentials";
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("Role1")};
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)principal, (Object)credentials, gas);
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)principal, (Object)token.getPrincipal());
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)credentials, (Object)token.getCredentials());
        PreAuthenticatedAuthenticationTokenTests.assertNull((Object)token.getDetails());
        PreAuthenticatedAuthenticationTokenTests.assertNotNull((Object)token.getAuthorities());
        List<GrantedAuthority> expectedColl = Arrays.asList(gas);
        List<GrantedAuthority> resultColl = Arrays.asList(token.getAuthorities());
        PreAuthenticatedAuthenticationTokenTests.assertTrue((String)("GrantedAuthority collections do not match; result: " + resultColl + ", expected: " + expectedColl), (expectedColl.containsAll(resultColl) && resultColl.containsAll(expectedColl) ? 1 : 0) != 0);
    }
}

