/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.preauth;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.preauth.AbstractPreAuthenticatedProcessingFilter;

public class PreAuthenticatedProcessingFilterTests
extends TestCase {
    protected void setUp() throws Exception {
        SecurityContextHolder.clearContext();
    }

    public void testAfterPropertiesSet() {
        ConcretePreAuthenticatedProcessingFilter filter = new ConcretePreAuthenticatedProcessingFilter();
        try {
            filter.afterPropertiesSet();
            PreAuthenticatedProcessingFilterTests.fail((String)"AfterPropertiesSet didn't throw expected exception");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            PreAuthenticatedProcessingFilterTests.fail((String)"AfterPropertiesSet throws unexpected exception");
        }
    }

    public final void testDoFilterAuthenticated() throws Exception {
        this.testDoFilter(true);
    }

    public final void testDoFilterUnauthenticated() throws Exception {
        this.testDoFilter(false);
    }

    private final void testDoFilter(boolean grantAccess) throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        PreAuthenticatedProcessingFilterTests.getFilter(grantAccess).doFilter((ServletRequest)req, (ServletResponse)res, (FilterChain)new MockFilterChain());
        PreAuthenticatedProcessingFilterTests.assertEquals((boolean)grantAccess, (null != SecurityContextHolder.getContext().getAuthentication() ? 1 : 0) != 0);
    }

    private static final ConcretePreAuthenticatedProcessingFilter getFilter(boolean grantAccess) throws Exception {
        ConcretePreAuthenticatedProcessingFilter filter = new ConcretePreAuthenticatedProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(grantAccess));
        filter.afterPropertiesSet();
        return filter;
    }

    private static final class ConcretePreAuthenticatedProcessingFilter
    extends AbstractPreAuthenticatedProcessingFilter {
        private ConcretePreAuthenticatedProcessingFilter() {
        }

        protected Object getPreAuthenticatedPrincipal(HttpServletRequest httpRequest) {
            return "testPrincipal";
        }

        protected Object getPreAuthenticatedCredentials(HttpServletRequest httpRequest) {
            return "testCredentials";
        }

        public int getOrder() {
            return FilterChainOrder.PRE_AUTH_FILTER;
        }
    }
}

