/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.hierarchicalroles;

import junit.framework.TestCase;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.hierarchicalroles.HierarchicalRolesTestHelper;
import org.springframework.security.userdetails.hierarchicalroles.RoleHierarchy;
import org.springframework.security.userdetails.hierarchicalroles.RoleHierarchyImpl;
import org.springframework.security.userdetails.hierarchicalroles.UserDetailsWrapper;

public class UserDetailsWrapperTests
extends TestCase {
    private GrantedAuthority[] authorities = null;
    private UserDetails userDetails1 = null;
    private UserDetails userDetails2 = null;
    private UserDetailsWrapper userDetailsWrapper1 = null;
    private UserDetailsWrapper userDetailsWrapper2 = null;

    public UserDetailsWrapperTests() {
    }

    public UserDetailsWrapperTests(String testCaseName) {
        super(testCaseName);
    }

    protected void setUp() throws Exception {
        RoleHierarchyImpl roleHierarchy = new RoleHierarchyImpl();
        roleHierarchy.setHierarchy("ROLE_A > ROLE_B");
        this.authorities = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")};
        this.userDetails1 = new User("TestUser1", "TestPassword1", true, true, true, true, this.authorities);
        this.userDetails2 = new User("TestUser2", "TestPassword2", false, false, false, false, this.authorities);
        this.userDetailsWrapper1 = new UserDetailsWrapper(this.userDetails1, (RoleHierarchy)roleHierarchy);
        this.userDetailsWrapper2 = new UserDetailsWrapper(this.userDetails2, (RoleHierarchy)roleHierarchy);
    }

    public void testIsAccountNonExpired() {
        UserDetailsWrapperTests.assertEquals((boolean)this.userDetails1.isAccountNonExpired(), (boolean)this.userDetailsWrapper1.isAccountNonExpired());
        UserDetailsWrapperTests.assertEquals((boolean)this.userDetails2.isAccountNonExpired(), (boolean)this.userDetailsWrapper2.isAccountNonExpired());
    }

    public void testIsAccountNonLocked() {
        UserDetailsWrapperTests.assertEquals((boolean)this.userDetails1.isAccountNonLocked(), (boolean)this.userDetailsWrapper1.isAccountNonLocked());
        UserDetailsWrapperTests.assertEquals((boolean)this.userDetails2.isAccountNonLocked(), (boolean)this.userDetailsWrapper2.isAccountNonLocked());
    }

    public void testGetAuthorities() {
        GrantedAuthority[] expectedAuthorities = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_B")};
        UserDetailsWrapperTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(this.userDetailsWrapper1.getAuthorities(), expectedAuthorities));
        UserDetailsWrapperTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(this.userDetailsWrapper2.getAuthorities(), expectedAuthorities));
    }

    public void testIsCredentialsNonExpired() {
        UserDetailsWrapperTests.assertEquals((boolean)this.userDetails1.isCredentialsNonExpired(), (boolean)this.userDetailsWrapper1.isCredentialsNonExpired());
        UserDetailsWrapperTests.assertEquals((boolean)this.userDetails2.isCredentialsNonExpired(), (boolean)this.userDetailsWrapper2.isCredentialsNonExpired());
    }

    public void testIsEnabled() {
        UserDetailsWrapperTests.assertEquals((boolean)this.userDetails1.isEnabled(), (boolean)this.userDetailsWrapper1.isEnabled());
        UserDetailsWrapperTests.assertEquals((boolean)this.userDetails2.isEnabled(), (boolean)this.userDetailsWrapper2.isEnabled());
    }

    public void testGetPassword() {
        UserDetailsWrapperTests.assertEquals((String)this.userDetails1.getPassword(), (String)this.userDetailsWrapper1.getPassword());
        UserDetailsWrapperTests.assertEquals((String)this.userDetails2.getPassword(), (String)this.userDetailsWrapper2.getPassword());
    }

    public void testGetUsername() {
        UserDetailsWrapperTests.assertEquals((String)this.userDetails1.getUsername(), (String)this.userDetailsWrapper1.getUsername());
        UserDetailsWrapperTests.assertEquals((String)this.userDetails2.getUsername(), (String)this.userDetailsWrapper2.getUsername());
    }

    public void testGetUnwrappedUserDetails() {
        UserDetailsWrapperTests.assertTrue((this.userDetailsWrapper1.getUnwrappedUserDetails() == this.userDetails1 ? 1 : 0) != 0);
        UserDetailsWrapperTests.assertTrue((this.userDetailsWrapper2.getUnwrappedUserDetails() == this.userDetails2 ? 1 : 0) != 0);
    }
}

