/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.ldap;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ldap.AbstractLdapIntegrationTests;
import org.springframework.security.ldap.DefaultLdapUsernameToDnMapper;
import org.springframework.security.ldap.LdapUsernameToDnMapper;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.ldap.InetOrgPerson;
import org.springframework.security.userdetails.ldap.InetOrgPersonContextMapper;
import org.springframework.security.userdetails.ldap.LdapUserDetails;
import org.springframework.security.userdetails.ldap.LdapUserDetailsManager;
import org.springframework.security.userdetails.ldap.PersonContextMapper;
import org.springframework.security.userdetails.ldap.UserDetailsContextMapper;

public class LdapUserDetailsManagerTests
extends AbstractLdapIntegrationTests {
    private static final GrantedAuthority[] TEST_AUTHORITIES = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_CLOWNS"), new GrantedAuthorityImpl("ROLE_ACROBATS")};
    private LdapUserDetailsManager mgr;
    private SpringSecurityLdapTemplate template;

    public void onSetUp() throws Exception {
        super.onSetUp();
        this.mgr = new LdapUserDetailsManager((ContextSource)this.getContextSource());
        this.template = new SpringSecurityLdapTemplate((ContextSource)this.getContextSource());
        DirContextAdapter ctx = new DirContextAdapter();
        ctx.setAttributeValue("objectclass", (Object)"organizationalUnit");
        ctx.setAttributeValue("ou", (Object)"test people");
        this.template.bind("ou=test people", (Object)ctx, null);
        ctx.setAttributeValue("ou", (Object)"testgroups");
        this.template.bind("ou=testgroups", (Object)ctx, null);
        DirContextAdapter group = new DirContextAdapter();
        group.setAttributeValue("objectclass", (Object)"groupOfNames");
        group.setAttributeValue("cn", (Object)"clowns");
        group.setAttributeValue("member", (Object)"cn=nobody,ou=test people,dc=springframework,dc=org");
        this.template.bind("cn=clowns,ou=testgroups", (Object)group, null);
        group.setAttributeValue("cn", (Object)"acrobats");
        this.template.bind("cn=acrobats,ou=testgroups", (Object)group, null);
        this.mgr.setUsernameMapper((LdapUsernameToDnMapper)new DefaultLdapUsernameToDnMapper("ou=test people", "uid"));
        this.mgr.setGroupSearchBase("ou=testgroups");
        this.mgr.setGroupRoleAttributeName("cn");
        this.mgr.setGroupMemberAttributeName("member");
        this.mgr.setUserDetailsMapper((UserDetailsContextMapper)new PersonContextMapper());
    }

    @After
    public void onTearDown() throws Exception {
        this.template.unbind("ou=test people", true);
        this.template.unbind("ou=testgroups", true);
        SecurityContextHolder.clearContext();
    }

    @Test
    public void testLoadUserByUsernameReturnsCorrectData() {
        this.mgr.setUsernameMapper((LdapUsernameToDnMapper)new DefaultLdapUsernameToDnMapper("ou=people", "uid"));
        this.mgr.setGroupSearchBase("ou=groups");
        LdapUserDetails bob = (LdapUserDetails)this.mgr.loadUserByUsername("bob");
        Assert.assertEquals((Object)"bob", (Object)bob.getUsername());
        Assert.assertEquals((Object)"uid=bob, ou=people, dc=springframework, dc=org", (Object)bob.getDn());
        Assert.assertEquals((Object)"bobspassword", (Object)bob.getPassword());
        Assert.assertEquals((long)1L, (long)bob.getAuthorities().length);
    }

    @Test(expected=UsernameNotFoundException.class)
    public void testLoadingInvalidUsernameThrowsUsernameNotFoundException() {
        this.mgr.loadUserByUsername("jim");
    }

    @Test
    public void testUserExistsReturnsTrueForValidUser() {
        this.mgr.setUsernameMapper((LdapUsernameToDnMapper)new DefaultLdapUsernameToDnMapper("ou=people", "uid"));
        Assert.assertTrue((boolean)this.mgr.userExists("bob"));
    }

    @Test
    public void testUserExistsReturnsFalseForInValidUser() {
        Assert.assertFalse((boolean)this.mgr.userExists("jim"));
    }

    @Test
    public void testCreateNewUserSucceeds() {
        InetOrgPerson.Essence p = new InetOrgPerson.Essence();
        p.setCarLicense("XXX");
        p.setCn(new String[]{"Joe Smeth"});
        p.setDepartmentNumber("5679");
        p.setDescription("Some description");
        p.setDn("whocares");
        p.setEmployeeNumber("E781");
        p.setInitials("J");
        p.setMail("joe@smeth.com");
        p.setMobile("+44776542911");
        p.setOu("Joes Unit");
        p.setO("Organization");
        p.setRoomNumber("500X");
        p.setSn("Smeth");
        p.setUid("joe");
        p.setAuthorities(TEST_AUTHORITIES);
        this.mgr.createUser((UserDetails)p.createUserDetails());
    }

    @Test
    public void testDeleteUserSucceeds() {
        InetOrgPerson.Essence p = new InetOrgPerson.Essence();
        p.setDn("whocares");
        p.setCn(new String[]{"Don Smeth"});
        p.setSn("Smeth");
        p.setUid("don");
        p.setAuthorities(TEST_AUTHORITIES);
        this.mgr.createUser((UserDetails)p.createUserDetails());
        this.mgr.setUserDetailsMapper((UserDetailsContextMapper)new InetOrgPersonContextMapper());
        InetOrgPerson don = (InetOrgPerson)this.mgr.loadUserByUsername("don");
        Assert.assertEquals((long)2L, (long)don.getAuthorities().length);
        this.mgr.deleteUser("don");
        try {
            this.mgr.loadUserByUsername("don");
            Assert.fail((String)"Expected UsernameNotFoundException after deleting user");
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.mgr.getUserAuthorities(this.mgr.usernameMapper.buildDn("don"), "don").length);
    }

    @Test
    public void testPasswordChangeWithCorrectOldPasswordSucceeds() {
        InetOrgPerson.Essence p = new InetOrgPerson.Essence();
        p.setDn("whocares");
        p.setCn(new String[]{"John Yossarian"});
        p.setSn("Yossarian");
        p.setUid("johnyossarian");
        p.setPassword("yossarianspassword");
        p.setAuthorities(TEST_AUTHORITIES);
        this.mgr.createUser((UserDetails)p.createUserDetails());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)"johnyossarian", (Object)"yossarianspassword", TEST_AUTHORITIES));
        this.mgr.changePassword("yossarianspassword", "yossariansnewpassword");
        Assert.assertTrue((boolean)this.template.compare("uid=johnyossarian,ou=test people", "userPassword", (Object)"yossariansnewpassword"));
    }

    @Test(expected=BadCredentialsException.class)
    public void testPasswordChangeWithWrongOldPasswordFails() {
        InetOrgPerson.Essence p = new InetOrgPerson.Essence();
        p.setDn("whocares");
        p.setCn(new String[]{"John Yossarian"});
        p.setSn("Yossarian");
        p.setUid("johnyossarian");
        p.setPassword("yossarianspassword");
        p.setAuthorities(TEST_AUTHORITIES);
        this.mgr.createUser((UserDetails)p.createUserDetails());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)"johnyossarian", (Object)"yossarianspassword", TEST_AUTHORITIES));
        this.mgr.changePassword("wrongpassword", "yossariansnewpassword");
    }
}

