/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.memory;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.userdetails.memory.UserAttribute;
import org.springframework.security.userdetails.memory.UserAttributeEditor;

public class UserAttributeEditorTests
extends TestCase {
    public UserAttributeEditorTests() {
    }

    public UserAttributeEditorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(UserAttributeEditorTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCorrectOperationWithTrailingSpaces() {
        UserAttributeEditor editor = new UserAttributeEditor();
        editor.setAsText("password ,ROLE_ONE,ROLE_TWO ");
        UserAttribute user = (UserAttribute)editor.getValue();
        UserAttributeEditorTests.assertEquals((String)"password", (String)user.getPassword());
        UserAttributeEditorTests.assertEquals((int)2, (int)user.getAuthorities().length);
        UserAttributeEditorTests.assertEquals((String)"ROLE_ONE", (String)user.getAuthorities()[0].getAuthority());
        UserAttributeEditorTests.assertEquals((String)"ROLE_TWO", (String)user.getAuthorities()[1].getAuthority());
    }

    public void testCorrectOperationWithoutEnabledDisabledKeyword() {
        UserAttributeEditor editor = new UserAttributeEditor();
        editor.setAsText("password,ROLE_ONE,ROLE_TWO");
        UserAttribute user = (UserAttribute)editor.getValue();
        UserAttributeEditorTests.assertTrue((boolean)user.isValid());
        UserAttributeEditorTests.assertTrue((boolean)user.isEnabled());
        UserAttributeEditorTests.assertEquals((String)"password", (String)user.getPassword());
        UserAttributeEditorTests.assertEquals((int)2, (int)user.getAuthorities().length);
        UserAttributeEditorTests.assertEquals((String)"ROLE_ONE", (String)user.getAuthorities()[0].getAuthority());
        UserAttributeEditorTests.assertEquals((String)"ROLE_TWO", (String)user.getAuthorities()[1].getAuthority());
    }

    public void testDisabledKeyword() {
        UserAttributeEditor editor = new UserAttributeEditor();
        editor.setAsText("password,disabled,ROLE_ONE,ROLE_TWO");
        UserAttribute user = (UserAttribute)editor.getValue();
        UserAttributeEditorTests.assertTrue((boolean)user.isValid());
        UserAttributeEditorTests.assertTrue((!user.isEnabled() ? 1 : 0) != 0);
        UserAttributeEditorTests.assertEquals((String)"password", (String)user.getPassword());
        UserAttributeEditorTests.assertEquals((int)2, (int)user.getAuthorities().length);
        UserAttributeEditorTests.assertEquals((String)"ROLE_ONE", (String)user.getAuthorities()[0].getAuthority());
        UserAttributeEditorTests.assertEquals((String)"ROLE_TWO", (String)user.getAuthorities()[1].getAuthority());
    }

    public void testEmptyStringReturnsNull() {
        UserAttributeEditor editor = new UserAttributeEditor();
        editor.setAsText("");
        UserAttribute user = (UserAttribute)editor.getValue();
        UserAttributeEditorTests.assertTrue((user == null ? 1 : 0) != 0);
    }

    public void testEnabledKeyword() {
        UserAttributeEditor editor = new UserAttributeEditor();
        editor.setAsText("password,ROLE_ONE,enabled,ROLE_TWO");
        UserAttribute user = (UserAttribute)editor.getValue();
        UserAttributeEditorTests.assertTrue((boolean)user.isValid());
        UserAttributeEditorTests.assertTrue((boolean)user.isEnabled());
        UserAttributeEditorTests.assertEquals((String)"password", (String)user.getPassword());
        UserAttributeEditorTests.assertEquals((int)2, (int)user.getAuthorities().length);
        UserAttributeEditorTests.assertEquals((String)"ROLE_ONE", (String)user.getAuthorities()[0].getAuthority());
        UserAttributeEditorTests.assertEquals((String)"ROLE_TWO", (String)user.getAuthorities()[1].getAuthority());
    }

    public void testMalformedStringReturnsNull() {
        UserAttributeEditor editor = new UserAttributeEditor();
        editor.setAsText("MALFORMED_STRING");
        UserAttribute user = (UserAttribute)editor.getValue();
        UserAttributeEditorTests.assertTrue((user == null ? 1 : 0) != 0);
    }

    public void testNoPasswordOrRolesReturnsNull() {
        UserAttributeEditor editor = new UserAttributeEditor();
        editor.setAsText("disabled");
        UserAttribute user = (UserAttribute)editor.getValue();
        UserAttributeEditorTests.assertTrue((user == null ? 1 : 0) != 0);
    }

    public void testNoRolesReturnsNull() {
        UserAttributeEditor editor = new UserAttributeEditor();
        editor.setAsText("password,enabled");
        UserAttribute user = (UserAttribute)editor.getValue();
        UserAttributeEditorTests.assertTrue((user == null ? 1 : 0) != 0);
    }

    public void testNullReturnsNull() {
        UserAttributeEditor editor = new UserAttributeEditor();
        editor.setAsText(null);
        UserAttribute user = (UserAttribute)editor.getValue();
        UserAttributeEditorTests.assertTrue((user == null ? 1 : 0) != 0);
    }
}

