/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.util.HashMap;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.util.PortMapperImpl;

public class PortMapperImplTests
extends TestCase {
    public PortMapperImplTests() {
    }

    public PortMapperImplTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(PortMapperImplTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDefaultMappingsAreKnown() throws Exception {
        PortMapperImpl portMapper = new PortMapperImpl();
        PortMapperImplTests.assertEquals((Object)new Integer(80), (Object)portMapper.lookupHttpPort(new Integer(443)));
        PortMapperImplTests.assertEquals((Object)new Integer(8080), (Object)portMapper.lookupHttpPort(new Integer(8443)));
        PortMapperImplTests.assertEquals((Object)new Integer(443), (Object)portMapper.lookupHttpsPort(new Integer(80)));
        PortMapperImplTests.assertEquals((Object)new Integer(8443), (Object)portMapper.lookupHttpsPort(new Integer(8080)));
    }

    public void testDetectsEmptyMap() throws Exception {
        PortMapperImpl portMapper = new PortMapperImpl();
        try {
            portMapper.setPortMappings(new HashMap());
            PortMapperImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            PortMapperImplTests.assertTrue((boolean)true);
        }
    }

    public void testDetectsNullMap() throws Exception {
        PortMapperImpl portMapper = new PortMapperImpl();
        try {
            portMapper.setPortMappings(null);
            PortMapperImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            PortMapperImplTests.assertTrue((boolean)true);
        }
    }

    public void testGetTranslatedPortMappings() {
        PortMapperImpl portMapper = new PortMapperImpl();
        PortMapperImplTests.assertEquals((int)2, (int)portMapper.getTranslatedPortMappings().size());
    }

    public void testRejectsOutOfRangeMappings() {
        PortMapperImpl portMapper = new PortMapperImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("79", "80559");
        try {
            portMapper.setPortMappings(map);
            PortMapperImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            PortMapperImplTests.assertTrue((boolean)true);
        }
    }

    public void testReturnsNullIfHttpPortCannotBeFound() {
        PortMapperImpl portMapper = new PortMapperImpl();
        PortMapperImplTests.assertTrue((portMapper.lookupHttpPort(new Integer("34343")) == null ? 1 : 0) != 0);
    }

    public void testSupportsCustomMappings() {
        PortMapperImpl portMapper = new PortMapperImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("79", "442");
        portMapper.setPortMappings(map);
        PortMapperImplTests.assertEquals((Object)new Integer(79), (Object)portMapper.lookupHttpPort(new Integer(442)));
        PortMapperImplTests.assertEquals((Object)new Integer(442), (Object)portMapper.lookupHttpsPort(new Integer(79)));
    }
}

