/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import javax.servlet.ServletRequest;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.util.PortMapper;
import org.springframework.security.util.PortMapperImpl;
import org.springframework.security.util.PortResolverImpl;

public class PortResolverImplTests
extends TestCase {
    public PortResolverImplTests() {
    }

    public PortResolverImplTests(String arg0) {
        super(arg0);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsBuggyIeHttpRequest() throws Exception {
        PortResolverImpl pr = new PortResolverImpl();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServerPort(8443);
        request.setScheme("HTtP");
        PortResolverImplTests.assertEquals((int)8080, (int)pr.getServerPort((ServletRequest)request));
    }

    public void testDetectsBuggyIeHttpsRequest() throws Exception {
        PortResolverImpl pr = new PortResolverImpl();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServerPort(8080);
        request.setScheme("HTtPs");
        PortResolverImplTests.assertEquals((int)8443, (int)pr.getServerPort((ServletRequest)request));
    }

    public void testDetectsEmptyPortMapper() throws Exception {
        PortResolverImpl pr = new PortResolverImpl();
        try {
            pr.setPortMapper(null);
            PortResolverImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            PortResolverImplTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() throws Exception {
        PortResolverImpl pr = new PortResolverImpl();
        PortResolverImplTests.assertTrue((pr.getPortMapper() != null ? 1 : 0) != 0);
        pr.setPortMapper((PortMapper)new PortMapperImpl());
        PortResolverImplTests.assertTrue((pr.getPortMapper() != null ? 1 : 0) != 0);
    }

    public void testNormalOperation() throws Exception {
        PortResolverImpl pr = new PortResolverImpl();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        request.setServerPort(1021);
        PortResolverImplTests.assertEquals((int)1021, (int)pr.getServerPort((ServletRequest)request));
    }
}

