/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.docbook;

import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.maven.doxia.sink.SinkAdapter;
import org.apache.maven.doxia.sink.StructureSink;
import org.apache.maven.doxia.util.FileUtil;
import org.apache.maven.doxia.util.LineBreaker;

public class DocBookSink
extends SinkAdapter {
    public static final String DEFAULT_SGML_PUBLIC_ID = "-//OASIS//DTD DocBook V4.1//EN";
    public static final String DEFAULT_XML_PUBLIC_ID = "-//OASIS//DTD DocBook XML V4.1.2//EN";
    public static final String DEFAULT_XML_SYSTEM_ID = "http://www.oasis-open.org/docbook/xml/4.0/docbookx.dtd";
    private LineBreaker out;
    private boolean xmlMode = false;
    private String encoding = null;
    private String styleSheet = null;
    private String lang = null;
    private String publicId = null;
    private String systemId = null;
    private String italicBeginTag;
    private String italicEndTag;
    private String boldBeginTag;
    private String boldEndTag;
    private String monospacedBeginTag;
    private String monospacedEndTag;
    private String horizontalRuleElement;
    private String pageBreakElement;
    private String lineBreakElement;
    protected String graphicsFileName;
    private boolean hasTitle;
    private boolean authorDateFlag;
    private boolean verbatimFlag;
    private boolean externalLinkFlag;
    private boolean tableHasCaption;
    private LineBreaker savedOut;
    private String tableRows;
    private boolean tableHasGrid;

    public DocBookSink(Writer out) {
        this.out = new LineBreaker(out);
        this.setItalicElement("<emphasis>");
        this.setBoldElement("<emphasis role=\"bold\">");
        this.setMonospacedElement("<literal>");
        this.setHorizontalRuleElement("<!-- HR -->");
        this.setPageBreakElement("<!-- PB -->");
        this.setLineBreakElement("<!-- LB -->");
    }

    public static final String escapeSGML(String text, boolean xmlMode) {
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        block6: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block6;
                }
                default: {
                    if (xmlMode) {
                        buffer.append(c);
                        continue block6;
                    }
                    if (c <= '~') {
                        buffer.append(c);
                        continue block6;
                    }
                    buffer.append("&#");
                    buffer.append((int)c);
                    buffer.append(';');
                }
            }
        }
        return buffer.toString();
    }

    public void setXMLMode(boolean xmlMode) {
        this.xmlMode = xmlMode;
    }

    public boolean isXMLMode() {
        return this.xmlMode;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setStyleSheet(String styleSheet) {
        this.styleSheet = styleSheet;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setLanguage(String lang) {
        this.lang = lang;
    }

    public String getLanguage() {
        return this.lang;
    }

    public void setItalicElement(String italicBeginTag) {
        if (italicBeginTag == null) {
            italicBeginTag = "";
        }
        this.italicBeginTag = italicBeginTag;
        this.italicEndTag = this.makeEndTag(italicBeginTag);
    }

    private String makeEndTag(String beginTag) {
        int length = beginTag.length();
        if (length == 0) {
            return "";
        }
        if (beginTag.charAt(0) != '<' || beginTag.charAt(length - 1) != '>') {
            throw new IllegalArgumentException("'" + beginTag + "', not a tag");
        }
        StringTokenizer tokens = new StringTokenizer(beginTag, "<> \t\n\r\f");
        if (!tokens.hasMoreTokens()) {
            throw new IllegalArgumentException("'" + beginTag + "', invalid tag");
        }
        return "</" + tokens.nextToken() + ">";
    }

    public String getItalicElement() {
        return this.italicBeginTag;
    }

    public void setBoldElement(String boldBeginTag) {
        if (boldBeginTag == null) {
            boldBeginTag = "";
        }
        this.boldBeginTag = boldBeginTag;
        this.boldEndTag = this.makeEndTag(boldBeginTag);
    }

    public String getBoldElement() {
        return this.boldBeginTag;
    }

    public void setMonospacedElement(String monospacedBeginTag) {
        if (monospacedBeginTag == null) {
            monospacedBeginTag = "";
        }
        this.monospacedBeginTag = monospacedBeginTag;
        this.monospacedEndTag = this.makeEndTag(monospacedBeginTag);
    }

    public String getMonospacedElement() {
        return this.monospacedBeginTag;
    }

    public void setHorizontalRuleElement(String horizontalRuleElement) {
        this.horizontalRuleElement = horizontalRuleElement;
    }

    public String getHorizontalRuleElement() {
        return this.horizontalRuleElement;
    }

    public void setPageBreakElement(String pageBreakElement) {
        this.pageBreakElement = pageBreakElement;
    }

    public String getPageBreakElement() {
        return this.pageBreakElement;
    }

    public void setLineBreakElement(String lineBreakElement) {
        this.lineBreakElement = lineBreakElement;
    }

    public String getLineBreakElement() {
        return this.lineBreakElement;
    }

    private void resetState() {
        this.hasTitle = false;
        this.authorDateFlag = false;
        this.verbatimFlag = false;
        this.externalLinkFlag = false;
        this.graphicsFileName = null;
        this.tableHasCaption = false;
        this.savedOut = null;
        this.tableRows = null;
        this.tableHasGrid = false;
    }

    public void head() {
        this.resetState();
        if (this.xmlMode) {
            this.markup("<?xml version=\"1.0\"");
            if (this.encoding != null) {
                this.markup(" encoding=\"" + this.encoding + "\"");
            }
            this.markup(" ?>\n");
            if (this.styleSheet != null) {
                this.markup("<?xml-stylesheet type=\"text/css\"\nhref=\"" + this.styleSheet + "\" ?>\n");
            }
        }
        this.markup("<!DOCTYPE article PUBLIC");
        String pubId = this.publicId == null ? (this.xmlMode ? DEFAULT_XML_PUBLIC_ID : DEFAULT_SGML_PUBLIC_ID) : this.publicId;
        this.markup(" \"" + pubId + "\"");
        String sysId = this.systemId;
        if (sysId == null && this.xmlMode) {
            sysId = DEFAULT_XML_SYSTEM_ID;
        }
        if (sysId == null) {
            this.markup(">\n");
        } else {
            this.markup("\n\"" + sysId + "\">\n");
        }
        this.markup("<article");
        if (this.lang != null) {
            this.markup(" lang=\"" + this.lang + "\"");
        }
        this.markup(">\n");
    }

    public void head_() {
        if (this.hasTitle) {
            this.markup("</articleinfo>\n");
            this.hasTitle = false;
        }
    }

    public void title() {
        this.markup("<articleinfo>\n");
        this.hasTitle = true;
        this.markup("<title>");
    }

    public void title_() {
        this.markup("</title>\n");
    }

    public void author() {
        this.authorDateFlag = true;
        this.markup("<corpauthor>");
    }

    public void author_() {
        this.markup("</corpauthor>\n");
        this.authorDateFlag = false;
    }

    public void date() {
        this.authorDateFlag = true;
        this.markup("<date>");
    }

    public void date_() {
        this.markup("</date>\n");
        this.authorDateFlag = false;
    }

    public void body_() {
        this.markup("</article>\n");
        this.out.flush();
        this.resetState();
    }

    public void section1() {
        this.markup("<section>\n");
    }

    public void section1_() {
        this.markup("</section>\n");
    }

    public void section2() {
        this.markup("<section>\n");
    }

    public void section2_() {
        this.markup("</section>\n");
    }

    public void section3() {
        this.markup("<section>\n");
    }

    public void section3_() {
        this.markup("</section>\n");
    }

    public void section4() {
        this.markup("<section>\n");
    }

    public void section4_() {
        this.markup("</section>\n");
    }

    public void section5() {
        this.markup("<section>\n");
    }

    public void section5_() {
        this.markup("</section>\n");
    }

    public void sectionTitle() {
        this.markup("<title>");
    }

    public void sectionTitle_() {
        this.markup("</title>\n");
    }

    public void list() {
        this.markup("<itemizedlist>\n");
    }

    public void list_() {
        this.markup("</itemizedlist>\n");
    }

    public void listItem() {
        this.markup("<listitem>\n");
    }

    public void listItem_() {
        this.markup("</listitem>\n");
    }

    public void numberedList(int numbering) {
        String numeration;
        switch (numbering) {
            case 2: {
                numeration = "upperalpha";
                break;
            }
            case 1: {
                numeration = "loweralpha";
                break;
            }
            case 4: {
                numeration = "upperroman";
                break;
            }
            case 3: {
                numeration = "lowerroman";
                break;
            }
            default: {
                numeration = "arabic";
            }
        }
        this.markup("<orderedlist numeration=\"" + numeration + "\">\n");
    }

    public void numberedList_() {
        this.markup("</orderedlist>\n");
    }

    public void numberedListItem() {
        this.markup("<listitem>\n");
    }

    public void numberedListItem_() {
        this.markup("</listitem>\n");
    }

    public void definitionList() {
        this.markup("<variablelist>\n");
    }

    public void definitionList_() {
        this.markup("</variablelist>\n");
    }

    public void definitionListItem() {
        this.markup("<varlistentry>\n");
    }

    public void definitionListItem_() {
        this.markup("</varlistentry>\n");
    }

    public void definedTerm() {
        this.markup("<term>");
    }

    public void definedTerm_() {
        this.markup("</term>\n");
    }

    public void definition() {
        this.markup("<listitem>\n");
    }

    public void definition_() {
        this.markup("</listitem>\n");
    }

    public void paragraph() {
        this.markup("<para>");
    }

    public void paragraph_() {
        this.markup("</para>\n");
    }

    public void verbatim(boolean boxed) {
        this.verbatimFlag = true;
        this.markup("<programlisting>");
    }

    public void verbatim_() {
        this.markup("</programlisting>\n");
        this.verbatimFlag = false;
    }

    public void horizontalRule() {
        this.markup(this.horizontalRuleElement + '\n');
    }

    public void pageBreak() {
        this.markup(this.pageBreakElement + '\n');
    }

    public void figure_() {
        this.graphicElement();
    }

    protected void graphicElement() {
        if (this.graphicsFileName != null) {
            String format = FileUtil.fileExtension(this.graphicsFileName).toUpperCase();
            if (format.length() == 0) {
                format = "JPEG";
            }
            this.markup("<mediaobject>\n<imageobject>\n");
            this.markup("<imagedata format=\"" + format + "\"\nfileref=\"" + DocBookSink.escapeSGML(this.graphicsFileName, this.xmlMode) + '\"');
            if (this.xmlMode) {
                this.markup("/>\n");
            } else {
                this.markup(">\n");
            }
            this.markup("</imageobject>\n</mediaobject>\n");
            this.graphicsFileName = null;
        }
    }

    public void figureGraphics(String name) {
        this.graphicsFileName = name + ".jpeg";
    }

    public void figureCaption() {
        this.markup("<figure>\n");
        this.markup("<title>");
    }

    public void figureCaption_() {
        this.markup("</title>\n");
        this.graphicElement();
        this.markup("</figure>\n");
    }

    public void table() {
        this.tableHasCaption = false;
    }

    public void table_() {
        if (this.tableHasCaption) {
            this.tableHasCaption = false;
            this.out.write(this.tableRows, true);
            this.markup("</table>\n");
        } else {
            int sep;
            String frame;
            if (this.tableHasGrid) {
                frame = "all";
                sep = 1;
            } else {
                frame = "none";
                sep = 0;
            }
            this.markup("<informaltable frame=\"" + frame + "\" rowsep=\"" + sep + "\" colsep=\"" + sep + "\">\n");
            this.out.write(this.tableRows, true);
            this.markup("</informaltable>\n");
        }
        this.tableRows = null;
        this.tableHasGrid = false;
    }

    public void tableRows(int[] justification, boolean grid) {
        this.tableHasGrid = grid;
        this.out.flush();
        this.savedOut = this.out;
        this.out = new LineBreaker(new StringWriter());
        this.markup("<tgroup cols=\"" + justification.length + "\">\n");
        for (int i = 0; i < justification.length; ++i) {
            String justif;
            switch (justification[i]) {
                case 1: {
                    justif = "left";
                    break;
                }
                case 2: {
                    justif = "right";
                    break;
                }
                default: {
                    justif = "center";
                }
            }
            this.markup("<colspec align=\"" + justif + "\"");
            if (this.xmlMode) {
                this.markup("/>\n");
                continue;
            }
            this.markup(">\n");
        }
        this.markup("<tbody>\n");
    }

    public void tableRows_() {
        this.markup("</tbody>\n");
        this.markup("</tgroup>\n");
        this.out.flush();
        this.tableRows = ((StringWriter)this.out.getDestination()).toString();
        this.out = this.savedOut;
    }

    public void tableRow() {
        this.markup("<row>\n");
    }

    public void tableRow_() {
        this.markup("</row>\n");
    }

    public void tableCell() {
        this.markup("<entry><para>");
    }

    public void tableCell_() {
        this.markup("</para></entry>\n");
    }

    public void tableCaption() {
        int sep;
        String frame;
        this.tableHasCaption = true;
        if (this.tableHasGrid) {
            frame = "all";
            sep = 1;
        } else {
            frame = "none";
            sep = 0;
        }
        this.markup("<table frame=\"" + frame + "\" rowsep=\"" + sep + "\" colsep=\"" + sep + "\">\n");
        this.markup("<title>");
    }

    public void tableCaption_() {
        this.markup("</title>\n");
    }

    public void anchor(String name) {
        if (!this.authorDateFlag) {
            this.markup("<anchor id=\"a." + StructureSink.linkToKey(name) + "\"");
            if (this.xmlMode) {
                this.markup("/>");
            } else {
                this.markup(">");
            }
        }
    }

    public void link(String name) {
        if (StructureSink.isExternalLink(name)) {
            this.externalLinkFlag = true;
            this.markup("<ulink url=\"" + DocBookSink.escapeSGML(name, this.xmlMode) + "\">");
        } else {
            this.markup("<link linkend=\"a." + StructureSink.linkToKey(name) + "\">");
        }
    }

    public void link_() {
        if (this.externalLinkFlag) {
            this.markup("</ulink>");
            this.externalLinkFlag = false;
        } else {
            this.markup("</link>");
        }
    }

    public void italic() {
        this.markup(this.italicBeginTag);
    }

    public void italic_() {
        this.markup(this.italicEndTag);
    }

    public void bold() {
        this.markup(this.boldBeginTag);
    }

    public void bold_() {
        this.markup(this.boldEndTag);
    }

    public void monospaced() {
        if (!this.authorDateFlag) {
            this.markup(this.monospacedBeginTag);
        }
    }

    public void monospaced_() {
        if (!this.authorDateFlag) {
            this.markup(this.monospacedEndTag);
        }
    }

    public void lineBreak() {
        this.markup(this.lineBreakElement + '\n');
    }

    public void nonBreakingSpace() {
        this.markup("&nbsp;");
    }

    public void text(String text) {
        if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    protected void markup(String text) {
        this.out.write(text, true);
    }

    protected void content(String text) {
        this.out.write(DocBookSink.escapeSGML(text, this.xmlMode), false);
    }

    protected void verbatimContent(String text) {
        this.out.write(DocBookSink.escapeSGML(text, this.xmlMode), true);
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }
}

