/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.export.modules.BaseImporterModule;
import com.jaspersoft.jasperserver.export.modules.ImporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.common.TenantQualifiedName;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceBeanDataNotFoundException;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.repository.beans.FolderBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.PermissionRecipient;
import com.jaspersoft.jasperserver.export.modules.repository.beans.RepositoryObjectPermissionBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceReferenceBean;
import com.jaspersoft.jasperserver.export.util.PathUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;

public class ResourceImporter
extends BaseImporterModule
implements ResourceImportHandler,
InitializingBean {
    public static final String ATTRIBUTE_UPDATE_RESOURCES = "updateResources";
    private static final Log log = LogFactory.getLog(ResourceImporter.class);
    private ResourceModuleConfiguration configuration;
    private TenantService tenantService;
    private String prependPathArg;
    private String updateArg;
    private List<String> rootSubTenantFolderUris;
    private Pattern orgPattern = Pattern.compile("((/organizations/[^/]+)*)");
    protected RepositoryService repository;
    protected String prependPath;
    private boolean update;
    protected Set importedURIs;
    private LinkedList folderQueue;
    private LinkedList resourceQueue;
    private Map roles;
    private Map users;

    public void afterPropertiesSet() {
        this.repository = this.configuration.getRepository();
    }

    public void init(ImporterModuleContext moduleContext) {
        super.init(moduleContext);
        this.configuration.setApplicationContext((ApplicationContext)moduleContext.getAttributes().getAttribute("appContext"));
        this.prependPath = this.getPrependPath();
        this.update = this.getUpdateFlag();
        List allRootSubTenantList = this.tenantService.getAllSubTenantList(this.executionContext, "organizations");
        this.rootSubTenantFolderUris = new ArrayList<String>();
        for (Tenant tenant : allRootSubTenantList) {
            this.rootSubTenantFolderUris.add(tenant.getTenantFolderUri());
        }
    }

    protected String getPrependPath() {
        String path = this.getParameterValue(this.getPrependPathArg());
        if (path != null) {
            if ((path = PathUtils.normalizePath(path)).length() == 0 || path.equals("/")) {
                path = null;
            } else if (!path.startsWith("/")) {
                path = "/" + path;
            }
        }
        return path;
    }

    protected boolean getUpdateFlag() {
        return this.hasParameter(this.getUpdateArg());
    }

    protected boolean isUpdate() {
        return this.update;
    }

    public void process() {
        this.initProcess();
        this.createPrependFolder();
        this.queueEntryFolders();
        this.queueEntryResources();
        while (!this.folderQueue.isEmpty() || !this.resourceQueue.isEmpty()) {
            String uri;
            if (this.folderQueue.isEmpty()) {
                uri = (String)this.resourceQueue.removeFirst();
                try {
                    this.importResource(uri, false);
                }
                catch (ResourceBeanDataNotFoundException e) {
                    String msg = uri.equals(e.getMessage()) ? "Reference resource \"" + e.getMessage() + "\" not found." : "Reference resource \"" + e.getMessage() + "\" not found when importing resource \"" + uri + "\".";
                    commandOut.warn(msg);
                    this.fileBrokenResource(msg);
                }
                continue;
            }
            uri = (String)this.folderQueue.removeFirst();
            this.importFolder(uri, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileBrokenResource(String message) {
        File file = new File("import-errors.log");
        Writer out = null;
        try {
            out = new BufferedWriter(new FileWriter(file, true));
            out.write(message);
            out.write(10);
        }
        catch (IOException e) {
            commandOut.error("Error writing to import.log", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e1) {}
            }
        }
    }

    protected void queueEntryFolders() {
        ArrayList<String> entryFolders = new ArrayList<String>();
        Iterator it = this.indexElement.elementIterator(this.configuration.getFolderIndexElement());
        while (it.hasNext()) {
            Element folderElement = (Element)it.next();
            entryFolders.add(folderElement.getText());
        }
        if (!entryFolders.isEmpty()) {
            Collections.sort(entryFolders);
            for (String uri : entryFolders) {
                this.folderQueue.addLast(uri);
            }
        }
    }

    protected void queueEntryResources() {
        Iterator it = this.indexElement.elementIterator(this.configuration.getResourceIndexElement());
        while (it.hasNext()) {
            Element resourceElement = (Element)it.next();
            String uri = resourceElement.getText();
            this.resourceQueue.addLast(uri);
        }
    }

    protected void createPrependFolder() {
        if (this.prependPath != null) {
            LinkedList<String> toCreateURIs = new LinkedList<String>();
            String path = this.prependPath;
            while (this.repository.getFolder(this.executionContext, path) == null) {
                toCreateURIs.addFirst(path);
                path = PathUtils.splitPath((String)path).parentPath;
            }
            while (!toCreateURIs.isEmpty()) {
                path = (String)toCreateURIs.removeFirst();
                Folder folder = this.createFolder(path);
                commandOut.debug("About to save folder " + path);
                this.repository.saveFolder(this.executionContext, folder);
            }
        }
    }

    protected void initProcess() {
        this.importedURIs = new HashSet();
        this.folderQueue = new LinkedList();
        this.resourceQueue = new LinkedList();
        this.roles = new HashMap();
        this.users = new HashMap();
    }

    protected void importFolder(String uri, boolean detailsRequired) {
        if (this.importedURIs.contains(uri)) {
            return;
        }
        String tenantFolderUri = "";
        int orgTeplateIndex = uri.indexOf("/organizations/org_template");
        if (orgTeplateIndex >= 0) {
            tenantFolderUri = uri.substring(0, orgTeplateIndex);
        } else {
            Matcher m = this.orgPattern.matcher(uri);
            if (m.find()) {
                tenantFolderUri = m.group(1);
            }
        }
        if (!this.rootSubTenantFolderUris.contains(tenantFolderUri) && !tenantFolderUri.equals("")) {
            commandOut.info("Folder with the uri" + uri + " is attached to not existing organization. Not imported");
            return;
        }
        FolderBean folderBean = this.getFolderDetails(uri, detailsRequired);
        String importUri = this.prependedPath(uri);
        Folder folder = this.repository.getFolder(this.executionContext, importUri);
        if (folder == null) {
            this.ensureParent(uri);
            folder = folderBean == null ? this.createFolder(importUri) : this.createFolder(folderBean);
            if (this.executionContext.getAttributes() == null) {
                this.executionContext.setAttributes(new ArrayList());
            }
            this.executionContext.getAttributes().add("isImporting");
            commandOut.debug("About to save folder " + importUri);
            this.repository.saveFolder(this.executionContext, folder);
            if (folderBean != null) {
                this.setPermissions((InternalURI)folder, folderBean.getPermissions(), false);
            }
            commandOut.info("Created repository folder " + importUri);
        } else if (this.update && folderBean != null) {
            folder.setLabel(folderBean.getLabel());
            folder.setDescription(folderBean.getDescription());
            commandOut.debug("About to save folder " + importUri);
            this.repository.saveFolder(this.executionContext, folder);
            commandOut.info("Updating folder " + importUri);
            ObjectPermissionService permissionsService = this.configuration.getPermissionService();
            permissionsService.deleteObjectPermissionForObject(this.executionContext, (Object)folder);
            this.setPermissions((InternalURI)folder, folderBean.getPermissions(), false);
        } else if (folderBean != null) {
            commandOut.info("Folder " + importUri + " already exists, importing permissions only");
            this.setPermissions((InternalURI)folder, folderBean.getPermissions(), true);
        }
        this.importedURIs.add(uri);
        if (folderBean != null) {
            this.queueSubFolders(uri, folderBean);
            this.queueResources(uri, folderBean);
        }
    }

    protected void queueSubFolders(String uri, FolderBean folderBean) {
        String[] subFolders = folderBean.getSubFolders();
        if (subFolders != null) {
            for (int i = 0; i < subFolders.length; ++i) {
                String subfolderURI = this.appendPath(uri, subFolders[i]);
                this.folderQueue.addLast(subfolderURI);
            }
        }
    }

    protected void queueResources(String uri, FolderBean folderBean) {
        String[] resources = folderBean.getResources();
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                String resourceUri = this.appendPath(uri, resources[i]);
                this.resourceQueue.addLast(resourceUri);
            }
        }
    }

    protected String prependedPath(String uri) {
        return PathUtils.concatPaths(this.prependPath, uri);
    }

    protected String appendPath(String uri, String name) {
        String subUri = uri.equals("/") ? "/" + name : uri + "/" + name;
        return subUri;
    }

    protected FolderBean getFolderDetails(String uri, boolean required) {
        FolderBean folderBean = null;
        String folderPath = PathUtils.concatPaths(this.configuration.getResourcesDirName(), uri);
        if (this.input.fileExists(folderPath, this.configuration.getFolderDetailsFileName())) {
            folderBean = (FolderBean)this.deserialize(folderPath, this.configuration.getFolderDetailsFileName(), this.configuration.getSerializer());
        } else if (required) {
            StringBuilder message = new StringBuilder("Folder details for folder ");
            message.append(uri);
            message.append(" were not found in the import information.");
            commandOut.info(message.toString());
            throw new JSException(message.toString());
        }
        return folderBean;
    }

    protected void ensureParent(String uri) {
        PathUtils.SplittedPath splitPath = PathUtils.splitPath(uri);
        if (splitPath != null && splitPath.parentPath != null) {
            this.importFolder(splitPath.parentPath, false);
        }
    }

    protected Folder createFolder(String uri) {
        FolderImpl folder = new FolderImpl();
        PathUtils.SplittedPath splPath = PathUtils.splitPath(uri);
        folder.setParentFolder(splPath.parentPath);
        folder.setName(splPath.name);
        folder.setLabel(splPath.name);
        return folder;
    }

    protected Folder createFolder(FolderBean folderBean) {
        FolderImpl folder = new FolderImpl();
        folderBean.copyTo((Folder)folder);
        folder.setCreationDate(folderBean.getCreationDate());
        folder.setUpdateDate(folderBean.getUpdateDate());
        folder.setParentFolder(this.prependedPath(folder.getParentFolder()));
        return folder;
    }

    protected String importResource(String uri, boolean ignoreMissing) {
        String importUri = this.prependedPath(uri);
        if (!this.importedURIs.contains(uri)) {
            if (ignoreMissing && !this.hasResourceBeanData(uri)) {
                commandOut.info("Resource " + uri + " data missing from the catalog, skipping from import");
            } else {
                if (!this.hasResourceBeanData(uri)) {
                    throw new ResourceBeanDataNotFoundException(uri);
                }
                Resource resource = this.repository.getResource(this.executionContext, importUri);
                if (resource == null) {
                    this.ensureParent(uri);
                    ResourceBean bean = this.readResourceBean(uri);
                    resource = this.createResource(bean);
                    if (this.executionContext.getAttributes() == null) {
                        this.executionContext.setAttributes(new ArrayList());
                    }
                    this.executionContext.getAttributes().add("isImporting");
                    commandOut.debug("About to save resource " + importUri);
                    this.repository.saveResource(this.executionContext, resource);
                    this.setPermissions((InternalURI)resource, bean.getPermissions(), false);
                    commandOut.info("Imported resource " + importUri);
                } else if (this.update) {
                    this.registerUpdateResource(importUri);
                    ResourceBean bean = this.readResourceBean(uri);
                    Resource updated = this.createResource(bean);
                    if (resource.isSameType(updated)) {
                        updated.setVersion(resource.getVersion());
                        commandOut.debug("About to save resource " + importUri);
                        this.repository.saveResource(this.executionContext, updated);
                        commandOut.info("Updated resource " + importUri);
                    } else {
                        commandOut.warn("Resource " + importUri + " already exists in the repository and has a different type than in the catalog, not updating");
                    }
                } else {
                    commandOut.warn("Resource " + importUri + " already exists, not importing");
                }
                this.importedURIs.add(uri);
            }
        }
        return importUri;
    }

    protected void registerUpdateResource(String resourceUri) {
        HashSet<String> updateResources = (HashSet<String>)this.getContextAttributes().getAttribute(ATTRIBUTE_UPDATE_RESOURCES);
        if (updateResources == null) {
            updateResources = new HashSet<String>();
            this.getContextAttributes().setAttribute(ATTRIBUTE_UPDATE_RESOURCES, updateResources);
        }
        updateResources.add(resourceUri);
    }

    protected Resource createResource(ResourceBean bean) {
        Class resourceItf = this.configuration.getCastorBeanMappings().getInterface(bean.getClass());
        Resource resource = this.repository.newResource(this.executionContext, resourceItf);
        bean.copyTo(resource, this);
        resource.setParentFolder(this.prependedPath(resource.getParentFolder()));
        return resource;
    }

    protected boolean hasResourceBeanData(String uri) {
        String resourceFileName = this.getResourceFileName(uri);
        return this.input.fileExists(this.configuration.getResourcesDirName(), resourceFileName);
    }

    protected ResourceBean readResourceBean(String uri) {
        String resourceFileName = this.getResourceFileName(uri);
        ResourceBean bean = (ResourceBean)this.deserialize(this.configuration.getResourcesDirName(), resourceFileName, this.configuration.getSerializer());
        return bean;
    }

    protected String getResourceFileName(String uri) {
        return uri + ".xml";
    }

    public String getSourceJsVersion() {
        return super.getSourceJsVersion();
    }

    public String getTargetJsVersion() {
        return super.getTargetJsVersion();
    }

    public ResourceReference handleReference(ResourceReferenceBean beanReference) {
        ResourceReference reference;
        if (beanReference == null) {
            reference = null;
        } else if (beanReference.isLocal()) {
            ResourceBean localResBean = beanReference.getLocalResource();
            Resource localRes = this.createResource(localResBean);
            reference = new ResourceReference(localRes);
        } else {
            String referenceURI = beanReference.getExternalURI();
            if (referenceURI == null || referenceURI.equals("")) {
                return null;
            }
            this.importResource(referenceURI, false);
            reference = new ResourceReference(this.prependedPath(referenceURI));
        }
        return reference;
    }

    public byte[] handleData(ResourceBean resourceBean, String dataFile, String providerId) {
        String filename = PathUtils.concatPaths(resourceBean.getFolder(), dataFile);
        InputStream dataInput = this.getFileInput(this.configuration.getResourcesDirName(), filename);
        boolean closeInput = true;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataContainerStreamUtil.pipeData((InputStream)dataInput, (OutputStream)out);
            closeInput = false;
            dataInput.close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (closeInput) {
                try {
                    dataInput.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public Resource handleResource(ResourceBean resource) {
        Resource res = this.createResource(resource);
        return res;
    }

    public String handleResource(String uri) {
        return this.handleResource(uri, false);
    }

    public String handleResource(String uri, boolean ignoreMissing) {
        return this.importResource(uri, ignoreMissing);
    }

    protected void setPermissions(InternalURI object, RepositoryObjectPermissionBean[] permissions, boolean checkExisting) {
        if (permissions != null) {
            for (int i = 0; i < permissions.length; ++i) {
                RepositoryObjectPermissionBean permissionBean = permissions[i];
                this.setPermission(object, permissionBean, checkExisting);
            }
        }
    }

    protected void setPermission(InternalURI object, RepositoryObjectPermissionBean permissionBean, boolean checkExisting) {
        Role recipient;
        ObjectPermissionService permissionsService = this.configuration.getPermissionService();
        PermissionRecipient permissionRecipient = permissionBean.getRecipient();
        String recipientType = permissionRecipient.getRecipientType();
        if (recipientType.equals(this.configuration.getPermissionRecipientRole())) {
            recipient = this.getRole(permissionRecipient);
            if (recipient == null) {
                commandOut.warn("Role " + permissionRecipient + " not found, skipping permission of " + object.getURI());
            }
        } else if (recipientType.equals(this.configuration.getPermissionRecipientUser())) {
            recipient = this.getUser(permissionRecipient);
            if (recipient == null) {
                commandOut.warn("User " + permissionRecipient + " not found, skipping permission of " + object.getURI());
            }
        } else {
            recipient = null;
            commandOut.warn("Unknown object permission recipient type " + recipientType + ", skipping permission of " + object.getURI());
        }
        if (recipient != null) {
            List permissions;
            boolean existing = checkExisting ? (permissions = permissionsService.getObjectPermissionsForObjectAndRecipient(this.executionContext, (Object)object, (Object)recipient)) != null && !permissions.isEmpty() : false;
            if (existing) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Permission on " + object.getURI() + " for " + permissionRecipient + " already exists, skipping."));
                }
            } else {
                ObjectPermission permission = permissionsService.newObjectPermission(this.executionContext);
                permission.setURI(object.getURI());
                permission.setPermissionMask(permissionBean.getPermissionMask());
                permission.setPermissionRecipient((Object)recipient);
                permissionsService.putObjectPermission(this.executionContext, permission);
            }
        }
    }

    protected Role getRole(TenantQualifiedName roleName) {
        Role role;
        if (this.roles.containsKey(roleName)) {
            role = (Role)this.roles.get(roleName);
        } else {
            role = this.loadRole(roleName);
            this.roles.put(roleName, role);
        }
        return role;
    }

    protected Role loadRole(TenantQualifiedName roleName) {
        return this.configuration.getAuthorityService().getRole(this.executionContext, roleName.getName());
    }

    protected User getUser(TenantQualifiedName username) {
        User user;
        if (this.users.containsKey(username)) {
            user = (User)this.users.get(username);
        } else {
            user = this.loadUser(username);
            this.users.put(username, user);
        }
        return user;
    }

    protected User loadUser(TenantQualifiedName username) {
        return this.configuration.getAuthorityService().getUser(this.executionContext, username.getName());
    }

    public ResourceModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ResourceModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public String getPrependPathArg() {
        return this.prependPathArg;
    }

    public void setPrependPathArg(String prependPathArg) {
        this.prependPathArg = prependPathArg;
    }

    public String getUpdateArg() {
        return this.updateArg;
    }

    public void setUpdateArg(String updateArg) {
        this.updateArg = updateArg;
    }
}

