/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling.beans;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.export.modules.common.ReportParameterValueBean;
import com.jaspersoft.jasperserver.export.modules.scheduling.SchedulingModuleConfiguration;
import java.util.Map;

public class ReportJobSourceBean {
    private String reportUnitURI;
    private ReportParameterValueBean[] parameters;

    public void copyFrom(ReportJobSource src, SchedulingModuleConfiguration configuration) {
        this.setReportUnitURI(src.getReportUnitURI());
        this.copyParametersFrom(src, configuration);
    }

    protected void copyParametersFrom(ReportJobSource src, SchedulingModuleConfiguration configuration) {
        Map reportParameters = src.getParametersMap();
        ReportParameterValueBean[] params = configuration.getReportParametersTranslator().getBeanParameterValues(src.getReportUnitURI(), reportParameters);
        this.setParameters(params);
    }

    public void copyTo(ReportJobSource dest, String newReportUri, SchedulingModuleConfiguration configuration) {
        dest.setReportUnitURI(newReportUri);
        this.copyParametersMap(dest, newReportUri, configuration);
    }

    protected void copyParametersMap(ReportJobSource dest, String newReportUri, SchedulingModuleConfiguration configuration) {
        Map params = configuration.getReportParametersTranslator().getParameterValues(newReportUri, this.getParameters());
        dest.setParametersMap(params);
    }

    public String getReportUnitURI() {
        return this.reportUnitURI;
    }

    public void setReportUnitURI(String reportUnitURI) {
        this.reportUnitURI = reportUnitURI;
    }

    public ReportParameterValueBean[] getParameters() {
        return this.parameters;
    }

    public void setParameters(ReportParameterValueBean[] parameters) {
        this.parameters = parameters;
    }
}

