/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote;

import com.jaspersoft.jasperserver.remote.ManagementServices;
import com.jaspersoft.jasperserver.remote.ServicesUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractService {
    public static final String REMOTE_MANAGEMENT_SERVICES = "remoteManagementServices";
    private static final Log log = LogFactory.getLog(AbstractService.class);
    protected static ThreadLocal<AbstractService> context = new ThreadLocal();
    protected ApplicationContext applicationContext = null;
    private ManagementServices managementServices = null;
    private ServicesUtils servicesUtils = null;
    private Locale locale = null;
    private Map<String, DataSource> inputAttachments = new HashMap<String, DataSource>();
    private Map<String, DataSource> outputAttachments = new HashMap<String, DataSource>();
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public AbstractService(ApplicationContext ac) {
        this(ac, Locale.getDefault());
    }

    public AbstractService(ApplicationContext ac, Locale locale) {
        this.applicationContext = ac;
        this.locale = locale;
        this.servicesUtils = new ServicesUtils(this.applicationContext);
        context.set(this);
    }

    public ManagementServices getManagementServices() {
        if (this.managementServices == null) {
            this.managementServices = (ManagementServices)this.applicationContext.getBean(REMOTE_MANAGEMENT_SERVICES);
        }
        return this.managementServices;
    }

    public void setManagementServices(ManagementServices managementServices) {
        this.managementServices = managementServices;
    }

    public ServicesUtils getServicesUtils() {
        return this.servicesUtils;
    }

    public void setServicesUtils(ServicesUtils servicesUtils) {
        this.servicesUtils = servicesUtils;
    }

    public void setLocale(String requestedLocale) {
        try {
            if (requestedLocale != null) {
                String language = requestedLocale;
                String country = "";
                if (requestedLocale.indexOf("_") > 0) {
                    language = requestedLocale.substring(0, requestedLocale.indexOf("_"));
                    country = requestedLocale.substring(requestedLocale.indexOf("_") + 1);
                    this.setLocale(new Locale(language, country));
                } else {
                    this.setLocale(new Locale(language));
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("Unable to get requested locale (" + requestedLocale + ")"));
            this.setLocale(Locale.getDefault());
        }
    }

    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public static AbstractService getContext() {
        return context.get();
    }

    public String getMessage(String key) {
        return this.getMessage(key, new Object[0]);
    }

    public String getMessage(String key, Object[] args) {
        return this.getManagementServices().getMessage(key, args, this.getLocale());
    }

    public String getMessage(String key, Object[] args, String defMessage) {
        return this.getManagementServices().getMessageSource().getMessage(key, args, defMessage, this.getLocale());
    }

    public Map<String, DataSource> getInputAttachments() {
        return this.inputAttachments;
    }

    public Map<String, DataSource> getOutputAttachments() {
        return this.outputAttachments;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }
}

