/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.remote.ResourceActionResolver;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ResourceHandlerRegistry;
import com.jaspersoft.jasperserver.remote.ResourceResolverAdapter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class MapResourceHandlerRegistry
implements ResourceHandlerRegistry,
InitializingBean {
    private Map typeHandlers;
    private Map handlers;
    private Map resourceTypes;
    private ResourceActionResolver resourceActionResolver;

    public void setResourceActionResolver(ResourceActionResolver resourceActionResolver) {
        this.resourceActionResolver = resourceActionResolver;
    }

    public void afterPropertiesSet() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.handlers = new HashMap();
        this.resourceTypes = new HashMap();
        for (Map.Entry entry : this.typeHandlers.entrySet()) {
            String wsType = (String)entry.getKey();
            String handlerClassName = (String)entry.getValue();
            Class<?> handlerClass = Class.forName(handlerClassName);
            if (!ResourceHandler.class.isAssignableFrom(handlerClass)) {
                throw new JSException("Resource handler class " + handlerClassName + " does not implement com.jaspersoft.jasperserver.remote.ResourceHandler");
            }
            ResourceHandler handler = (ResourceHandler)handlerClass.newInstance();
            this.handlers.put(wsType, handler);
            Class resourceType = handler.getResourceType();
            this.resourceTypes.put(resourceType.getName(), wsType);
            ResourceResolverAdapter adapter = (ResourceResolverAdapter)((Object)handler);
            adapter.setResourceActionHandler(this.resourceActionResolver);
        }
    }

    public ResourceHandler getHandler(String wsType) {
        return (ResourceHandler)this.handlers.get(wsType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandler getHandler(Resource resource) {
        String resourceType = resource.getResourceType();
        String wsType = (String)this.resourceTypes.get(resourceType);
        if (wsType == null) {
            Map map = this.resourceTypes;
            synchronized (map) {
                wsType = this.determineWSType(resource);
                this.resourceTypes.put(resourceType, wsType);
            }
        }
        return this.getHandler(wsType);
    }

    protected String determineWSType(Resource resource) {
        Class itf;
        String wsType = null;
        LinkedList itfQueue = new LinkedList();
        Class<?>[] itfs = resource.getClass().getInterfaces();
        itfQueue.addAll(Arrays.asList(itfs));
        while (!itfQueue.isEmpty() && (wsType = (String)this.resourceTypes.get((itf = (Class)itfQueue.removeFirst()).getName())) == null) {
            Class<?>[] interfaces = itf.getInterfaces();
            itfQueue.addAll(Arrays.asList(interfaces));
        }
        return wsType;
    }

    public Map getTypeHandlers() {
        return this.typeHandlers;
    }

    public void setTypeHandlers(Map typeHandlers) {
        this.typeHandlers = typeHandlers;
    }
}

